/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitminers.extendedgears.datagen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.rabbitminers.extendedgears.ExtendedCogwheels;
import com.rabbitminers.extendedgears.base.data.CogwheelConstants;
import com.rabbitminers.extendedgears.base.data.ICogwheelMaterial;
import com.rabbitminers.extendedgears.base.datatypes.CogwheelMaterialList;
import com.rabbitminers.extendedgears.datagen.ExtendedCogwheelsRecipeProvider;
import com.rabbitminers.extendedgears.datagen.IRecipeConditionContainer;
import com.rabbitminers.extendedgears.datagen.forge.ExtendedCogwheelsStandardRecipeGenImpl;
import com.rabbitminers.extendedgears.registry.ExtendedCogwheelsBlocks;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCookingSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;

public class ExtendedCogwheelsStandardRecipeGen
extends ExtendedCogwheelsRecipeProvider {
    private static final String CRAFTING = "crafting/";
    private static final String BASE = "crafting/base/";
    private static final String TO_STANDARD = "crafting/to_standard/";
    private static final String FROM_SMALL = "crafting/from_small/";
    ExtendedCogwheelsRecipeProvider.GeneratedRecipe HALF_SHAFT = this.create((ItemProviderEntry<? extends ItemLike>)ExtendedCogwheelsBlocks.HALF_SHAFT_COGWHEEL).unlockedBy(ExtendedCogwheelsRecipeProvider.I::andesite).viaShapeless(b -> b.m_126209_(ExtendedCogwheelsRecipeProvider.I.andesite()).m_206419_(ExtendedCogwheelsRecipeProvider.I.planks()));
    ExtendedCogwheelsRecipeProvider.GeneratedRecipe LARGE_HALF_SHAFT = this.create((ItemProviderEntry<? extends ItemLike>)ExtendedCogwheelsBlocks.LARGE_HALF_SHAFT_COGWHEEL).unlockedBy(ExtendedCogwheelsRecipeProvider.I::andesite).viaShapeless(b -> b.m_126209_(ExtendedCogwheelsRecipeProvider.I.andesite()).m_206419_(ExtendedCogwheelsRecipeProvider.I.planks()).m_206419_(ExtendedCogwheelsRecipeProvider.I.planks()));
    ExtendedCogwheelsRecipeProvider.GeneratedRecipe SHAFTLESS = this.create((ItemProviderEntry<? extends ItemLike>)ExtendedCogwheelsBlocks.SHAFTLESS_COGWHEEL).unlockedBy(ExtendedCogwheelsRecipeProvider.I::andesite).viaShapeless(b -> b.m_206419_(ExtendedCogwheelsRecipeProvider.I.buttons()).m_206419_(ExtendedCogwheelsRecipeProvider.I.planks()));
    ExtendedCogwheelsRecipeProvider.GeneratedRecipe LARGE_SHAFTLESS = this.create((ItemProviderEntry<? extends ItemLike>)ExtendedCogwheelsBlocks.LARGE_SHAFTLESS_COGWHEEL).unlockedBy(ExtendedCogwheelsRecipeProvider.I::andesite).viaShapeless(b -> b.m_206419_(ExtendedCogwheelsRecipeProvider.I.buttons()).m_206419_(ExtendedCogwheelsRecipeProvider.I.planks()).m_206419_(ExtendedCogwheelsRecipeProvider.I.planks()));
    ExtendedCogwheelsRecipeProvider.GeneratedRecipe SMALL_TO_LARGE_HALF_SHAFT = this.smallToLargeRecipe(CogwheelConstants.HALF_SHAFT_COGWHEELS);
    ExtendedCogwheelsRecipeProvider.GeneratedRecipe SMALL_TO_LARGE_SHAFTLESS = this.smallToLargeRecipe(CogwheelConstants.SHAFTLESS_COGWHEELS);
    ExtendedCogwheelsRecipeProvider.GeneratedRecipe SHAFTLESS_TO_STANDARD = this.create((ItemProviderEntry<? extends ItemLike>)AllBlocks.COGWHEEL).unlockedBy(ExtendedCogwheelsRecipeProvider.I::andesite).viaShapeless(b -> b.m_126209_((ItemLike)ExtendedCogwheelsBlocks.SHAFTLESS_COGWHEEL.get()).m_206419_(ExtendedCogwheelsRecipeProvider.I.planks()));
    ExtendedCogwheelsRecipeProvider.GeneratedRecipe LARGE_SHAFTLESS_TO_STANDARD = this.create((ItemProviderEntry<? extends ItemLike>)AllBlocks.LARGE_COGWHEEL).unlockedBy(ExtendedCogwheelsRecipeProvider.I::andesite).viaShapeless(b -> b.m_126209_((ItemLike)ExtendedCogwheelsBlocks.LARGE_SHAFTLESS_COGWHEEL.get()).m_206419_(ExtendedCogwheelsRecipeProvider.I.planks()));
    ExtendedCogwheelsRecipeProvider.GeneratedRecipe PISTON_EXTENSION_POLE = this.create((ItemProviderEntry<? extends ItemLike>)AllBlocks.PISTON_EXTENSION_POLE).returns(8).unlockedBy(ExtendedCogwheelsRecipeProvider.I::andesite).viaShaped(b -> b.m_126127_(Character.valueOf('A'), ExtendedCogwheelsRecipeProvider.I.andesite()).m_206416_(Character.valueOf('P'), ItemTags.f_13168_).m_126130_("A").m_126130_("P").m_126130_("A"));

    @Deprecated
    private <T extends Enum<T>> ExtendedCogwheelsRecipeProvider.GeneratedRecipe cogwheelRecipe(T material, BlockEntry<? extends Block> cogwheel, boolean isLarge, TriFunction<ShapelessRecipeBuilder, T, Boolean, ShapelessRecipeBuilder> recipeTransformer) {
        return this.create(BASE + ((ICogwheelMaterial)((Object)material)).getIngredient().namespace().asId(), (ItemProviderEntry<? extends ItemLike>)cogwheel).unlockedBy(ExtendedCogwheelsRecipeProvider.I::andesite).whenTagsPopulated(((ICogwheelMaterial)((Object)material)).getRecipeTags()).viaShapeless(builder -> (ShapelessRecipeBuilder)recipeTransformer.apply(builder, (Object)material, (Object)isLarge));
    }

    @Deprecated
    private <T extends Enum<T>> Map<T, ExtendedCogwheelsRecipeProvider.GeneratedRecipe> craftedCogwheelMapper(CogwheelMaterialList<? extends Block, T> cogwheels, Class<T> materialType, boolean isLarge, TriFunction<ShapelessRecipeBuilder, T, Boolean, ShapelessRecipeBuilder> recipeTransformer) {
        return Arrays.stream((Enum[])materialType.getEnumConstants()).collect(Collectors.toMap(material -> material, material -> this.cogwheelRecipe(material, cogwheels.get(material), isLarge, recipeTransformer), (m1, m2) -> m1, () -> new EnumMap(materialType)));
    }

    @Deprecated
    private <T extends Enum<T>> CogwheelRecipePair<T> smallAndLargeRecipe(CogwheelMaterialList<? extends Block, T> smallCogwheels, CogwheelMaterialList<? extends Block, T> largeCogwheels, Class<T> materialType, TriFunction<ShapelessRecipeBuilder, T, Boolean, ShapelessRecipeBuilder> recipeTransformer) {
        return new CogwheelRecipePair<T>(this.craftedCogwheelMapper(smallCogwheels, materialType, false, recipeTransformer), this.craftedCogwheelMapper(largeCogwheels, materialType, true, recipeTransformer));
    }

    @Deprecated
    private <T extends Enum<T>, B extends Block> ExtendedCogwheelsRecipeProvider.GeneratedRecipe smallCogwheelToLarge(T material, BlockEntry<?> in, BlockEntry<?> out) {
        return this.create(FROM_SMALL + ((ICogwheelMaterial)((Object)material)).getIngredient().namespace().asId(), (ItemProviderEntry<? extends ItemLike>)out).unlockedBy(ExtendedCogwheelsRecipeProvider.I::andesite).whenTagsPopulated(((ICogwheelMaterial)((Object)material)).getRecipeTags()).viaShapeless(builder -> builder.m_126184_(((ICogwheelMaterial)((Object)material)).getIngredient().ingredient()).m_126209_((ItemLike)in.get()));
    }

    @Deprecated
    private <T extends Enum<T>> Map<T, ExtendedCogwheelsRecipeProvider.GeneratedRecipe> smallFromLarge(CogwheelMaterialList<? extends Block, T> smallCogwheels, CogwheelMaterialList<? extends Block, T> largeCogwheels, Class<T> materialType) {
        return Arrays.stream((Enum[])materialType.getEnumConstants()).collect(Collectors.toMap(material -> material, material -> this.smallCogwheelToLarge(material, smallCogwheels.get(material), largeCogwheels.get(material)), (m1, m2) -> m1, () -> new EnumMap(materialType)));
    }

    @Deprecated
    private <T extends Enum<T>> ExtendedCogwheelsRecipeProvider.GeneratedRecipe shaftlessToStandard(T material, BlockEntry<?> in, BlockEntry<?> out) {
        return this.create(TO_STANDARD + ((ICogwheelMaterial)((Object)material)).asId(), (ItemProviderEntry<? extends ItemLike>)out).unlockedBy(ExtendedCogwheelsRecipeProvider.I::andesite).whenTagsPopulated(((ICogwheelMaterial)((Object)material)).getRecipeTags()).viaShapeless(builder -> builder.m_126209_((ItemLike)in.get()).m_126209_(ExtendedCogwheelsRecipeProvider.I.shaft()));
    }

    @Deprecated
    private <T extends Enum<T>> Map<T, ExtendedCogwheelsRecipeProvider.GeneratedRecipe> shaftlessToStandard(CogwheelMaterialList<? extends Block, T> shaftless, CogwheelMaterialList<? extends Block, T> standard, Class<T> materialType) {
        return Arrays.stream((Enum[])materialType.getEnumConstants()).collect(Collectors.toMap(material -> material, material -> this.shaftlessToStandard(material, shaftless.get(material), standard.get(material)), (m1, m2) -> m1, () -> new EnumMap(materialType)));
    }

    private Couple<ExtendedCogwheelsRecipeProvider.GeneratedRecipe> cogwheelRecipes(Couple<BlockEntry<?>> blocks) {
        ExtendedCogwheelsRecipeProvider.GeneratedRecipe small = this.create((ItemProviderEntry<? extends ItemLike>)((ItemProviderEntry)blocks.getFirst())).unlockedBy(ExtendedCogwheelsRecipeProvider.I::andesite).viaShapeless(b -> b.m_126209_(ExtendedCogwheelsRecipeProvider.I.shaft()).m_206419_(ExtendedCogwheelsRecipeProvider.I.planks()));
        ExtendedCogwheelsRecipeProvider.GeneratedRecipe large = this.create((ItemProviderEntry<? extends ItemLike>)((ItemProviderEntry)blocks.getSecond())).unlockedBy(ExtendedCogwheelsRecipeProvider.I::andesite).viaShapeless(b -> b.m_126209_(ExtendedCogwheelsRecipeProvider.I.shaft()).m_206419_(ExtendedCogwheelsRecipeProvider.I.planks()).m_206419_(ExtendedCogwheelsRecipeProvider.I.planks()));
        return Couple.create((Object)small, (Object)large);
    }

    private ExtendedCogwheelsRecipeProvider.GeneratedRecipe smallToLargeRecipe(Couple<BlockEntry<?>> blocks) {
        return this.create("small_" + ((BlockEntry)blocks.getSecond()).getId().m_135815_() + "_to_large", (ItemProviderEntry<? extends ItemLike>)((ItemProviderEntry)blocks.getSecond())).unlockedBy(ExtendedCogwheelsRecipeProvider.I::andesite).viaShapeless(b -> b.m_126209_((ItemLike)((BlockEntry)blocks.getFirst()).get()).m_206419_(ExtendedCogwheelsRecipeProvider.I.planks()));
    }

    @Deprecated
    private <T extends Block, E extends Enum<E>> ExtendedCogwheelsRecipeProvider.GeneratedRecipe cogwheelSmeltingRecipe(CogwheelMaterialList<T, E> inputMaterialSet, E input, E output) {
        return this.create((ItemProviderEntry<? extends ItemLike>)inputMaterialSet.get(output)).withSuffix("_from_" + ((ICogwheelMaterial)((Object)input)).asId()).viaCooking((Supplier<? extends ItemLike>)inputMaterialSet.get(input)).rewardXP(1.0f).inBlastFurnace();
    }

    GeneratedRecipeBuilder create(Supplier<ItemLike> result) {
        return new GeneratedRecipeBuilder("/", result);
    }

    GeneratedRecipeBuilder create(String path, Supplier<ItemLike> result) {
        return new GeneratedRecipeBuilder(path, result);
    }

    GeneratedRecipeBuilder create(ResourceLocation result) {
        return new GeneratedRecipeBuilder("/", result);
    }

    GeneratedRecipeBuilder create(String path, ItemProviderEntry<? extends ItemLike> result) {
        return this.create(path, () -> result.get());
    }

    GeneratedRecipeBuilder create(ItemProviderEntry<? extends ItemLike> result) {
        return this.create(() -> result.get());
    }

    protected ExtendedCogwheelsStandardRecipeGen(DataGenerator pGenerator) {
        super(pGenerator);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static RecipeProvider create(DataGenerator gen) {
        return ExtendedCogwheelsStandardRecipeGenImpl.create(gen);
    }

    @NotNull
    public String m_6055_() {
        return "Extended Cogwheels Crafting Recipes";
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static IRecipeConditionContainer createContainer() {
        return ExtendedCogwheelsStandardRecipeGenImpl.createContainer();
    }

    public class GeneratedRecipeBuilder {
        private final String path;
        private String suffix;
        private Supplier<? extends ItemLike> result;
        private ResourceLocation compatDatagenOutput;
        private Supplier<ItemPredicate> unlockedBy;
        IRecipeConditionContainer recipeConditions;
        private int amount;

        private GeneratedRecipeBuilder(String path) {
            this.path = path;
            this.suffix = "";
            this.amount = 1;
            this.recipeConditions = ExtendedCogwheelsStandardRecipeGen.createContainer();
        }

        public GeneratedRecipeBuilder(String path, Supplier<? extends ItemLike> result) {
            this(path);
            this.result = result;
        }

        public GeneratedRecipeBuilder(String path, ResourceLocation result) {
            this(path);
            this.compatDatagenOutput = result;
        }

        GeneratedRecipeBuilder returns(int amount) {
            this.amount = amount;
            return this;
        }

        GeneratedRecipeBuilder unlockedBy(Supplier<? extends ItemLike> item) {
            this.unlockedBy = () -> ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)item.get()}).m_45077_();
            return this;
        }

        GeneratedRecipeBuilder unlockedByTag(Supplier<TagKey<Item>> tag) {
            this.unlockedBy = () -> ItemPredicate.Builder.m_45068_().m_204145_((TagKey)tag.get()).m_45077_();
            return this;
        }

        @SafeVarargs
        final GeneratedRecipeBuilder whenTagsPopulated(TagKey<Item> ... tagKey) {
            this.recipeConditions.whenTagsFilled(tagKey);
            return this;
        }

        GeneratedRecipeBuilder withSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        ExtendedCogwheelsRecipeProvider.GeneratedRecipe viaShaped(UnaryOperator<ShapedRecipeBuilder> builder) {
            return ExtendedCogwheelsStandardRecipeGen.this.register(consumer -> {
                ShapedRecipeBuilder b = (ShapedRecipeBuilder)builder.apply(ShapedRecipeBuilder.m_126118_((ItemLike)this.result.get(), (int)this.amount));
                if (this.unlockedBy != null) {
                    b.m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.m_126011_((ItemPredicate[])new ItemPredicate[]{this.unlockedBy.get()}));
                }
                b.m_126140_(consumer, this.createLocation("crafting"));
            });
        }

        ExtendedCogwheelsRecipeProvider.GeneratedRecipe viaShapeless(UnaryOperator<ShapelessRecipeBuilder> builder) {
            return ExtendedCogwheelsStandardRecipeGen.this.register(consumer -> {
                ShapelessRecipeBuilder b = (ShapelessRecipeBuilder)builder.apply(ShapelessRecipeBuilder.m_126191_((ItemLike)this.result.get(), (int)this.amount));
                if (this.unlockedBy != null) {
                    b.m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.m_126011_((ItemPredicate[])new ItemPredicate[]{this.unlockedBy.get()}));
                }
                b.m_126140_(result -> consumer.accept(this.recipeConditions.isEmpty() ? result : new ConditionalRecipeResult((FinishedRecipe)result, this.getRegistryName(), this.recipeConditions)), this.createLocation("crafting"));
            });
        }

        private ResourceLocation createSimpleLocation(String recipeType) {
            return ExtendedCogwheels.asResource(recipeType + "/" + this.getRegistryName().m_135815_() + this.suffix);
        }

        private ResourceLocation createLocation(String recipeType) {
            return ExtendedCogwheels.asResource(recipeType + "/" + this.path + "/" + this.getRegistryName().m_135815_() + this.suffix);
        }

        private ResourceLocation getRegistryName() {
            return this.compatDatagenOutput == null ? RegisteredObjects.getKeyOrThrow((Item)this.result.get().m_5456_()) : this.compatDatagenOutput;
        }

        GeneratedCookingRecipeBuilder viaCooking(Supplier<? extends ItemLike> item) {
            return this.unlockedBy(item).viaCookingIngredient(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)item.get()}));
        }

        GeneratedCookingRecipeBuilder viaCookingTag(Supplier<TagKey<Item>> tag) {
            return this.unlockedByTag(tag).viaCookingIngredient(() -> Ingredient.m_204132_((TagKey)((TagKey)tag.get())));
        }

        GeneratedCookingRecipeBuilder viaCookingIngredient(Supplier<Ingredient> ingredient) {
            return new GeneratedCookingRecipeBuilder(ingredient);
        }

        class GeneratedCookingRecipeBuilder {
            private final Supplier<Ingredient> ingredient;
            private float exp;
            private int cookingTime;
            private final SimpleCookingSerializer<?> FURNACE = RecipeSerializer.f_44091_;
            private final SimpleCookingSerializer<?> SMOKER = RecipeSerializer.f_44093_;
            private final SimpleCookingSerializer<?> BLAST = RecipeSerializer.f_44092_;
            private final SimpleCookingSerializer<?> CAMPFIRE = RecipeSerializer.f_44094_;

            GeneratedCookingRecipeBuilder(Supplier<Ingredient> ingredient) {
                this.ingredient = ingredient;
                this.cookingTime = 200;
                this.exp = 0.0f;
            }

            GeneratedCookingRecipeBuilder forDuration(int duration) {
                this.cookingTime = duration;
                return this;
            }

            GeneratedCookingRecipeBuilder rewardXP(float xp) {
                this.exp = xp;
                return this;
            }

            ExtendedCogwheelsRecipeProvider.GeneratedRecipe inFurnace() {
                return this.inFurnace(b -> b);
            }

            ExtendedCogwheelsRecipeProvider.GeneratedRecipe inFurnace(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                return this.create(this.FURNACE, builder, 1.0f);
            }

            ExtendedCogwheelsRecipeProvider.GeneratedRecipe inSmoker() {
                return this.inSmoker(b -> b);
            }

            ExtendedCogwheelsRecipeProvider.GeneratedRecipe inSmoker(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                this.create(this.FURNACE, builder, 1.0f);
                this.create(this.CAMPFIRE, builder, 3.0f);
                return this.create(this.SMOKER, builder, 0.5f);
            }

            ExtendedCogwheelsRecipeProvider.GeneratedRecipe inBlastFurnace() {
                return this.inBlastFurnace(b -> b);
            }

            ExtendedCogwheelsRecipeProvider.GeneratedRecipe inBlastFurnace(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                this.create(this.FURNACE, builder, 1.0f);
                return this.create(this.BLAST, builder, 0.5f);
            }

            private ExtendedCogwheelsRecipeProvider.GeneratedRecipe create(SimpleCookingSerializer<?> serializer, UnaryOperator<SimpleCookingRecipeBuilder> builder, float cookingTimeModifier) {
                return ExtendedCogwheelsStandardRecipeGen.this.register(consumer -> {
                    boolean isOtherMod = GeneratedRecipeBuilder.this.compatDatagenOutput != null;
                    SimpleCookingRecipeBuilder b = (SimpleCookingRecipeBuilder)builder.apply(SimpleCookingRecipeBuilder.m_126248_((Ingredient)this.ingredient.get(), (ItemLike)(isOtherMod ? Items.f_42329_ : GeneratedRecipeBuilder.this.result.get()), (float)this.exp, (int)((int)((float)this.cookingTime * cookingTimeModifier)), (SimpleCookingSerializer)serializer));
                    if (GeneratedRecipeBuilder.this.unlockedBy != null) {
                        b.m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.m_126011_((ItemPredicate[])new ItemPredicate[]{GeneratedRecipeBuilder.this.unlockedBy.get()}));
                    }
                    b.m_126140_(result -> consumer.accept(result), GeneratedRecipeBuilder.this.createSimpleLocation(RegisteredObjects.getKeyOrThrow((RecipeSerializer)serializer).m_135815_()));
                });
            }
        }
    }

    private record CogwheelRecipePair<T extends Enum<T>>(Map<T, ExtendedCogwheelsRecipeProvider.GeneratedRecipe> small, Map<T, ExtendedCogwheelsRecipeProvider.GeneratedRecipe> large) {
    }

    private static class ConditionalRecipeResult
    implements FinishedRecipe {
        private final FinishedRecipe wrapped;
        private final ResourceLocation outputOverride;
        private final IRecipeConditionContainer conditions;

        public ConditionalRecipeResult(FinishedRecipe wrapped, ResourceLocation outputOverride, IRecipeConditionContainer conditions) {
            this.wrapped = wrapped;
            this.outputOverride = outputOverride;
            this.conditions = conditions;
        }

        public ResourceLocation m_6445_() {
            return this.wrapped.m_6445_();
        }

        public RecipeSerializer<?> m_6637_() {
            return this.wrapped.m_6637_();
        }

        public JsonObject m_5860_() {
            return this.wrapped.m_5860_();
        }

        public ResourceLocation m_6448_() {
            return this.wrapped.m_6448_();
        }

        public void m_7917_(@NotNull JsonObject object) {
            this.wrapped.m_7917_(object);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", this.outputOverride.toString());
            object.add("result", (JsonElement)jsonObject);
            this.conditions.write(object);
        }
    }
}

