/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitminers.extendedgears.cogwheels.materials;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.rabbitminers.extendedgears.base.networking.PlayerSelection;
import com.rabbitminers.extendedgears.base.networking.S2CPacket;
import com.rabbitminers.extendedgears.base.util.Env;
import com.rabbitminers.extendedgears.cogwheels.materials.ClientCogwheelMaterial;
import com.rabbitminers.extendedgears.cogwheels.materials.CogwheelMaterial;
import com.rabbitminers.extendedgears.registry.ExtendedCogwheelsPackets;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public class CogwheelMaterialManager {
    public static Map<ResourceLocation, CogwheelMaterial> MATERIALS = new HashMap<ResourceLocation, CogwheelMaterial>();
    public static Map<ResourceLocation, ClientCogwheelMaterial> CLIENT_MATERIALS = new HashMap<ResourceLocation, ClientCogwheelMaterial>();
    public static Map<Item, ResourceLocation> ITEM_TO_MATERIALS = new IdentityHashMap<Item, ResourceLocation>();
    private static boolean dirty = false;

    @Nullable
    public static ResourceLocation of(ItemStack stack) {
        if (dirty) {
            CogwheelMaterialManager.fillItemMap();
            dirty = false;
        }
        return ITEM_TO_MATERIALS.get(stack.m_41720_());
    }

    public static CogwheelMaterial of(ResourceLocation location) {
        return MATERIALS.get(location);
    }

    @Nullable
    public static ClientCogwheelMaterial clientOf(ResourceLocation location) {
        return CLIENT_MATERIALS.get(location);
    }

    public static int getStressLimit(ResourceLocation location) {
        CogwheelMaterial material = CogwheelMaterialManager.of(location);
        if (material == null) {
            return Integer.MAX_VALUE;
        }
        return material.stressLimit;
    }

    public static int getSpeedLimit(ResourceLocation location) {
        CogwheelMaterial material = CogwheelMaterialManager.of(location);
        if (material == null) {
            return (Integer)AllConfigs.server().kinetics.maxRotationSpeed.get();
        }
        return material.stressLimit;
    }

    public static void toBuffer(FriendlyByteBuf buffer) {
        buffer.m_130130_(MATERIALS.size());
        for (Map.Entry<ResourceLocation, CogwheelMaterial> entry : MATERIALS.entrySet()) {
            buffer.m_130085_(entry.getKey());
            entry.getValue().toBuffer(buffer);
        }
    }

    public static void fromBuffer(FriendlyByteBuf buffer) {
        CogwheelMaterialManager.clear();
        int size = buffer.m_130242_();
        for (int i = 0; i < size; ++i) {
            ResourceLocation id = buffer.m_130281_();
            int itemSize = buffer.m_130242_();
            NonNullList items = NonNullList.m_122779_();
            for (int j = 0; j < itemSize; ++j) {
                items.add((Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            int speedLimit = buffer.readInt();
            int stressLimit = buffer.readInt();
            CogwheelMaterial material = MATERIALS.get(id);
            if (material == null) continue;
            material.items = items;
            material.speedLimit = speedLimit;
            material.stressLimit = stressLimit;
        }
        dirty = true;
    }

    public static void clear() {
        ITEM_TO_MATERIALS.clear();
    }

    public static void syncTo(ServerPlayer player) {
        ExtendedCogwheelsPackets.PACKETS.sendTo(PlayerSelection.of(player), (S2CPacket)new SyncPacket());
    }

    public static void syncToAll() {
        ExtendedCogwheelsPackets.PACKETS.sendTo(PlayerSelection.all(), (S2CPacket)new SyncPacket());
    }

    public static void applyReloadListener(Map<ResourceLocation, JsonElement> map) {
        CogwheelMaterialManager.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            CogwheelMaterial type;
            JsonElement element = entry.getValue();
            if (!element.isJsonObject() || (type = MATERIALS.get(entry.getKey())) == null) continue;
            JsonObject object = element.getAsJsonObject();
            type.updateFromJson(object);
        }
        dirty = true;
    }

    public static void setupClientCogwheelMaterials() {
        if (Env.CURRENT == Env.CLIENT) {
            for (Map.Entry<ResourceLocation, CogwheelMaterial> entry : MATERIALS.entrySet()) {
                CLIENT_MATERIALS.put(entry.getKey(), ClientCogwheelMaterial.fromMaterial(entry.getValue()));
            }
        }
    }

    public static void fillItemMap() {
        for (CogwheelMaterial material : MATERIALS.values()) {
            for (Ingredient ingredient : material.items) {
                for (ItemStack itemStack : ingredient.m_43908_()) {
                    ITEM_TO_MATERIALS.put(itemStack.m_41720_(), material.id);
                }
            }
        }
    }

    public static class SyncPacket
    implements S2CPacket {
        private FriendlyByteBuf buffer;

        public SyncPacket() {
        }

        public SyncPacket(FriendlyByteBuf buffer) {
            this.buffer = buffer;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            CogwheelMaterialManager.toBuffer(buffer);
        }

        @Override
        public void handle(Minecraft mc) {
            try {
                CogwheelMaterialManager.fromBuffer(this.buffer);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

