/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitminers.extendedgears.cogwheels;

import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.StitchedSprite;
import com.rabbitminers.extendedgears.cogwheels.CogwheelModelKey;
import com.rabbitminers.extendedgears.cogwheels.materials.ClientCogwheelMaterial;
import com.rabbitminers.extendedgears.cogwheels.materials.CogwheelMaterialManager;
import com.rabbitminers.extendedgears.registry.ExtendedCogwheelsPartials;
import com.simibubi.create.foundation.model.BakedModelHelper;
import com.simibubi.create.foundation.render.SuperByteBufferCache;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class DynamicCogwheelRenderer {
    public static final SuperByteBufferCache.Compartment<CogwheelModelKey> COGWHEEL = new SuperByteBufferCache.Compartment();
    public static final StitchedSprite STRIPPED_LOG_TEMPLATE = new StitchedSprite(new ResourceLocation("block/stripped_spruce_log"));
    public static final StitchedSprite STRIPPED_LOG_TOP_TEMPLATE = new StitchedSprite(new ResourceLocation("block/stripped_spruce_log_top"));
    public static final String[] LOG_SUFFIXES = new String[]{"_log", "_stem", "_block"};

    @NotNull
    public static BakedModel generateModel(CogwheelModelKey key) {
        ClientCogwheelMaterial material = CogwheelMaterialManager.clientOf(key.material());
        PartialModel model = material != null ? material.getModel(key.large()) : DynamicCogwheelRenderer.standardCogwheelModel(key.large());
        return DynamicCogwheelRenderer.generateModel(model.get(), key.material());
    }

    public static PartialModel standardCogwheelModel(boolean isLarge) {
        return isLarge ? ExtendedCogwheelsPartials.LARGE_COGWHEEL : ExtendedCogwheelsPartials.COGWHEEL;
    }

    public static BakedModel generateModel(BakedModel template, ResourceLocation id) {
        Reference2ReferenceOpenHashMap map = new Reference2ReferenceOpenHashMap();
        String path = id.m_135815_();
        if (path.endsWith("_planks")) {
            String namespace = id.m_135827_();
            String wood = path.substring(0, path.length() - 7);
            BlockState logBlockState = DynamicCogwheelRenderer.getStrippedLogState(namespace, wood);
            map.put(STRIPPED_LOG_TEMPLATE.get(), DynamicCogwheelRenderer.getSpriteOnSide(logBlockState, Direction.SOUTH));
            map.put(STRIPPED_LOG_TOP_TEMPLATE.get(), DynamicCogwheelRenderer.getSpriteOnSide(logBlockState, Direction.UP));
        } else {
            ClientCogwheelMaterial material = CogwheelMaterialManager.clientOf(id);
            if (material == null) {
                return BakedModelHelper.generateModel((BakedModel)template, sprite -> null);
            }
            material.textures().forEach((arg_0, arg_1) -> DynamicCogwheelRenderer.lambda$generateModel$1((Map)map, arg_0, arg_1));
        }
        return BakedModelHelper.generateModel((BakedModel)template, ((Map)map)::get);
    }

    public static BlockState getStrippedLogState(String namespace, String wood) {
        for (String suffix : LOG_SUFFIXES) {
            Optional<BlockState> state = Registry.f_122824_.m_203636_(ResourceKey.m_135785_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation(namespace, "stripped_" + wood + suffix))).map(Holder::m_203334_).map(Block::m_49966_);
            if (!state.isPresent()) continue;
            return state.get();
        }
        return Blocks.f_50010_.m_49966_();
    }

    public static TextureAtlasSprite getSpriteOnSide(BlockState state, Direction side) {
        BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(state);
        if (model == null) {
            return null;
        }
        RandomSource random = RandomSource.m_216327_();
        random.m_188584_(42L);
        List quads = model.m_213637_(state, side, random);
        if (!quads.isEmpty()) {
            return ((BakedQuad)quads.get(0)).m_173410_();
        }
        random.m_188584_(42L);
        quads = model.m_213637_(state, null, random);
        if (!quads.isEmpty()) {
            for (BakedQuad quad : quads) {
                if (quad.m_111306_() != side) continue;
                return quad.m_173410_();
            }
        }
        return model.m_6160_();
    }

    private static /* synthetic */ void lambda$generateModel$1(Map map, StitchedSprite old, StitchedSprite replacement) {
        map.put(old.get(), replacement.get());
    }
}

