/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitminers.extendedgears.base.data.data_fixers;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.rabbitminers.extendedgears.base.util.StringHelpers;
import com.rabbitminers.extendedgears.registry.ExtendedCogwheelsBlocks;
import com.simibubi.create.AllBlocks;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.Optional;
import net.minecraft.util.datafix.fixes.References;
import org.jetbrains.annotations.Nullable;

public class CogwheelBlockDataFixer
extends DataFix {
    private final String name;

    public CogwheelBlockDataFixer(Schema outputSchema, String name) {
        super(outputSchema, false);
        this.name = name;
    }

    public TypeRewriteRule makeRule() {
        return TypeRewriteRule.seq((TypeRewriteRule)this.fixTypeEverywhereTyped(this.name + " for block_state", this.getInputSchema().getType(References.f_16783_), typed -> typed.update(DSL.remainderFinder(), dynamic -> {
            Optional optional = dynamic.get("Name").asString().result();
            String fixBlock = CogwheelBlockDataFixer.fixBlock(optional);
            if (fixBlock != null) {
                dynamic = dynamic.set("Name", dynamic.createString(fixBlock));
                return dynamic;
            }
            return dynamic;
        })), (TypeRewriteRule[])new TypeRewriteRule[0]);
    }

    @Nullable
    public static String fixBlock(Optional<String> optional) {
        String size;
        if (optional.isEmpty()) {
            return null;
        }
        String original = optional.get();
        String string = size = original.contains("large_") ? ":large_" : ":";
        if (CogwheelBlockDataFixer.isValidCogwheel(original)) {
            return null;
        }
        if (StringHelpers.containsAll(original, "shaftless_cogwheel")) {
            return "extendedgears" + size + "shaftless_cogwheel";
        }
        if (StringHelpers.containsAll(original, "half_shaft", "cogwheel")) {
            return "extendedgears" + size + "half_shaft_cogwheel";
        }
        if (original.contains("_cogwheel")) {
            return "create" + size + "cogwheel";
        }
        return null;
    }

    public static boolean isValidCogwheel(String block) {
        BlockEntry[] validCogwheels;
        for (BlockEntry cogwheel : validCogwheels = new BlockEntry[]{AllBlocks.COGWHEEL, AllBlocks.LARGE_COGWHEEL, ExtendedCogwheelsBlocks.SHAFTLESS_COGWHEEL, ExtendedCogwheelsBlocks.LARGE_SHAFTLESS_COGWHEEL, ExtendedCogwheelsBlocks.HALF_SHAFT_COGWHEEL, ExtendedCogwheelsBlocks.LARGE_HALF_SHAFT_COGWHEEL}) {
            if (!block.equals(cogwheel.getId().toString())) continue;
            return true;
        }
        return false;
    }
}

