/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitminers.extendedgears.base.data.data_fixer_api;

import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.templates.TypeTemplate;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.rabbitminers.extendedgears.base.data.data_fixer_api.DataFixesInternals;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.util.datafix.DataFixTypes;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

@ApiStatus.Internal
public final class DataFixesInternalsImpl
extends DataFixesInternals {
    @NotNull
    private final Schema latestVanillaSchema;
    private DataFixesInternals.DataFixerEntry dataFixer;

    public DataFixesInternalsImpl(@NotNull Schema latestVanillaSchema) {
        this.latestVanillaSchema = latestVanillaSchema;
        this.dataFixer = null;
    }

    @Override
    public void registerFixer(@Range(from=0L, to=0x7FFFFFFFL) int currentVersion, @NotNull DataFixer dataFixer) {
        if (this.dataFixer != null) {
            throw new IllegalArgumentException("Extended Cogwheels already has a registered data fixer");
        }
        this.dataFixer = new DataFixesInternals.DataFixerEntry(dataFixer, currentVersion);
    }

    @Override
    @Nullable
    public DataFixesInternals.DataFixerEntry getFixerEntry() {
        return this.dataFixer;
    }

    @Override
    @NotNull
    public Schema createBaseSchema() {
        return new Schema(0, this.latestVanillaSchema){

            public Map<String, Supplier<TypeTemplate>> registerBlockEntities(Schema schema) {
                Map map = super.registerBlockEntities(schema);
                super.registerSimple(map, "extendedgears:customcogwheeltileentity");
                return map;
            }
        };
    }

    @Override
    @NotNull
    public CompoundTag updateWithAllFixers(@NotNull DataFixTypes dataFixTypes, @NotNull CompoundTag compound) {
        Dynamic current = new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)compound);
        if (this.dataFixer != null) {
            int modDataVersion = DataFixesInternals.getModDataVersion(compound);
            current = this.dataFixer.dataFixer().update(dataFixTypes.m_14504_(), current, modDataVersion, this.dataFixer.currentVersion());
        }
        return (CompoundTag)current.getValue();
    }

    @Override
    @NotNull
    public CompoundTag addModDataVersions(@NotNull CompoundTag compound) {
        if (this.dataFixer != null) {
            compound.m_128405_("ExtendedCogwheels_DataVersion", this.dataFixer.currentVersion());
        }
        return compound;
    }
}

