/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.handcrafted.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import earth.terrarium.handcrafted.client.block.chair.couch.CouchModel;
import earth.terrarium.handcrafted.common.block.chair.couch.CouchBlockEntity;
import earth.terrarium.handcrafted.common.block.chair.couch.ExpandableCouchBlock;
import earth.terrarium.handcrafted.common.block.property.CouchShape;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.state.properties.Property;

public class OptimizedCouchRenderer
implements BlockEntityRenderer<CouchBlockEntity> {
    public static final Map<Item, Material> OBJECT_TO_TEXTURE = new Object2ObjectOpenHashMap();
    public static OptimizedCouchRenderer INSTANCE = null;
    private final CouchModel couchSingle;
    private final CouchModel couchCorner;
    private final CouchModel couchInvertedCorner;
    private final CouchModel couchLeft;
    private final CouchModel couchMiddle;
    private final CouchModel couchRight;

    public OptimizedCouchRenderer(BlockEntityRendererProvider.Context ctx) {
        EntityModelSet modelSet = ctx.m_173585_();
        this.couchSingle = new CouchModel(modelSet.m_171103_(CouchModel.LAYER_LOCATION_SINGLE));
        this.couchCorner = new CouchModel(modelSet.m_171103_(CouchModel.LAYER_LOCATION_CORNER));
        this.couchInvertedCorner = new CouchModel(modelSet.m_171103_(CouchModel.LAYER_LOCATION_INVERTED_CORNER));
        this.couchLeft = new CouchModel(modelSet.m_171103_(CouchModel.LAYER_LOCATION_LEFT));
        this.couchMiddle = new CouchModel(modelSet.m_171103_(CouchModel.LAYER_LOCATION_MIDDLE));
        this.couchRight = new CouchModel(modelSet.m_171103_(CouchModel.LAYER_LOCATION_RIGHT));
        INSTANCE = this;
    }

    public void render(CouchBlockEntity entity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Item block = entity.m_58900_().m_60734_().m_5456_();
        Item cushion = entity.getStack().m_41720_();
        CouchShape shape = (CouchShape)entity.m_58900_().m_61143_((Property)ExpandableCouchBlock.COUCH_SHAPE);
        this.doRender(block, cushion, (Direction)entity.m_58900_().m_61143_((Property)ExpandableCouchBlock.FACING), shape, poseStack, bufferSource, packedLight, packedOverlay);
    }

    public void doRender(Item block, Item cushion, Direction direction, CouchShape shape, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        CouchModel model = switch (shape) {
            default -> throw new IncompatibleClassChangeError();
            case CouchShape.SINGLE -> this.couchSingle;
            case CouchShape.LEFT -> this.couchLeft;
            case CouchShape.MIDDLE -> this.couchMiddle;
            case CouchShape.RIGHT -> this.couchRight;
            case CouchShape.INNER_LEFT, CouchShape.INNER_RIGHT -> this.couchCorner;
            case CouchShape.OUTER_LEFT, CouchShape.OUTER_RIGHT -> this.couchInvertedCorner;
        };
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 1.5, 0.5);
        poseStack.m_85845_(switch (direction) {
            case Direction.EAST -> {
                switch (shape) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case SINGLE: 
                    case LEFT: 
                    case MIDDLE: 
                    case RIGHT: 
                    case INNER_LEFT: 
                    case OUTER_LEFT: {
                        yield Vector3f.f_122225_.m_122240_(270.0f);
                    }
                    case INNER_RIGHT: 
                    case OUTER_RIGHT: 
                }
                yield Vector3f.f_122225_.m_122240_(180.0f);
            }
            case Direction.SOUTH -> {
                switch (shape) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case SINGLE: 
                    case LEFT: 
                    case MIDDLE: 
                    case RIGHT: 
                    case INNER_LEFT: 
                    case OUTER_LEFT: {
                        yield Vector3f.f_122225_.m_122240_(180.0f);
                    }
                    case INNER_RIGHT: 
                    case OUTER_RIGHT: 
                }
                yield Vector3f.f_122225_.m_122240_(90.0f);
            }
            case Direction.WEST -> {
                switch (shape) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case SINGLE: 
                    case LEFT: 
                    case MIDDLE: 
                    case RIGHT: 
                    case INNER_LEFT: 
                    case OUTER_LEFT: {
                        yield Vector3f.f_122225_.m_122240_(90.0f);
                    }
                    case INNER_RIGHT: 
                    case OUTER_RIGHT: 
                }
                yield Vector3f.f_122225_.m_122240_(0.0f);
            }
            default -> {
                switch (shape) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case SINGLE: 
                    case LEFT: 
                    case MIDDLE: 
                    case RIGHT: 
                    case INNER_LEFT: 
                    case OUTER_LEFT: {
                        yield Vector3f.f_122225_.m_122240_(0.0f);
                    }
                    case INNER_RIGHT: 
                    case OUTER_RIGHT: 
                }
                yield Vector3f.f_122225_.m_122240_(270.0f);
            }
        });
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
        Material blockTexture = OBJECT_TO_TEXTURE.get(block);
        model.m_7695_(poseStack, blockTexture.m_119194_(buffer, RenderType::m_110452_), packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        if (cushion != Items.f_41852_) {
            Material cushionTexture = OBJECT_TO_TEXTURE.get(cushion);
            model.m_7695_(poseStack, cushionTexture.m_119194_(buffer, RenderType::m_110452_), packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        poseStack.m_85849_();
    }
}

