/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.handcrafted.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import com.teamresourceful.resourcefullib.client.CloseablePoseStack;
import earth.terrarium.handcrafted.client.block.chair.woodenbench.WoodenBenchModel;
import earth.terrarium.handcrafted.common.block.chair.couch.ExpandableCouchBlock;
import earth.terrarium.handcrafted.common.block.chair.woodenbench.WoodenBenchBlockEntity;
import earth.terrarium.handcrafted.common.block.property.CouchShape;
import net.mehvahdjukaar.every_compat.modules.handcrafted.renderer.OptimizedTableRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class OptimizedBenchRenderer
implements BlockEntityRenderer<WoodenBenchBlockEntity> {
    public static OptimizedBenchRenderer INSTANCE = null;
    private final WoodenBenchModel single;
    private final WoodenBenchModel corner;
    private final WoodenBenchModel inverted_corner;
    private final WoodenBenchModel left;
    private final WoodenBenchModel middle;
    private final WoodenBenchModel right;
    protected ModelPart withCushion;

    public OptimizedBenchRenderer(BlockEntityRendererProvider.Context ctx) {
        INSTANCE = this;
        this.single = new WoodenBenchModel(ctx.m_173585_().m_171103_(WoodenBenchModel.LAYER_LOCATION_SINGLE));
        this.withCushion = this.single.getMain().m_171324_("with_cushion");
        this.corner = new WoodenBenchModel(ctx.m_173585_().m_171103_(WoodenBenchModel.LAYER_LOCATION_CORNER));
        this.withCushion = this.corner.getMain().m_171324_("with_cushion");
        this.inverted_corner = new WoodenBenchModel(ctx.m_173585_().m_171103_(WoodenBenchModel.LAYER_LOCATION_INVERTED_CORNER));
        this.withCushion = this.inverted_corner.getMain().m_171324_("with_cushion");
        this.left = new WoodenBenchModel(ctx.m_173585_().m_171103_(WoodenBenchModel.LAYER_LOCATION_INVERTED_CORNER));
        this.withCushion = this.left.getMain().m_171324_("with_cushion");
        this.middle = new WoodenBenchModel(ctx.m_173585_().m_171103_(WoodenBenchModel.LAYER_LOCATION_INVERTED_CORNER));
        this.withCushion = this.middle.getMain().m_171324_("with_cushion");
        this.right = new WoodenBenchModel(ctx.m_173585_().m_171103_(WoodenBenchModel.LAYER_LOCATION_INVERTED_CORNER));
        this.withCushion = this.right.getMain().m_171324_("with_cushion");
    }

    public void render(WoodenBenchBlockEntity entity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        EntityModelSet modelSet = Minecraft.m_91087_().m_167973_();
        CouchShape shape = (CouchShape)entity.m_58900_().m_61143_((Property)ExpandableCouchBlock.COUCH_SHAPE);
        WoodenBenchModel model = switch (shape) {
            case CouchShape.OUTER_LEFT, CouchShape.OUTER_RIGHT -> new WoodenBenchModel(modelSet.m_171103_(WoodenBenchModel.LAYER_LOCATION_INVERTED_CORNER));
            case CouchShape.INNER_RIGHT, CouchShape.INNER_LEFT -> new WoodenBenchModel(modelSet.m_171103_(WoodenBenchModel.LAYER_LOCATION_CORNER));
            case CouchShape.MIDDLE -> new WoodenBenchModel(modelSet.m_171103_(WoodenBenchModel.LAYER_LOCATION_MIDDLE));
            case CouchShape.LEFT -> new WoodenBenchModel(modelSet.m_171103_(WoodenBenchModel.LAYER_LOCATION_LEFT));
            case CouchShape.RIGHT -> new WoodenBenchModel(modelSet.m_171103_(WoodenBenchModel.LAYER_LOCATION_RIGHT));
            case CouchShape.SINGLE -> new WoodenBenchModel(modelSet.m_171103_(WoodenBenchModel.LAYER_LOCATION_SINGLE));
            default -> throw new IncompatibleClassChangeError();
        };
        Item block = entity.m_58900_().m_60734_().m_5456_();
        Item cushion = entity.getStack().m_41720_();
        this.doRender(block, cushion, model, (Direction)entity.m_58900_().m_61143_((Property)ExpandableCouchBlock.FACING), shape, poseStack, bufferSource, packedLight, packedOverlay);
    }

    public void doRender(Item block, Item cushion, WoodenBenchModel model, Direction direction, CouchShape shape, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        try (CloseablePoseStack ignored = new CloseablePoseStack(poseStack);){
            poseStack.m_85837_(0.5, 1.5, 0.5);
            poseStack.m_85845_(switch (direction) {
                case Direction.EAST -> {
                    switch (shape) {
                        case OUTER_LEFT: 
                        case INNER_RIGHT: 
                        case MIDDLE: 
                        case LEFT: 
                        case RIGHT: 
                        case SINGLE: {
                            yield Vector3f.f_122225_.m_122240_(90.0f);
                        }
                        case INNER_LEFT: {
                            yield Vector3f.f_122225_.m_122240_(180.0f);
                        }
                        case OUTER_RIGHT: {
                            yield Vector3f.f_122225_.m_122240_(0.0f);
                        }
                    }
                    throw new IncompatibleClassChangeError();
                }
                case Direction.SOUTH -> {
                    switch (shape) {
                        case OUTER_LEFT: 
                        case INNER_RIGHT: 
                        case MIDDLE: 
                        case LEFT: 
                        case RIGHT: 
                        case SINGLE: {
                            yield Vector3f.f_122225_.m_122240_(0.0f);
                        }
                        case INNER_LEFT: {
                            yield Vector3f.f_122225_.m_122240_(90.0f);
                        }
                        case OUTER_RIGHT: {
                            yield Vector3f.f_122225_.m_122240_(270.0f);
                        }
                    }
                    throw new IncompatibleClassChangeError();
                }
                case Direction.WEST -> {
                    switch (shape) {
                        case OUTER_LEFT: 
                        case INNER_RIGHT: 
                        case MIDDLE: 
                        case LEFT: 
                        case RIGHT: 
                        case SINGLE: {
                            yield Vector3f.f_122225_.m_122240_(270.0f);
                        }
                        case INNER_LEFT: {
                            yield Vector3f.f_122225_.m_122240_(0.0f);
                        }
                        case OUTER_RIGHT: {
                            yield Vector3f.f_122225_.m_122240_(180.0f);
                        }
                    }
                    throw new IncompatibleClassChangeError();
                }
                default -> {
                    switch (shape) {
                        case OUTER_LEFT: 
                        case INNER_RIGHT: 
                        case MIDDLE: 
                        case LEFT: 
                        case RIGHT: 
                        case SINGLE: {
                            yield Vector3f.f_122225_.m_122240_(180.0f);
                        }
                        case INNER_LEFT: {
                            yield Vector3f.f_122225_.m_122240_(270.0f);
                        }
                        case OUTER_RIGHT: {
                            yield Vector3f.f_122225_.m_122240_(90.0f);
                        }
                    }
                    throw new IncompatibleClassChangeError();
                }
            });
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
            Material blockTexture = OptimizedTableRenderer.OBJECT_TO_TEXTURE.get(block);
            VertexConsumer vertex = blockTexture.m_119194_(buffer, RenderType::m_110452_);
            model.m_7695_(poseStack, vertex, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            if (!cushion.toString().equals("minecraft:air")) {
                Material cushionTexture = OptimizedTableRenderer.OBJECT_TO_TEXTURE.get(cushion);
                model.m_7695_(poseStack, cushionTexture.m_119194_(buffer, RenderType::m_110452_), packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            } else {
                model.getMain().m_171324_((String)"with_cushion").f_104207_ = false;
            }
        }
    }
}

