/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.forge.quark;

import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.content.building.block.HedgeBlock;
import vazkii.quark.content.building.module.HedgesModule;

public class CompatHedgeBlock
extends FenceBlock {
    private final QuarkModule module;
    private final Block leaf;
    private BooleanSupplier enabledSupplier = () -> true;
    public static final BooleanProperty EXTEND = HedgeBlock.EXTEND;

    public CompatHedgeBlock(QuarkModule module, Block fence, Block leaf) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)fence));
        this.module = module;
        this.leaf = leaf;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)EXTEND, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_53329_(BlockState state, boolean isSideSolid, @Nonnull Direction direction) {
        return state.m_204336_(HedgesModule.hedgesTag);
    }

    public boolean canSustainPlant(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull Direction facing, @Nonnull IPlantable plantable) {
        return facing == Direction.UP && (Boolean)state.m_61143_((Property)f_52313_) == false && plantable.getPlantType(world, pos) == PlantType.PLAINS;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level blockader = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        BlockPos down = blockpos.m_7495_();
        BlockState downState = blockader.m_8055_(down);
        return (BlockState)super.m_5573_(context).m_61124_((Property)EXTEND, (Comparable)Boolean.valueOf(downState.m_60734_() instanceof HedgeBlock));
    }

    @Nonnull
    public BlockState m_7417_(BlockState stateIn, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor worldIn, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)f_52313_)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return facing == Direction.DOWN ? (BlockState)stateIn.m_61124_((Property)EXTEND, (Comparable)Boolean.valueOf(facingState.m_60734_() instanceof HedgeBlock)) : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{EXTEND});
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockColor getBlockColor(BlockColors colors) {
        BlockState leafState = this.leaf.m_49966_();
        return (state, world, pos, tintIndex) -> colors.m_92577_(leafState, world, pos, tintIndex);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemColor getItemColor(ItemColors colors) {
        ItemStack leafStack = new ItemStack((ItemLike)this.leaf);
        return (stack, tintIndex) -> colors.m_92676_(leafStack, tintIndex);
    }

    public void m_49811_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        if (this.isEnabled() || group == CreativeModeTab.f_40754_) {
            super.m_49811_(group, items);
        }
    }

    private boolean isEnabled() {
        return true;
    }

    public QuarkModule getModule() {
        return this.module;
    }

    public CompatHedgeBlock setCondition(BooleanSupplier enabledSupplier) {
        this.enabledSupplier = enabledSupplier;
        return this;
    }

    public boolean doesConditionApply() {
        return this.enabledSupplier.getAsBoolean();
    }
}

