/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.api;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.CompatModule;
import net.mehvahdjukaar.every_compat.api.EntrySet;
import net.mehvahdjukaar.every_compat.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.dynamicpack.ServerDynamicResourcesHandler;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.ClientPlatformHelper;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class SimpleModule
extends CompatModule {
    private final String shortId;
    private final Map<String, EntrySet<?, ?, ?>> entries = new LinkedHashMap();
    protected int bloat = 0;

    public SimpleModule(String modId, String shortId) {
        super(modId);
        this.shortId = shortId;
    }

    @Override
    public int bloatAmount() {
        return this.bloat;
    }

    public void addEntry(EntrySet<?, ?, ?> entryHolder) {
        this.entries.put(entryHolder.getName(), entryHolder);
        EveryCompat.addEntryType(entryHolder.getTypeClass(), entryHolder.getChildKey(this));
    }

    public Collection<EntrySet<?, ?, ?>> getEntries() {
        return this.entries.values();
    }

    public EntrySet<?, ?, ?> getEntry(String name) {
        EntrySet<?, ?, ?> e = this.entries.get(name);
        if (e == null) {
            throw new UnsupportedOperationException(String.format("This module does not have entries of type %s", name));
        }
        return e;
    }

    @Override
    public String shortenedId() {
        return this.shortId;
    }

    @Override
    public void addTranslations(ClientDynamicResourcesHandler clientDynamicResourcesHandler, AfterLanguageLoadEvent lang) {
        this.getEntries().forEach(e -> e.addTranslations(this, lang));
    }

    @Override
    public void registerWoodBlocks(Registrator<Block> registry, Collection<WoodType> woodTypes) {
        this.getEntries().forEach(e -> e.registerWoodBlocks(this, registry, woodTypes));
        this.getEntries().forEach(e -> this.bloat += e.blocks.size());
    }

    @Override
    public void registerLeavesBlocks(Registrator<Block> registry, Collection<LeavesType> leavesTypes) {
        this.getEntries().forEach(e -> e.registerLeavesBlocks(this, registry, leavesTypes));
        this.getEntries().forEach(e -> this.bloat += e.blocks.size());
    }

    @Override
    public void registerItems(Registrator<Item> registry) {
        this.getEntries().forEach(e -> e.registerItems(this, registry));
    }

    @Override
    public void registerTiles(Registrator<BlockEntityType<?>> registry) {
        this.getEntries().forEach(e -> e.registerTiles(this, registry));
    }

    @Override
    public void addDynamicServerResources(ServerDynamicResourcesHandler handler, ResourceManager manager) {
        this.getEntries().forEach(e -> {
            e.generateLootTables(this, (DynamicDataPack)handler.dynamicPack, manager);
            e.generateRecipes(this, (DynamicDataPack)handler.dynamicPack, manager);
            e.generateTags(this, (DynamicDataPack)handler.dynamicPack, manager);
        });
    }

    @Override
    public void addDynamicClientResources(ClientDynamicResourcesHandler handler, ResourceManager manager) {
        this.getEntries().forEach(e -> e.generateModels(this, handler, manager));
        this.getEntries().forEach(e -> e.generateTextures(this, handler, manager));
    }

    @Override
    public void onClientSetup() {
        this.getEntries().forEach(EntrySet::setRenderLayer);
    }

    @Override
    public void onModSetup() {
        this.getEntries().forEach(EntrySet::setupExistingTiles);
    }

    @Override
    public void registerBlockEntityRenderers(ClientPlatformHelper.BlockEntityRendererEvent event) {
        this.getEntries().forEach(e -> e.registerEntityRenderers(this, event));
    }

    public static void appendTileEntityBlocks(BlockEntityType<?> be, Collection<? extends Block> blocks) {
        be.f_58915_ = new HashSet(be.f_58915_);
        be.f_58915_.addAll(blocks);
    }
}

