/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.api;

import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.AbstractSimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.CompatModule;
import net.mehvahdjukaar.every_compat.misc.ResourcesUtils;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.ClientPlatformHelper;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesProvider;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.core.Registry;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemOnlyEntrySet<T extends BlockType, I extends Item>
extends AbstractSimpleEntrySet<T, Block, I> {
    protected final Supplier<@Nullable I> baseItem;
    protected final Function<T, @Nullable I> itemFactory;

    public ItemOnlyEntrySet(Class<T> type, String name, @Nullable String prefix, Function<T, I> itemFactory, Supplier<@Nullable I> baseItem, Supplier<T> baseType, Supplier<CreativeModeTab> tab, @Nullable @Nullable BiFunction<T, ResourceManager, Pair<List<Palette>, @Nullable AnimationMetadataSection>> paletteSupplier, @Nullable Consumer<BlockTypeResTransformer<T>> extraTransform, Predicate<T> condition) {
        super(type, name, prefix, baseType, tab, paletteSupplier, extraTransform, condition);
        this.itemFactory = itemFactory;
        this.baseItem = baseItem;
    }

    @Override
    protected Map<T, ? extends ItemLike> getMainEntryMap() {
        return this.items;
    }

    @Override
    public boolean isDisabled() {
        return this.getBaseItem() == null;
    }

    public I getBaseItem() {
        return (I)((Item)this.baseItem.get());
    }

    @Override
    public void addTranslations(CompatModule module, AfterLanguageLoadEvent lang) {
        this.items.forEach((w, v) -> LangBuilder.addDynamicEntry((AfterLanguageLoadEvent)lang, (String)("item_type." + module.getModId() + "." + this.typeName), (BlockType)w, (Item)v));
    }

    @Override
    public void registerBlocks(CompatModule module, Registrator<Block> registry, Collection<T> woodTypes) {
    }

    @NotNull
    public String getItemName(T w) {
        String name;
        if (this.prefix != null) {
            name = this.prefix + "_" + w.getTypeName();
            if (!this.postfix.isEmpty()) {
                name = name + "_" + this.postfix;
            }
        } else {
            name = w.getTypeName() + "_" + this.postfix;
        }
        return name;
    }

    @Override
    public void registerItems(CompatModule module, Registrator<Item> registry) {
        BlockTypeRegistry typeRegistry = BlockSetAPI.getTypeRegistry((Class)this.type);
        for (BlockType w : typeRegistry.getValues()) {
            Item item;
            String name = this.getItemName(w);
            String fullName = module.shortenedId() + "/" + w.getNamespace() + "/" + name;
            if (w.isVanilla() || module.isEntryAlreadyRegistered(name, w, (Registry<?>)Registry.f_122824_) || !this.condition.test(w) || (item = (Item)this.itemFactory.apply(w)) == null) continue;
            this.items.put(w, item);
            registry.register(EveryCompat.res(fullName), (Object)item);
            w.addChild(this.getChildKey(module), (Object)item);
            Object object = w.getChild(this.getChildKey(module));
        }
    }

    @Override
    public void registerTiles(CompatModule module, Registrator<BlockEntityType<?>> registry) {
        I base = this.getBaseItem();
        if (base == null || base == Items.f_41852_) {
            throw new UnsupportedOperationException("Base block cant be null (" + this.typeName + " for " + module.modId + " module)");
        }
        ((BlockType)this.baseType.get()).addChild(this.getChildKey(module), base);
    }

    @Override
    public void setRenderLayer() {
    }

    @Override
    public void generateLootTables(CompatModule module, DynamicDataPack pack, ResourceManager manager) {
    }

    @Override
    public void generateModels(CompatModule module, DynClientResourcesProvider handler, ResourceManager manager) {
        if (this.isDisabled()) {
            return;
        }
        ResourcesUtils.addItemModels(module.getModId(), manager, handler, this.items, (BlockType)this.baseType.get(), this.extraTransform);
    }

    @Override
    public void registerEntityRenderers(CompatModule simpleModule, ClientPlatformHelper.BlockEntityRendererEvent event) {
    }

    public static <T extends BlockType, I extends Item> Builder<T, I> builder(Class<T> type, String name, Supplier<I> baseItem, Supplier<T> baseType, Function<T, I> itemSupplier) {
        return new Builder<T, I>(type, name, null, baseType, baseItem, itemSupplier);
    }

    public static <T extends BlockType, I extends Item> Builder<T, I> builder(Class<T> type, String name, String prefix, Supplier<I> baseItem, Supplier<T> baseType, Function<T, I> itemSupplier) {
        return new Builder<T, I>(type, name, prefix, baseType, baseItem, itemSupplier);
    }

    public static class Builder<T extends BlockType, I extends Item>
    extends AbstractSimpleEntrySet.Builder<Builder<T, I>, T, Block, I> {
        protected final Supplier<@Nullable I> baseItem;
        protected final Function<T, I> itemFactory;

        protected Builder(Class<T> type, String name, @Nullable String prefix, Supplier<T> baseType, Supplier<I> baseItem, Function<T, I> itemFactory) {
            super(type, name, prefix, baseType);
            this.baseItem = baseItem;
            this.itemFactory = itemFactory;
        }

        public ItemOnlyEntrySet<T, I> build() {
            ItemOnlyEntrySet<T, I> e = new ItemOnlyEntrySet<T, I>(this.type, this.name, this.prefix, this.itemFactory, this.baseItem, this.baseType, this.tab, this.palette, this.extraModelTransform, this.condition);
            e.recipeLocations.addAll(this.recipes);
            e.tags.putAll(this.tags);
            e.textures.addAll(this.textures);
            return e;
        }
    }
}

