/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.api;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.CompatModule;
import net.mehvahdjukaar.every_compat.api.EntrySet;
import net.mehvahdjukaar.every_compat.configs.WoodConfigs;
import net.mehvahdjukaar.every_compat.misc.ResourcesUtils;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesProvider;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSimpleEntrySet<T extends BlockType, B extends Block, I extends Item>
extends EntrySet<T, B, I> {
    protected final Class<T> type;
    protected final Pattern nameScheme;
    protected final Supplier<T> baseType;
    public final String postfix;
    @Nullable
    public final String prefix;
    protected final Supplier<CreativeModeTab> tab;
    protected final Map<ResourceLocation, Set<ResourceKey<?>>> tags = new HashMap();
    protected final Set<Supplier<ResourceLocation>> recipeLocations = new HashSet<Supplier<ResourceLocation>>();
    protected final Set<Pair<ResourceLocation, @Nullable ResourceLocation>> textures = new HashSet<Pair<ResourceLocation, ResourceLocation>>();
    @Nullable
    protected final @Nullable BiFunction<T, ResourceManager, Pair<List<Palette>, @Nullable AnimationMetadataSection>> paletteSupplier;
    @Nullable
    protected final Consumer<BlockTypeResTransformer<T>> extraTransform;
    protected final Predicate<T> condition;

    protected AbstractSimpleEntrySet(Class<T> type, String name, @Nullable String prefix, Supplier<T> baseType, Supplier<CreativeModeTab> tab, @Nullable @Nullable BiFunction<T, ResourceManager, Pair<List<Palette>, @Nullable AnimationMetadataSection>> paletteSupplier, @Nullable Consumer<BlockTypeResTransformer<T>> extraTransform, Predicate<T> condition) {
        super((String)(prefix == null ? "" : prefix + (name.isEmpty() ? "" : "_")) + name);
        this.postfix = name;
        this.prefix = prefix;
        this.tab = tab;
        this.baseType = baseType;
        this.type = type;
        this.extraTransform = extraTransform;
        this.paletteSupplier = paletteSupplier;
        this.nameScheme = this.prefix != null ? (this.postfix.isEmpty() ? Pattern.compile("^" + prefix + "_(.+?)$") : Pattern.compile("^" + prefix + "_(.+?)_" + this.postfix + "$")) : Pattern.compile("^(.+?)_" + this.postfix + "$");
        this.condition = condition;
    }

    public abstract boolean isDisabled();

    @Override
    public Class<T> getTypeClass() {
        return this.type;
    }

    public T getBaseType() {
        return (T)((BlockType)this.baseType.get());
    }

    public String getEquivalentBlock(CompatModule module, String oldName, String woodFrom) {
        BlockType w;
        String wood = this.parseWoodType(oldName);
        if (wood != null && (w = BlockSetAPI.getBlockSet(this.getTypeClass()).get(new ResourceLocation(woodFrom, wood))) != null) {
            return module.shortenedId() + "/" + w.getNamespace() + "/" + oldName;
        }
        return null;
    }

    @Nullable
    public String parseWoodType(String oldName) {
        Matcher m = this.nameScheme.matcher(oldName);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    protected CreativeModeTab getTab(T w, B b) {
        return WoodConfigs.isEntryEnabled(w, b) ? (EveryCompat.MOD_TAB != null ? EveryCompat.MOD_TAB : this.tab.get()) : null;
    }

    @Override
    public void generateTags(CompatModule module, DynamicDataPack pack, ResourceManager manager) {
        if (this.isDisabled()) {
            return;
        }
        if (!this.tags.isEmpty()) {
            for (Map.Entry<ResourceLocation, Set<ResourceKey<?>>> tb : this.tags.entrySet()) {
                SimpleTagBuilder builder = SimpleTagBuilder.of((ResourceLocation)tb.getKey());
                for (Map.Entry<T, ItemLike> entry : this.getMainEntryMap().entrySet()) {
                    if (!WoodConfigs.isEntryEnabled((BlockType)entry.getKey(), (Object)entry.getValue())) continue;
                    builder.addEntry((Object)entry.getValue());
                }
                for (ResourceKey resourceKey : tb.getValue()) {
                    pack.addTag(builder, resourceKey);
                }
            }
        }
    }

    @Override
    public void generateRecipes(CompatModule module, DynamicDataPack pack, ResourceManager manager) {
        if (this.isDisabled()) {
            return;
        }
        int i = 0;
        for (Supplier<ResourceLocation> r : this.recipeLocations) {
            ResourceLocation res = r.get();
            try {
                ResourcesUtils.addBlocksRecipes(manager, pack, this.items, res, (BlockType)this.baseType.get(), i++);
            }
            catch (Exception e) {
                EveryCompat.LOGGER.error("Failed to generate recipes for template at location {} ", (Object)res);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateTextures(CompatModule module, DynClientResourcesProvider handler, ResourceManager manager) {
        if (this.isDisabled()) {
            return;
        }
        if (this.textures.isEmpty()) {
            return;
        }
        ArrayList<TextureImage> images = new ArrayList<TextureImage>();
        try {
            HashMap respriters = new HashMap();
            for (Pair<ResourceLocation, ResourceLocation> pair : this.textures) {
                ResourceLocation textureId = (ResourceLocation)pair.getFirst();
                try {
                    Respriter r;
                    TextureImage main = TextureImage.open((ResourceManager)manager, (ResourceLocation)textureId);
                    images.add(main);
                    ResourceLocation m = (ResourceLocation)pair.getSecond();
                    if (m != null) {
                        TextureImage mask = TextureImage.open((ResourceManager)manager, (ResourceLocation)m);
                        images.add(main);
                        r = Respriter.masked((TextureImage)main, (TextureImage)mask);
                    } else {
                        r = Respriter.of((TextureImage)main);
                    }
                    respriters.put(textureId, r);
                }
                catch (Exception e) {
                    EveryCompat.LOGGER.error("Failed to read block texture at: {}", pair, (Object)e);
                }
            }
            for (Map.Entry entry : this.getMainEntryMap().entrySet()) {
                ItemLike b = (ItemLike)entry.getValue();
                BlockType w = (BlockType)entry.getKey();
                ResourceLocation blockId = Utils.getID((Object)b);
                List targetPalette = null;
                AnimationMetadataSection animation = null;
                if (this.paletteSupplier != null) {
                    Pair<List<Palette>, AnimationMetadataSection> pal = this.paletteSupplier.apply(w, manager);
                    animation = (AnimationMetadataSection)pal.getSecond();
                    targetPalette = (List)pal.getFirst();
                } else {
                    ItemLike m = w.mainChild();
                    Block mainBlock = null;
                    if (m instanceof Block) {
                        Block bb;
                        mainBlock = bb = (Block)m;
                    } else if (m instanceof BlockItem) {
                        BlockItem bii = (BlockItem)m;
                        mainBlock = bii.m_40614_();
                    }
                    if (mainBlock == null) {
                        throw new UnsupportedOperationException("You need to provide a palette supplier for non wood type based blocks");
                    }
                    try (TextureImage plankTexture22 = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)mainBlock));){
                        targetPalette = Palette.fromAnimatedImage((TextureImage)plankTexture22);
                        animation = plankTexture22.getMetadata();
                    }
                    catch (Exception plankTexture22) {
                        // empty catch block
                    }
                }
                if (targetPalette == null) {
                    EveryCompat.LOGGER.error("Could not get texture palette for block {} : ", (Object)b);
                    continue;
                }
                AnimationMetadataSection finalAnimation = animation;
                List finalTargetPalette = targetPalette;
                int oldSize = ((Palette)finalTargetPalette.get(0)).size();
                for (Map.Entry re : respriters.entrySet()) {
                    if (oldSize != ((Palette)finalTargetPalette.get(0)).size()) {
                        throw new RuntimeException("This should not happen");
                    }
                    String oldPath = ((ResourceLocation)re.getKey()).m_135815_();
                    String newId = BlockTypeResTransformer.replaceTypeNoNamespace((String)oldPath, (BlockType)w, (ResourceLocation)blockId, (String)((BlockType)this.baseType.get()).getTypeName());
                    Respriter respriter = (Respriter)re.getValue();
                    if (this.type == WoodType.class) {
                        module.addWoodTexture((WoodType)w, handler, manager, newId, () -> respriter.recolorWithAnimation(finalTargetPalette, finalAnimation));
                        continue;
                    }
                    handler.addTextureIfNotPresent(manager, newId, () -> respriter.recolorWithAnimation(finalTargetPalette, finalAnimation));
                }
            }
        }
        catch (Exception e) {
            EveryCompat.LOGGER.error("Could not generate any block texture for entry set {} : ", (Object)module.modRes(this.getName()), (Object)e);
        }
        finally {
            for (TextureImage t : images) {
                t.close();
            }
        }
    }

    protected abstract Map<T, ? extends ItemLike> getMainEntryMap();

    protected static class Builder<BL extends Builder<BL, T, B, I>, T extends BlockType, B extends Block, I extends Item> {
        protected final Class<T> type;
        protected final Supplier<T> baseType;
        protected final String name;
        @Nullable
        protected final String prefix;
        protected Supplier<CreativeModeTab> tab = () -> CreativeModeTab.f_40750_;
        @Nullable
        protected @Nullable BiFunction<T, ResourceManager, Pair<List<Palette>, @Nullable AnimationMetadataSection>> palette = null;
        protected final Map<ResourceLocation, Set<ResourceKey<?>>> tags = new HashMap();
        protected final Set<Supplier<ResourceLocation>> recipes = new HashSet<Supplier<ResourceLocation>>();
        protected final Set<Pair<ResourceLocation, @Nullable ResourceLocation>> textures = new HashSet<Pair<ResourceLocation, ResourceLocation>>();
        @Nullable
        protected Consumer<BlockTypeResTransformer<T>> extraModelTransform = null;
        protected Predicate<T> condition = w -> true;

        protected Builder(Class<T> type, String name, @Nullable String prefix, Supplier<T> baseType) {
            this.baseType = baseType;
            this.name = name;
            this.prefix = prefix;
            this.type = type;
        }

        public BL addModelTransform(Consumer<BlockTypeResTransformer<T>> transform) {
            this.extraModelTransform = transform;
            return (BL)this;
        }

        public BL requiresChildren(String ... childKeys) {
            this.addCondition(w -> {
                for (String c : childKeys) {
                    if (w.getChild(c) != null) continue;
                    return false;
                }
                return true;
            });
            return (BL)this;
        }

        public BL addCondition(Predicate<T> condition) {
            this.condition = condition;
            return (BL)this;
        }

        public BL setTab(Supplier<CreativeModeTab> tab) {
            this.tab = tab;
            return (BL)this;
        }

        public BL addTag(ResourceLocation location, ResourceKey<?> registry) {
            Set s = this.tags.computeIfAbsent(location, b -> new HashSet());
            s.add(registry);
            return (BL)this;
        }

        public BL addTag(TagKey<?> tag, ResourceKey<?> registry) {
            this.addTag(tag.f_203868_(), registry);
            return (BL)this;
        }

        public BL addRecipe(ResourceLocation resourceLocation) {
            this.recipes.add(() -> resourceLocation);
            return (BL)this;
        }

        public BL addTexture(ResourceLocation resourceLocation) {
            this.textures.add((Pair<ResourceLocation, ResourceLocation>)Pair.of((Object)resourceLocation, null));
            return (BL)this;
        }

        public BL addTextureM(ResourceLocation textureLocation, ResourceLocation maskLocation) {
            this.textures.add((Pair<ResourceLocation, ResourceLocation>)Pair.of((Object)textureLocation, (Object)maskLocation));
            return (BL)this;
        }

        public BL setPalette(BiFunction<T, ResourceManager, Pair<List<Palette>, @Nullable AnimationMetadataSection>> paletteProvider) {
            this.palette = paletteProvider;
            return (BL)this;
        }

        public BL createPaletteFromOak(Consumer<Palette> paletteTransform) {
            return this.createPaletteFromChild(paletteTransform, "planks");
        }

        public BL createPaletteFromChild(Consumer<Palette> paletteTransform, String childKey) {
            return this.setPalette((w, m) -> {
                Pair pair;
                block8: {
                    TextureImage plankTexture = TextureImage.open((ResourceManager)m, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)m, (Block)w.getBlockOfThis(childKey)));
                    try {
                        List targetPalette = Palette.fromAnimatedImage((TextureImage)plankTexture);
                        targetPalette.forEach(paletteTransform);
                        pair = Pair.of((Object)targetPalette, (Object)plankTexture.getMetadata());
                        if (plankTexture == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (plankTexture != null) {
                                try {
                                    plankTexture.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(String.format("Failed to generate palette for %s : %s", w, e));
                        }
                    }
                    plankTexture.close();
                }
                return pair;
            });
        }
    }
}

