/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.registry;

import com.teamabnormals.blueprint.core.util.registry.BiomeSubRegistryHelper;
import com.teamabnormals.environmental.core.Environmental;
import com.teamabnormals.environmental.core.other.EnvironmentalGeneration;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import javax.annotation.Nullable;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="environmental", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EnvironmentalBiomes {
    public static final BiomeSubRegistryHelper HELPER = (BiomeSubRegistryHelper)Environmental.REGISTRY_HELPER.getBiomeSubHelper();
    public static final BiomeSubRegistryHelper.KeyedBiome MARSH = HELPER.createBiome("marsh", EnvironmentalBiomes::marsh);
    public static final BiomeSubRegistryHelper.KeyedBiome BLOSSOM_WOODS = HELPER.createBiome("blossom_woods", () -> EnvironmentalBiomes.blossomBiome(false));
    public static final BiomeSubRegistryHelper.KeyedBiome BLOSSOM_VALLEYS = HELPER.createBiome("blossom_valleys", () -> EnvironmentalBiomes.blossomBiome(true));
    public static final BiomeSubRegistryHelper.KeyedBiome PINE_BARRENS = HELPER.createBiome("pine_barrens", () -> EnvironmentalBiomes.pineBarrens(false, false));
    public static final BiomeSubRegistryHelper.KeyedBiome SNOWY_PINE_BARRENS = HELPER.createBiome("snowy_pine_barrens", () -> EnvironmentalBiomes.pineBarrens(true, false));
    public static final BiomeSubRegistryHelper.KeyedBiome OLD_GROWTH_PINE_BARRENS = HELPER.createBiome("old_growth_pine_barrens", () -> EnvironmentalBiomes.pineBarrens(false, true));
    public static final BiomeSubRegistryHelper.KeyedBiome SNOWY_OLD_GROWTH_PINE_BARRENS = HELPER.createBiome("snowy_old_growth_pine_barrens", () -> EnvironmentalBiomes.pineBarrens(true, true));
    public static final BiomeSubRegistryHelper.KeyedBiome PINE_SLOPES = HELPER.createBiome("pine_slopes", EnvironmentalBiomes::pineSlopes);

    private static Biome marsh() {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder();
        EnvironmentalGeneration.marsh(generation);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawns);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawns);
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_217012_, 10, 2, 5));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20517_, 4, 2, 3));
        return EnvironmentalBiomes.biome(Biome.Precipitation.RAIN, 0.8f, 0.9f, 6263617, 6975545, 6134398, 2302743, 12638463, spawns, generation, Musics.m_11653_((SoundEvent)SoundEvents.f_215730_));
    }

    private static Biome blossomBiome(boolean valley) {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder();
        EnvironmentalGeneration.blossomWoods(generation, valley);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawns);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawns);
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20507_, 1, 1, 2));
        spawns.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)EnvironmentalEntityTypes.KOI.get(), 8, 1, 1));
        return EnvironmentalBiomes.biome(Biome.Precipitation.RAIN, 0.45f, 0.8f, 5938278, 5216182, 335411, spawns, generation, null);
    }

    private static Biome pineBarrens(boolean snowy, boolean oldGrowth) {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder();
        EnvironmentalGeneration.pineBarrens(generation, snowy, oldGrowth);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawns);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawns);
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 8, 4, 4));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20517_, 4, 2, 3));
        return EnvironmentalBiomes.biome(snowy ? Biome.Precipitation.SNOW : Biome.Precipitation.RAIN, snowy ? -0.2f : 0.4f, snowy ? 0.4f : 0.6f, snowy ? 8828286 : (oldGrowth ? 9221482 : 9484136), snowy ? 6789454 : 7578444, 4159204, 329011, 12638463, spawns, generation, null);
    }

    private static Biome pineSlopes() {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder();
        EnvironmentalGeneration.pineSlopes(generation);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawns);
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20517_, 4, 2, 3));
        return EnvironmentalBiomes.biome(Biome.Precipitation.RAIN, 0.4f, 0.3f, 4159204, 329011, spawns, generation, null);
    }

    private static Biome biome(Biome.Precipitation precipitation, float temperature, float downfall, int waterColor, int waterFogColor, MobSpawnSettings.Builder spawns, BiomeGenerationSettings.Builder generation, @Nullable Music music) {
        return new Biome.BiomeBuilder().m_47597_(precipitation).m_47609_(temperature).m_47611_(downfall).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(waterColor).m_48037_(waterFogColor).m_48019_(12638463).m_48040_(EnvironmentalBiomes.calculateSkyColor(temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(music).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(generation.m_47831_()).m_47592_();
    }

    private static Biome biome(Biome.Precipitation precipitation, float temperature, float downfall, int foliageColor, int waterColor, int waterFogColor, MobSpawnSettings.Builder spawns, BiomeGenerationSettings.Builder generation, @Nullable Music music) {
        return new Biome.BiomeBuilder().m_47597_(precipitation).m_47609_(temperature).m_47611_(downfall).m_47603_(new BiomeSpecialEffects.Builder().m_48043_(foliageColor).m_48034_(waterColor).m_48037_(waterFogColor).m_48019_(12638463).m_48040_(EnvironmentalBiomes.calculateSkyColor(temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(music).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(generation.m_47831_()).m_47592_();
    }

    private static Biome biome(Biome.Precipitation precipitation, float temperature, float downfall, int grassColor, int foliageColor, int waterColor, int waterFogColor, int fogColor, MobSpawnSettings.Builder spawns, BiomeGenerationSettings.Builder generation, @Nullable Music music) {
        return new Biome.BiomeBuilder().m_47597_(precipitation).m_47609_(temperature).m_47611_(downfall).m_47603_(new BiomeSpecialEffects.Builder().m_48045_(grassColor).m_48043_(foliageColor).m_48034_(waterColor).m_48037_(waterFogColor).m_48019_(fogColor).m_48040_(EnvironmentalBiomes.calculateSkyColor(temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(music).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(generation.m_47831_()).m_47592_();
    }

    private static int calculateSkyColor(float temperature) {
        float clampedTemp = Mth.m_14036_((float)(temperature / 3.0f), (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - clampedTemp * 0.05f), (float)(0.5f + clampedTemp * 0.1f), (float)1.0f);
    }
}

