/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.registry;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.MobSpawnSettingsBuilder;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="environmental", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EnvironmentalBiomeModifierTypes {
    public static final DeferredRegister<Codec<? extends BiomeModifier>> BIOME_MODIFIER_SERIALIZERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"environmental");
    public static final RegistryObject<Codec<InvertedRemoveSpawnsBiomeModifier>> REMOVE_SPAWNS_INVERTED = BIOME_MODIFIER_SERIALIZERS.register("remove_spawns_inverted", () -> RecordCodecBuilder.create(builder -> builder.group((App)Biome.f_47432_.fieldOf("inverted_biomes").forGetter(InvertedRemoveSpawnsBiomeModifier::biomes), (App)RegistryCodecs.m_206277_((ResourceKey)ForgeRegistries.Keys.ENTITY_TYPES).fieldOf("entity_types").forGetter(InvertedRemoveSpawnsBiomeModifier::entityTypes)).apply((Applicative)builder, InvertedRemoveSpawnsBiomeModifier::new)));
    public static final RegistryObject<Codec<InvertedRemoveSpawnsIgnoreBiomeModifier>> REMOVE_SPAWNS_INVERTED_WITH_IGNORE = BIOME_MODIFIER_SERIALIZERS.register("remove_spawns_inverted_ignore", () -> RecordCodecBuilder.create(builder -> builder.group((App)Biome.f_47432_.fieldOf("inverted_biomes").forGetter(InvertedRemoveSpawnsIgnoreBiomeModifier::biomes), (App)Biome.f_47432_.fieldOf("ignored_biomes").forGetter(InvertedRemoveSpawnsIgnoreBiomeModifier::ignoredBiomes), (App)RegistryCodecs.m_206277_((ResourceKey)ForgeRegistries.Keys.ENTITY_TYPES).fieldOf("entity_types").forGetter(InvertedRemoveSpawnsIgnoreBiomeModifier::entityTypes)).apply((Applicative)builder, InvertedRemoveSpawnsIgnoreBiomeModifier::new)));
    public static final RegistryObject<Codec<AddSpawnsIgnoreBiomeModifier>> ADD_SPAWNS_WITH_IGNORE = BIOME_MODIFIER_SERIALIZERS.register("add_spawns_ignore", () -> RecordCodecBuilder.create(builder -> builder.group((App)Biome.f_47432_.fieldOf("biomes").forGetter(AddSpawnsIgnoreBiomeModifier::biomes), (App)Biome.f_47432_.fieldOf("ignored_biomes").forGetter(AddSpawnsIgnoreBiomeModifier::ignoredBiomes), (App)new ExtraCodecs.EitherCodec(MobSpawnSettings.SpawnerData.f_48403_.listOf(), MobSpawnSettings.SpawnerData.f_48403_).xmap(either -> (List)either.map(Function.identity(), List::of), list -> list.size() == 1 ? Either.right((Object)((MobSpawnSettings.SpawnerData)list.get(0))) : Either.left((Object)list)).fieldOf("spawners").forGetter(AddSpawnsIgnoreBiomeModifier::spawners)).apply((Applicative)builder, AddSpawnsIgnoreBiomeModifier::new)));
    public static final RegistryObject<Codec<AddFeaturesIgnoreBiomeModifier>> ADD_FEATURES_WITH_IGNORE = BIOME_MODIFIER_SERIALIZERS.register("add_features_ignore", () -> RecordCodecBuilder.create(builder -> builder.group((App)Biome.f_47432_.fieldOf("biomes").forGetter(AddFeaturesIgnoreBiomeModifier::biomes), (App)Biome.f_47432_.fieldOf("ignored_biomes").forGetter(AddFeaturesIgnoreBiomeModifier::ignoredBiomes), (App)PlacedFeature.f_191774_.fieldOf("features").forGetter(AddFeaturesIgnoreBiomeModifier::features), (App)GenerationStep.Decoration.f_224188_.fieldOf("step").forGetter(AddFeaturesIgnoreBiomeModifier::step)).apply((Applicative)builder, AddFeaturesIgnoreBiomeModifier::new)));

    public record AddFeaturesIgnoreBiomeModifier(HolderSet<Biome> biomes, HolderSet<Biome> ignoredBiomes, HolderSet<PlacedFeature> features, GenerationStep.Decoration step) implements BiomeModifier
    {
        public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.ADD && this.biomes.m_203333_(biome) && !this.ignoredBiomes.m_203333_(biome)) {
                BiomeGenerationSettingsBuilder generationSettings = builder.getGenerationSettings();
                this.features.forEach(holder -> generationSettings.m_204201_(this.step, holder));
            }
        }

        public Codec<? extends BiomeModifier> codec() {
            return (Codec)ADD_FEATURES_WITH_IGNORE.get();
        }
    }

    public record AddSpawnsIgnoreBiomeModifier(HolderSet<Biome> biomes, HolderSet<Biome> ignoredBiomes, List<MobSpawnSettings.SpawnerData> spawners) implements BiomeModifier
    {
        public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.ADD && this.biomes.m_203333_(biome) && !this.ignoredBiomes.m_203333_(biome)) {
                MobSpawnSettingsBuilder spawns = builder.getMobSpawnSettings();
                for (MobSpawnSettings.SpawnerData spawner : this.spawners) {
                    EntityType type = spawner.f_48404_;
                    spawns.m_48376_(type.m_20674_(), spawner);
                }
            }
        }

        public Codec<? extends BiomeModifier> codec() {
            return (Codec)ADD_SPAWNS_WITH_IGNORE.get();
        }
    }

    public record InvertedRemoveSpawnsIgnoreBiomeModifier(HolderSet<Biome> biomes, HolderSet<Biome> ignoredBiomes, HolderSet<EntityType<?>> entityTypes) implements BiomeModifier
    {
        public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.REMOVE && (!this.biomes.m_203333_(biome) || this.ignoredBiomes.m_203333_(biome))) {
                MobSpawnSettingsBuilder spawnBuilder = builder.getMobSpawnSettings();
                for (MobCategory category : MobCategory.values()) {
                    List spawns = spawnBuilder.getSpawner(category);
                    spawns.removeIf(spawnerData -> this.entityTypes.m_203333_((Holder)ForgeRegistries.ENTITY_TYPES.getHolder((Object)spawnerData.f_48404_).get()));
                }
            }
        }

        public Codec<? extends BiomeModifier> codec() {
            return (Codec)REMOVE_SPAWNS_INVERTED_WITH_IGNORE.get();
        }
    }

    public record InvertedRemoveSpawnsBiomeModifier(HolderSet<Biome> biomes, HolderSet<EntityType<?>> entityTypes) implements BiomeModifier
    {
        public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.REMOVE && !this.biomes.m_203333_(biome)) {
                MobSpawnSettingsBuilder spawnBuilder = builder.getMobSpawnSettings();
                for (MobCategory category : MobCategory.values()) {
                    List spawns = spawnBuilder.getSpawner(category);
                    spawns.removeIf(spawnerData -> this.entityTypes.m_203333_((Holder)ForgeRegistries.ENTITY_TYPES.getHolder((Object)spawnerData.f_48404_).get()));
                }
            }
        }

        public Codec<? extends BiomeModifier> codec() {
            return (Codec)REMOVE_SPAWNS_INVERTED.get();
        }
    }
}

