/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.data.server;

import com.teamabnormals.environmental.common.advancement.UpgradeGearTrigger;
import com.teamabnormals.environmental.core.other.EnvironmentalCriteriaTriggers;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalEntityTypeTags;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalItemTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalItems;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.DamagePredicate;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.EntityEquipmentPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemInteractWithBlockTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.PlayerHurtEntityTrigger;
import net.minecraft.advancements.critereon.PlayerInteractTrigger;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.advancements.AdvancementProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;

public class EnvironmentalAdvancementProvider
extends AdvancementProvider {
    public EnvironmentalAdvancementProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, existingFileHelper);
    }

    protected void registerAdvancements(Consumer<Advancement> consumer, ExistingFileHelper existingFileHelper) {
        Advancement explorerGear = EnvironmentalAdvancementProvider.createAdvancement("obtain_explorer_gear", "adventure", new ResourceLocation("adventure/root"), (ItemLike)Items.f_42649_, FrameType.TASK, true, true, false).m_138360_(RequirementsStrategy.f_15979_).m_138386_("thief_hood", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)EnvironmentalItems.THIEF_HOOD.get()})).m_138386_("healer_pouch", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)EnvironmentalItems.HEALER_POUCH.get()})).m_138386_("architect_belt", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)EnvironmentalItems.ARCHITECT_BELT.get()})).m_138386_("wanderer_boots", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)EnvironmentalItems.WANDERER_BOOTS.get()})).m_138389_(consumer, "environmental:adventure/obtain_explorer_gear");
        EnvironmentalAdvancementProvider.createAdvancement("upgrade_thief_hood", "adventure", explorerGear, (ItemLike)EnvironmentalItems.THIEF_HOOD.get(), FrameType.GOAL, true, true, false).m_138386_("upgrade_thief_hood", (CriterionTriggerInstance)UpgradeGearTrigger.TriggerInstance.upgradeGear(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)EnvironmentalItems.THIEF_HOOD.get()}))).m_138389_(consumer, "environmental:adventure/upgrade_thief_hood");
        EnvironmentalAdvancementProvider.createAdvancement("upgrade_healer_pouch", "adventure", explorerGear, (ItemLike)EnvironmentalItems.HEALER_POUCH.get(), FrameType.GOAL, true, true, false).m_138386_("upgrade_healer_pouch", (CriterionTriggerInstance)UpgradeGearTrigger.TriggerInstance.upgradeGear(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)EnvironmentalItems.HEALER_POUCH.get()}))).m_138389_(consumer, "environmental:adventure/upgrade_healer_pouch");
        EnvironmentalAdvancementProvider.createAdvancement("upgrade_architect_belt", "adventure", explorerGear, (ItemLike)EnvironmentalItems.ARCHITECT_BELT.get(), FrameType.GOAL, true, true, false).m_138386_("upgrade_architect_belt", (CriterionTriggerInstance)UpgradeGearTrigger.TriggerInstance.upgradeGear(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)EnvironmentalItems.ARCHITECT_BELT.get()}))).m_138389_(consumer, "environmental:adventure/upgrade_architect_belt");
        EnvironmentalAdvancementProvider.createAdvancement("upgrade_wanderer_boots", "adventure", explorerGear, (ItemLike)EnvironmentalItems.WANDERER_BOOTS.get(), FrameType.GOAL, true, true, false).m_138386_("upgrade_wanderer_boots", (CriterionTriggerInstance)UpgradeGearTrigger.TriggerInstance.upgradeGear(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)EnvironmentalItems.WANDERER_BOOTS.get()}))).m_138389_(consumer, "environmental:adventure/upgrade_wanderer_boots");
        EnvironmentalAdvancementProvider.createAdvancement("backpack_slabfish", "husbandry", new ResourceLocation("husbandry/tame_an_animal"), (ItemLike)Items.f_42009_, FrameType.TASK, true, true, false).m_138386_("backpack_slabfish", (CriterionTriggerInstance)EnvironmentalCriteriaTriggers.BACKPACK_SLABFISH.createInstance()).m_138389_(consumer, "environmental:husbandry/backpack_slabfish");
        EnvironmentalAdvancementProvider.createAdvancement("place_koi_in_village", "husbandry", new ResourceLocation("husbandry/tactical_fishing"), (ItemLike)EnvironmentalItems.KOI_BUCKET.get(), FrameType.TASK, true, true, false).m_138386_("place_koi_in_village", (CriterionTriggerInstance)EnvironmentalCriteriaTriggers.PLACE_KOI_IN_VILLAGE.createInstance()).m_138389_(consumer, "environmental:husbandry/place_koi_in_village");
        Advancement saddlePig = EnvironmentalAdvancementProvider.createAdvancement("saddle_pig", "husbandry", new ResourceLocation("husbandry/root"), (ItemLike)Items.f_42450_, FrameType.TASK, true, true, false).m_138386_("saddle_pig", (CriterionTriggerInstance)PlayerInteractTrigger.TriggerInstance.m_222015_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{Items.f_42450_}), (EntityPredicate.Composite)EntityPredicate.Composite.m_36673_((EntityPredicate)EntityPredicate.Builder.m_36633_().m_36636_(EntityType.f_20510_).m_36662_()))).m_138389_(consumer, "environmental:husbandry/saddle_pig");
        EnvironmentalAdvancementProvider.createAdvancement("when_pigs_fly", "husbandry", saddlePig, (ItemLike)Items.f_42684_, FrameType.CHALLENGE, true, true, false).m_138386_("when_pigs_fly", (CriterionTriggerInstance)EnvironmentalCriteriaTriggers.WHEN_PIGS_FLY.createInstance()).m_138389_(consumer, "environmental:husbandry/when_pigs_fly");
        Advancement throwMud = EnvironmentalAdvancementProvider.createAdvancement("throw_mud_at_pig", "husbandry", saddlePig, (ItemLike)EnvironmentalItems.MUD_BALL.get(), FrameType.TASK, true, true, false).m_138386_("throw_mud_at_pig", (CriterionTriggerInstance)PlayerHurtEntityTrigger.TriggerInstance.m_156058_((DamagePredicate.Builder)DamagePredicate.Builder.m_24931_().m_24932_(DamageSourcePredicate.Builder.m_25471_().m_25474_(Boolean.valueOf(true)).m_25472_(EntityPredicate.Builder.m_36633_().m_36636_((EntityType)EnvironmentalEntityTypes.MUD_BALL.get()))), (EntityPredicate)EntityPredicate.Builder.m_36633_().m_36636_(EntityType.f_20510_).m_36662_())).m_138389_(consumer, "environmental:husbandry/throw_mud_at_pig");
        EnvironmentalAdvancementProvider.createAdvancement("plant_on_muddy_pig", "husbandry", throwMud, (ItemLike)Items.f_41944_, FrameType.TASK, true, true, false).m_138386_("plant_on_muddy_pig", (CriterionTriggerInstance)PlayerInteractTrigger.TriggerInstance.m_222015_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(EnvironmentalItemTags.MUDDY_PIG_DECORATIONS), (EntityPredicate.Composite)EntityPredicate.Composite.m_36673_((EntityPredicate)EntityPredicate.Builder.m_36633_().m_36636_(EntityType.f_20510_).m_36662_()))).m_138389_(consumer, "environmental:husbandry/plant_on_muddy_pig");
        Advancement feedPig = EnvironmentalAdvancementProvider.createAdvancement("truffle_shuffle", "husbandry", saddlePig, (ItemLike)Items.f_42677_, FrameType.TASK, true, true, false).m_138386_("truffle_shuffle", (CriterionTriggerInstance)PlayerInteractTrigger.TriggerInstance.m_222015_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{Items.f_42677_}), (EntityPredicate.Composite)EntityPredicate.Composite.m_36673_((EntityPredicate)EntityPredicate.Builder.m_36633_().m_36636_(EntityType.f_20510_).m_36662_()))).m_138389_(consumer, "environmental:husbandry/truffle_shuffle");
        EnvironmentalAdvancementProvider.createAdvancement("find_truffle", "husbandry", feedPig, (ItemLike)EnvironmentalItems.TRUFFLE.get(), FrameType.TASK, true, true, false).m_138386_("find_truffle", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)EnvironmentalItems.TRUFFLE.get()})).m_138389_(consumer, "environmental:husbandry/find_truffle");
        EnvironmentalAdvancementProvider.createAdvancement("shear_yak_with_pants", "husbandry", new ResourceLocation("husbandry/root"), (ItemLike)EnvironmentalItems.YAK_PANTS.get(), FrameType.TASK, true, true, false).m_138386_("shear_yak_with_pants", (CriterionTriggerInstance)PlayerInteractTrigger.TriggerInstance.m_61517_((EntityPredicate.Composite)EntityPredicate.Composite.m_36673_((EntityPredicate)EntityPredicate.Builder.m_36633_().m_36640_(EntityEquipmentPredicate.Builder.m_32204_().m_32210_(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)EnvironmentalItems.YAK_PANTS.get()}).m_45077_()).m_32207_()).m_36662_()), (ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(Tags.Items.SHEARS), (EntityPredicate.Composite)EntityPredicate.Composite.m_36673_((EntityPredicate)EntityPredicate.Builder.m_36633_().m_36636_((EntityType)EnvironmentalEntityTypes.YAK.get()).m_36662_()))).m_138389_(consumer, "environmental:husbandry/shear_yak_with_pants");
        EnvironmentalAdvancementProvider.createAdvancement("shear_cattail", "husbandry", new ResourceLocation("husbandry/root"), (ItemLike)EnvironmentalItems.CATTAIL_FLUFF.get(), FrameType.TASK, true, true, false).m_138386_("shear_cattail", (CriterionTriggerInstance)ItemInteractWithBlockTrigger.TriggerInstance.m_220065_((LocationPredicate.Builder)LocationPredicate.Builder.m_52651_().m_52652_(BlockPredicate.Builder.m_17924_().m_146726_(new Block[]{(Block)EnvironmentalBlocks.CATTAIL.get()}).m_17931_()), (ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(Tags.Items.SHEARS))).m_138389_(consumer, "environmental:husbandry/shear_cattail");
        EnvironmentalAdvancementProvider.createAdvancement("feed_deer_flower", "husbandry", new ResourceLocation("husbandry/root"), (ItemLike)Items.f_42410_, FrameType.TASK, true, true, false).m_138386_("feed_deer_flower", (CriterionTriggerInstance)PlayerInteractTrigger.TriggerInstance.m_222015_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(EnvironmentalItemTags.DEER_PLANTABLES), (EntityPredicate.Composite)EntityPredicate.Composite.m_36673_((EntityPredicate)EntityPredicate.Builder.m_36633_().m_204077_(EnvironmentalEntityTypeTags.DEER).m_36662_()))).m_138389_(consumer, "environmental:husbandry/feed_deer_flower");
    }

    private static Advancement.Builder createAdvancement(String name, String category, Advancement parent, ItemLike icon, FrameType frame, boolean showToast, boolean announceToChat, boolean hidden) {
        return Advancement.Builder.m_138353_().m_138398_(parent).m_138371_(icon, (Component)Component.m_237115_((String)("advancements.environmental." + category + "." + name + ".title")), (Component)Component.m_237115_((String)("advancements.environmental." + category + "." + name + ".description")), null, frame, showToast, announceToChat, hidden);
    }

    private static Advancement.Builder createAdvancement(String name, String category, ResourceLocation parent, ItemLike icon, FrameType frame, boolean showToast, boolean announceToChat, boolean hidden) {
        return EnvironmentalAdvancementProvider.createAdvancement(name, category, Advancement.Builder.m_138353_().m_138403_(parent), icon, frame, showToast, announceToChat, hidden);
    }
}

