/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.data.client;

import com.teamabnormals.environmental.common.entity.animal.koi.KoiBreed;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import com.teamabnormals.environmental.core.registry.EnvironmentalItems;
import java.util.Locale;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class EnvironmentalItemModelProvider
extends ItemModelProvider {
    public EnvironmentalItemModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "environmental", existingFileHelper);
    }

    protected void registerModels() {
        this.generatedItem((ItemLike)((RegistryObject)EnvironmentalItems.PINE_BOAT.getFirst()).get(), (ItemLike)((RegistryObject)EnvironmentalItems.PINE_BOAT.getSecond()).get(), (ItemLike)EnvironmentalItems.PINE_FURNACE_BOAT.get(), (ItemLike)EnvironmentalItems.LARGE_PINE_BOAT.get(), (ItemLike)EnvironmentalItems.CATTAIL_FLUFF.get(), (ItemLike)EnvironmentalBlocks.CATTAIL.get());
        this.koiBuckets();
    }

    private void generatedItem(ItemLike ... items) {
        for (ItemLike item : items) {
            this.item(item, "generated");
        }
    }

    private void handheldItem(ItemLike ... items) {
        for (ItemLike item : items) {
            this.item(item, "handheld");
        }
    }

    private void item(ItemLike item, String type) {
        ResourceLocation itemName = ForgeRegistries.ITEMS.getKey((Object)item.m_5456_());
        ((ItemModelBuilder)this.withExistingParent(itemName.m_135815_(), "item/" + type)).texture("layer0", new ResourceLocation(this.modid, "item/" + itemName.m_135815_()));
    }

    private void spawnEggItem(ItemLike ... items) {
        for (ItemLike item : items) {
            ResourceLocation itemName = ForgeRegistries.ITEMS.getKey((Object)item.m_5456_());
            this.withExistingParent(itemName.m_135815_(), "item/template_spawn_egg");
        }
    }

    private void blockItem(Block block) {
        ResourceLocation name = ForgeRegistries.BLOCKS.getKey((Object)block);
        ((ItemModelBuilder)this.getBuilder(name.m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation(this.modid, "block/" + name.m_135815_())));
    }

    private void koiBuckets() {
        for (KoiBreed breed : KoiBreed.values()) {
            String path = "item/" + ForgeRegistries.ITEMS.getKey((Object)((Item)EnvironmentalItems.KOI_BUCKET.get())).m_135815_() + "/" + breed.name().toLowerCase(Locale.ROOT);
            ((ItemModelBuilder)this.withExistingParent(path, "item/generated")).texture("layer0", new ResourceLocation(this.modid, path));
        }
    }
}

