/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.data.client;

import com.mojang.datafixers.util.Pair;
import com.teamabnormals.blueprint.common.block.VerticalSlabBlock;
import com.teamabnormals.blueprint.common.block.chest.BlueprintChestBlock;
import com.teamabnormals.blueprint.common.block.chest.BlueprintTrappedChestBlock;
import com.teamabnormals.blueprint.common.block.sign.BlueprintStandingSignBlock;
import com.teamabnormals.blueprint.common.block.sign.BlueprintWallSignBlock;
import com.teamabnormals.environmental.common.block.CattailBlock;
import com.teamabnormals.environmental.common.block.CattailStalkBlock;
import com.teamabnormals.environmental.core.other.EnvironmentalBlockFamilies;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BasePressurePlateBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class EnvironmentalBlockStateProvider
extends BlockStateProvider {
    public static final BooleanProperty[] CHAINED = new BooleanProperty[]{BooleanProperty.m_61465_((String)"chain_down"), BooleanProperty.m_61465_((String)"chain_up"), BooleanProperty.m_61465_((String)"chain_north"), BooleanProperty.m_61465_((String)"chain_south"), BooleanProperty.m_61465_((String)"chain_west"), BooleanProperty.m_61465_((String)"chain_east")};

    public EnvironmentalBlockStateProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "environmental", existingFileHelper);
    }

    protected void registerStatesAndModels() {
        this.blockFamily(EnvironmentalBlockFamilies.DIRT_BRICK_FAMILY, (Block)EnvironmentalBlocks.DIRT_BRICK_VERTICAL_SLAB.get());
        this.blockFamily(EnvironmentalBlockFamilies.DIRT_TILE_FAMILY, (Block)EnvironmentalBlocks.DIRT_TILE_VERTICAL_SLAB.get());
        this.blockFamily(EnvironmentalBlockFamilies.PINE_PLANKS_FAMILY, (Block)EnvironmentalBlocks.PINE_VERTICAL_SLAB.get());
        this.logBlocks((Block)EnvironmentalBlocks.PINE_LOG.get(), (Block)EnvironmentalBlocks.PINE_WOOD.get());
        this.logBlocks((Block)EnvironmentalBlocks.STRIPPED_PINE_LOG.get(), (Block)EnvironmentalBlocks.STRIPPED_PINE_WOOD.get());
        this.leavesBlock((Block)EnvironmentalBlocks.PINE_LEAVES.get());
        this.crossBlockWithPot((Block)EnvironmentalBlocks.PINE_SAPLING.get(), (Block)EnvironmentalBlocks.POTTED_PINE_SAPLING.get());
        this.planksCompat((Block)EnvironmentalBlocks.PINE_PLANKS.get(), (Block)EnvironmentalBlocks.PINE_BOARDS.get(), (Block)EnvironmentalBlocks.PINE_LADDER.get(), (Block)EnvironmentalBlocks.PINE_BOOKSHELF.get(), (Block)EnvironmentalBlocks.PINE_BEEHIVE.get(), EnvironmentalBlocks.PINE_CHESTS, (Block)EnvironmentalBlocks.VERTICAL_PINE_PLANKS.get());
        this.logCompat((Block)EnvironmentalBlocks.PINE_LOG.get(), (Block)EnvironmentalBlocks.STRIPPED_PINE_LOG.get(), (Block)EnvironmentalBlocks.PINE_POST.get(), (Block)EnvironmentalBlocks.STRIPPED_PINE_POST.get());
        this.leavesCompat((Block)EnvironmentalBlocks.PINE_LEAVES.get(), (Block)EnvironmentalBlocks.PINE_LOG.get(), (Block)EnvironmentalBlocks.PINE_LEAF_PILE.get(), (Block)EnvironmentalBlocks.PINE_HEDGE.get(), (Block)EnvironmentalBlocks.PINE_LEAF_CARPET.get());
        this.cubeColumnBlock((Block)EnvironmentalBlocks.PINECONE.get());
        this.cubeColumnBlock((Block)EnvironmentalBlocks.WAXED_PINECONE.get(), (Block)EnvironmentalBlocks.PINECONE.get());
        this.leavesBlock((Block)EnvironmentalBlocks.CHEERFUL_CHERRY_LEAVES.get());
        this.crossBlockWithPot((Block)EnvironmentalBlocks.CHEERFUL_CHERRY_SAPLING.get(), (Block)EnvironmentalBlocks.POTTED_CHEERFUL_CHERRY_SAPLING.get());
        this.leavesCompat((Block)EnvironmentalBlocks.CHEERFUL_CHERRY_LEAVES.get(), (Block)EnvironmentalBlocks.CHERRY_LOG.get(), (Block)EnvironmentalBlocks.CHEERFUL_CHERRY_LEAF_PILE.get(), (Block)EnvironmentalBlocks.CHEERFUL_CHERRY_HEDGE.get(), (Block)EnvironmentalBlocks.CHEERFUL_CHERRY_LEAF_CARPET.get());
        this.leavesBlock((Block)EnvironmentalBlocks.MOODY_CHERRY_LEAVES.get());
        this.crossBlockWithPot((Block)EnvironmentalBlocks.MOODY_CHERRY_SAPLING.get(), (Block)EnvironmentalBlocks.POTTED_MOODY_CHERRY_SAPLING.get());
        this.leavesCompat((Block)EnvironmentalBlocks.MOODY_CHERRY_LEAVES.get(), (Block)EnvironmentalBlocks.CHERRY_LOG.get(), (Block)EnvironmentalBlocks.MOODY_CHERRY_LEAF_PILE.get(), (Block)EnvironmentalBlocks.MOODY_CHERRY_HEDGE.get(), (Block)EnvironmentalBlocks.MOODY_CHERRY_LEAF_CARPET.get());
        this.block((Block)EnvironmentalBlocks.CATTAIL_FLUFF_BLOCK.get());
        this.cattail((Block)EnvironmentalBlocks.CATTAIL_SPROUT.get(), (Block)EnvironmentalBlocks.CATTAIL.get(), (Block)EnvironmentalBlocks.CATTAIL_STALK.get());
        this.directionalBlock((Block)EnvironmentalBlocks.CHERRY_CRATE.get());
        this.cactusBobble((Block)EnvironmentalBlocks.CACTUS_BOBBLE.get());
    }

    public void cattail(Block cattailSprout, Block cattail, Block cattailStalk) {
        this.getVariantBuilder(cattailSprout).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile(this.cattailStalkModel(this.name(cattailSprout), this.blockTexture(cattailSprout), (Integer)state.m_61143_((Property)CattailBlock.CATTAILS), false)).build(), new Property[]{BlockStateProperties.f_61362_});
        MultiPartBlockStateBuilder cattailBuilder = this.getMultipartBuilder(cattail);
        for (int i = 1; i <= 3; ++i) {
            ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)cattailBuilder.part().modelFile(this.cattailStalkModel(this.name(cattail), this.blockTexture(cattail), i, false)).addModel()).condition((Property)CattailBlock.TOP, (Comparable[])new Boolean[]{false}).condition((Property)CattailBlock.CATTAILS, (Comparable[])new Integer[]{i}).end().part().modelFile(this.cattailStalkModel(this.name(cattail) + "_top", this.suffix(this.blockTexture(cattail), "_stalk_top"), i, true)).addModel()).condition((Property)CattailBlock.TOP, (Comparable[])new Boolean[]{true}).condition((Property)CattailBlock.CATTAILS, (Comparable[])new Integer[]{i}).end().part().modelFile(this.cattailHeadModel(this.name(cattail) + "_head", this.suffix(this.blockTexture(cattail), "_head"), false, i)).addModel()).condition((Property)CattailBlock.FLUFFY, (Comparable[])new Boolean[]{false}).condition((Property)CattailBlock.TOP, (Comparable[])new Boolean[]{false}).condition((Property)CattailBlock.CATTAILS, (Comparable[])new Integer[]{i}).end().part().modelFile(this.cattailHeadModel(this.name(cattail) + "_head", this.suffix(this.blockTexture(cattail), "_head"), true, i)).addModel()).condition((Property)CattailBlock.FLUFFY, (Comparable[])new Boolean[]{false}).condition((Property)CattailBlock.TOP, (Comparable[])new Boolean[]{true}).condition((Property)CattailBlock.CATTAILS, (Comparable[])new Integer[]{i}).end().part().modelFile(this.cattailHeadModel(this.name(cattail) + "_head_fluffy", this.suffix(this.blockTexture(cattail), "_head_fluffy"), false, i)).addModel()).condition((Property)CattailBlock.FLUFFY, (Comparable[])new Boolean[]{true}).condition((Property)CattailBlock.TOP, (Comparable[])new Boolean[]{false}).condition((Property)CattailBlock.CATTAILS, (Comparable[])new Integer[]{i}).end().part().modelFile(this.cattailHeadModel(this.name(cattail) + "_head_fluffy", this.suffix(this.blockTexture(cattail), "_head_fluffy"), true, i)).addModel()).condition((Property)CattailBlock.FLUFFY, (Comparable[])new Boolean[]{true}).condition((Property)CattailBlock.TOP, (Comparable[])new Boolean[]{true}).condition((Property)CattailBlock.CATTAILS, (Comparable[])new Integer[]{i}).end();
        }
        this.getVariantBuilder(cattailStalk).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile(this.cattailStalkModel(this.name(cattailStalk) + ((Boolean)state.m_61143_((Property)CattailStalkBlock.BOTTOM) != false ? "_bottom" : "_middle"), this.suffix(this.blockTexture(cattailStalk), (Boolean)state.m_61143_((Property)CattailStalkBlock.BOTTOM) != false ? "_bottom" : "_middle"), (Integer)state.m_61143_((Property)CattailBlock.CATTAILS), false)).build(), new Property[]{BlockStateProperties.f_61362_});
    }

    public ModelFile cattailStalkModel(String name, ResourceLocation texture, int stalks, boolean top) {
        String stalkSuffix = EnvironmentalBlockStateProvider.getStalkSuffix(stalks);
        ModelFile.UncheckedModelFile stalkParent = new ModelFile.UncheckedModelFile(new ResourceLocation("environmental", "block/template_cattail_stalk" + stalkSuffix));
        BlockModelBuilder builder = (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(name + stalkSuffix)).parent((ModelFile)stalkParent);
        for (int i = 1; i <= stalks; ++i) {
            String suffix = EnvironmentalBlockStateProvider.getStalkSuffix(i);
            builder.texture("stalk" + suffix, top ? this.suffix(texture, suffix) : texture);
        }
        return builder;
    }

    public static String getStalkSuffix(int stalks) {
        return stalks == 3 ? "_three" : (stalks == 2 ? "_two" : "_one");
    }

    public ModelFile cattailHeadModel(String name, ResourceLocation texture, boolean top, int stalks) {
        String stalkSuffix = stalks == 3 ? "_three" : (stalks == 2 ? "_two" : "_one");
        ModelFile.UncheckedModelFile cattailParent = new ModelFile.UncheckedModelFile(new ResourceLocation("environmental", "block/template_" + (top ? "cattail_top" : "cattail") + stalkSuffix));
        return ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(name + (top ? "_top" : "") + stalkSuffix)).parent((ModelFile)cattailParent)).texture("cattail", texture);
    }

    private ResourceLocation key(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    public void block(Block block) {
        this.simpleBlock(block, this.cubeAll(block));
        this.blockItem(block);
    }

    public void blockFamily(BlockFamily family, Block verticalSlab) {
        Block block = family.m_175951_();
        this.block(block);
        if (family.m_175954_().containsKey(BlockFamily.Variant.CHISELED)) {
            this.block(family.m_175952_(BlockFamily.Variant.CHISELED));
        }
        if (family.m_175954_().containsKey(BlockFamily.Variant.SLAB)) {
            SlabBlock slab = (SlabBlock)family.m_175952_(BlockFamily.Variant.SLAB);
            this.slabBlock(slab, this.blockTexture(block), this.blockTexture(block));
            this.blockItem((Block)slab);
            this.verticalSlabBlock(block, (VerticalSlabBlock)verticalSlab);
            this.blockItem(verticalSlab);
        }
        if (family.m_175954_().containsKey(BlockFamily.Variant.STAIRS)) {
            StairBlock stairs = (StairBlock)family.m_175952_(BlockFamily.Variant.STAIRS);
            this.stairsBlock(stairs, this.blockTexture(block));
            this.blockItem((Block)stairs);
        }
        if (family.m_175954_().containsKey(BlockFamily.Variant.WALL)) {
            WallBlock wall = (WallBlock)family.m_175952_(BlockFamily.Variant.WALL);
            this.wallBlock(wall, this.blockTexture(block));
            ((ItemModelBuilder)this.itemModels().getBuilder(this.name((Block)wall))).parent((ModelFile)this.models().wallInventory(this.name((Block)wall) + "_inventory", this.blockTexture(block)));
        }
        if (family.m_175954_().containsKey(BlockFamily.Variant.FENCE)) {
            FenceBlock fence = (FenceBlock)family.m_175952_(BlockFamily.Variant.FENCE);
            this.fenceBlock(fence, this.blockTexture(block));
            ((ItemModelBuilder)this.itemModels().getBuilder(this.name((Block)fence))).parent((ModelFile)this.models().fenceInventory(this.name((Block)fence) + "_inventory", this.blockTexture(block)));
        }
        if (family.m_175954_().containsKey(BlockFamily.Variant.FENCE_GATE)) {
            FenceGateBlock fenceGate = (FenceGateBlock)family.m_175952_(BlockFamily.Variant.FENCE_GATE);
            this.fenceGateBlock(fenceGate, this.blockTexture(block));
            this.blockItem((Block)fenceGate);
        }
        if (family.m_175954_().containsKey(BlockFamily.Variant.BUTTON)) {
            ButtonBlock button = (ButtonBlock)family.m_175952_(BlockFamily.Variant.BUTTON);
            ModelBuilder buttonModel = ((BlockModelBuilder)this.models().withExistingParent(this.name((Block)button), "block/button")).texture("texture", this.blockTexture(block));
            ModelBuilder buttonPressedModel = ((BlockModelBuilder)this.models().withExistingParent(this.name((Block)button) + "_pressed", "block/button_pressed")).texture("texture", this.blockTexture(block));
            ModelBuilder buttonInventoryModel = ((BlockModelBuilder)this.models().withExistingParent(this.name((Block)button) + "_inventory", "block/button_inventory")).texture("texture", this.blockTexture(block));
            this.buttonBlock((Block)button, arg_0 -> EnvironmentalBlockStateProvider.lambda$blockFamily$2((ModelFile)buttonPressedModel, (ModelFile)buttonModel, arg_0));
            ((ItemModelBuilder)this.itemModels().getBuilder(this.name((Block)button))).parent((ModelFile)buttonInventoryModel);
        }
        if (family.m_175954_().containsKey(BlockFamily.Variant.PRESSURE_PLATE)) {
            BasePressurePlateBlock pressurePlate = (BasePressurePlateBlock)family.m_175952_(BlockFamily.Variant.PRESSURE_PLATE);
            ModelBuilder pressurePlateModel = ((BlockModelBuilder)this.models().withExistingParent(this.name((Block)pressurePlate), "block/pressure_plate_up")).texture("texture", this.blockTexture(block));
            ModelBuilder pressurePlateDownModel = ((BlockModelBuilder)this.models().withExistingParent(this.name((Block)pressurePlate) + "_down", "block/pressure_plate_down")).texture("texture", this.blockTexture(block));
            this.pressurePlateBlock((Block)pressurePlate, arg_0 -> EnvironmentalBlockStateProvider.lambda$blockFamily$3((ModelFile)pressurePlateDownModel, (ModelFile)pressurePlateModel, arg_0));
            this.blockItem((Block)pressurePlate);
        }
        if (family.m_175954_().containsKey(BlockFamily.Variant.DOOR)) {
            DoorBlock door = (DoorBlock)family.m_175952_(BlockFamily.Variant.DOOR);
            this.doorBlock(door, this.suffix(this.blockTexture((Block)door), "_bottom"), this.suffix(this.blockTexture((Block)door), "_top"));
            this.generatedItem((ItemLike)door, "item");
        }
        if (family.m_175954_().containsKey(BlockFamily.Variant.TRAPDOOR)) {
            TrapDoorBlock trapdoor = (TrapDoorBlock)family.m_175952_(BlockFamily.Variant.TRAPDOOR);
            this.trapdoorBlock(trapdoor, this.blockTexture((Block)trapdoor), true);
            ((ItemModelBuilder)this.itemModels().getBuilder(this.name((Block)trapdoor))).parent((ModelFile)this.models().trapdoorOrientableBottom(this.name((Block)trapdoor) + "_bottom", this.blockTexture((Block)trapdoor)));
        }
        if (family.m_175954_().containsKey(BlockFamily.Variant.SIGN)) {
            SignBlock sign = (SignBlock)family.m_175952_(BlockFamily.Variant.SIGN);
            this.simpleBlock((Block)sign, this.particle((Block)sign, this.blockTexture(block)));
            this.generatedItem((ItemLike)sign, "item");
        }
        if (family.m_175954_().containsKey(BlockFamily.Variant.WALL_SIGN)) {
            WallSignBlock wallSign = (WallSignBlock)family.m_175952_(BlockFamily.Variant.WALL_SIGN);
            this.simpleBlock((Block)wallSign, this.particle((Block)wallSign, this.blockTexture(block)));
        }
    }

    public void blockItem(Block block) {
        this.simpleBlockItem(block, (ModelFile)new ModelFile.ExistingModelFile(this.blockTexture(block), this.models().existingFileHelper));
    }

    private void generatedItem(ItemLike item, String type) {
        this.generatedItem(item, item, type);
    }

    private void generatedItem(ItemLike item, ItemLike texture, String type) {
        ((ItemModelBuilder)this.itemModels().withExistingParent(ForgeRegistries.ITEMS.getKey((Object)item.m_5456_()).m_135815_(), "item/generated")).texture("layer0", new ResourceLocation(ForgeRegistries.ITEMS.getKey((Object)texture.m_5456_()).m_135827_(), type + "/" + ForgeRegistries.ITEMS.getKey((Object)texture.m_5456_()).m_135815_()));
    }

    public void crossBlockWithPot(Block cross, Block flowerPot) {
        this.crossBlock(cross);
        this.simpleBlock(flowerPot, (ModelFile)this.models().singleTexture(this.name(flowerPot), new ResourceLocation("block/flower_pot_cross"), "plant", this.blockTexture(cross)));
    }

    public void crossBlockWithCustomPot(Block cross, Block flowerPot) {
        this.crossBlock(cross);
        this.simpleBlock(flowerPot, (ModelFile)this.models().singleTexture(this.name(flowerPot), new ResourceLocation("block/flower_pot_cross"), "plant", this.blockTexture(flowerPot)));
    }

    public void crossBlock(Block cross) {
        this.simpleBlock(cross, (ModelFile)this.models().cross(this.name(cross), this.blockTexture(cross)));
        this.generatedItem((ItemLike)cross, "block");
    }

    public void cubeBottomTopBlock(Block block) {
        this.simpleBlock(block, (ModelFile)this.models().cubeBottomTop(this.name(block), this.suffix(this.blockTexture(block), "_side"), this.suffix(this.blockTexture(block), "_bottom"), this.suffix(this.blockTexture(block), "_top")));
        this.blockItem(block);
    }

    public void directionalBlock(Block block) {
        this.directionalBlock(block, (ModelFile)this.models().cubeBottomTop(this.name(block), this.suffix(this.blockTexture(block), "_side"), this.suffix(this.blockTexture(block), "_bottom"), this.suffix(this.blockTexture(block), "_top")));
        this.blockItem(block);
    }

    public void cubeBottomTopBlock(Block block, Block parent) {
        this.simpleBlock(block, (ModelFile)this.models().cubeBottomTop(this.name(block), this.suffix(this.blockTexture(parent), "_side"), this.suffix(this.blockTexture(parent), "_bottom"), this.suffix(this.blockTexture(block), "_top")));
        this.blockItem(block);
    }

    public void cubeColumnBlock(Block block) {
        this.cubeColumnBlock(block, block);
    }

    public void cubeColumnBlock(Block block, Block parent) {
        this.simpleBlock(block, (ModelFile)this.models().cubeColumn(this.name(block), this.suffix(this.blockTexture(parent), "_side"), this.suffix(this.blockTexture(parent), "_end")));
        this.blockItem(block);
    }

    public void bookshelfBlock(Block planks, Block bookshelf) {
        this.simpleBlock(bookshelf, (ModelFile)this.models().cubeColumn(this.name(bookshelf), this.blockTexture(bookshelf), this.blockTexture(planks)));
        this.blockItem(bookshelf);
    }

    public void ladderBlock(Block ladder) {
        this.horizontalBlock(ladder, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(ladder), "block/ladder")).texture("particle", this.blockTexture(ladder))).texture("texture", this.blockTexture(ladder)));
        this.generatedItem((ItemLike)ladder, "block");
    }

    public void boardsBlock(Block boards) {
        ModelBuilder boardsModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name(boards))).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("blueprint", "block/template_boards")))).texture("all", this.blockTexture(boards));
        ModelBuilder boardsHorizontalModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name(boards) + "_horizontal")).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("blueprint", "block/template_boards_horizontal")))).texture("all", this.blockTexture(boards));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(boards).partialState().with((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y).modelForState().modelFile((ModelFile)boardsModel).addModel()).partialState().with((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z).modelForState().modelFile((ModelFile)boardsHorizontalModel).addModel()).partialState().with((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X).modelForState().modelFile((ModelFile)boardsHorizontalModel).rotationY(270).addModel();
        this.blockItem(boards);
    }

    public void verticalPlanksBlock(Block planks, Block verticalPlanks) {
        this.simpleBlock(verticalPlanks, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name(verticalPlanks))).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("blueprint", "block/vertical_planks")))).texture("all", this.blockTexture(planks)));
        this.blockItem(verticalPlanks);
    }

    public void beehiveBlock(Block block) {
        ModelBuilder beehive = ((BlockModelBuilder)this.models().orientableWithBottom(this.name(block), this.suffix(this.blockTexture(block), "_side"), this.suffix(this.blockTexture(block), "_front"), this.suffix(this.blockTexture(block), "_end"), this.suffix(this.blockTexture(block), "_end"))).texture("particle", this.suffix(this.blockTexture(block), "_side"));
        ModelBuilder beehiveHoney = ((BlockModelBuilder)this.models().orientableWithBottom(this.name(block) + "_honey", this.suffix(this.blockTexture(block), "_side"), this.suffix(this.blockTexture(block), "_front_honey"), this.suffix(this.blockTexture(block), "_end"), this.suffix(this.blockTexture(block), "_end"))).texture("particle", this.suffix(this.blockTexture(block), "_side"));
        this.horizontalBlock(block, arg_0 -> EnvironmentalBlockStateProvider.lambda$beehiveBlock$4((ModelFile)beehiveHoney, (ModelFile)beehive, arg_0));
        this.blockItem(block);
    }

    public void buttonBlock(Block block, Function<BlockState, ModelFile> modelFunc) {
        this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).uvLock(state.m_61143_((Property)BlockStateProperties.f_61376_) == AttachFace.WALL).rotationX(state.m_61143_((Property)BlockStateProperties.f_61376_) == AttachFace.WALL ? 90 : (state.m_61143_((Property)BlockStateProperties.f_61376_) == AttachFace.CEILING ? 180 : 0)).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + (state.m_61143_((Property)BlockStateProperties.f_61376_) != AttachFace.CEILING ? 180 : 0)) % 360).build());
    }

    public void pressurePlateBlock(Block block, Function<BlockState, ModelFile> modelFunc) {
        this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).build());
    }

    public void planksCompat(Block planks, Block boards, Block ladder, Block bookshelf, Block beehive, Pair<RegistryObject<BlueprintChestBlock>, RegistryObject<BlueprintTrappedChestBlock>> chests, Block verticalPlanks) {
        this.boardsBlock(boards);
        this.ladderBlock(ladder);
        this.bookshelfBlock(planks, bookshelf);
        this.beehiveBlock(beehive);
        this.chestBlocks(planks, chests);
        this.verticalPlanksBlock(planks, verticalPlanks);
    }

    public void logCompat(Block log, Block strippedLog, Block post, Block strippedPost) {
        this.postBlock(log, post);
        this.postBlock(strippedLog, strippedPost);
    }

    public void leavesCompat(Block leaves, Block log, Block leafPile, Block hedge, Block leafCarpet) {
        this.leafPileBlock(leaves, leafPile);
        this.leafCarpetBlock(leaves, leafCarpet);
        this.hedgeBlock(leaves, log, hedge);
    }

    public void leavesBlock(Block leaves) {
        this.simpleBlock(leaves, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name(leaves))).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("block/leaves")))).texture("all", this.blockTexture(leaves)));
        this.blockItem(leaves);
    }

    public void cactusBobble(Block cactusBobble) {
        this.simpleBlock(cactusBobble, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name(cactusBobble))).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("environmental", "block/template_cactus_bobble")))).texture("all", this.blockTexture(cactusBobble)));
    }

    public void leafPileBlock(Block leaves, Block leafPile) {
        this.leafPileBlock(leaves, leafPile, true);
    }

    public void leafPileBlock(Block leaves, Block leafPile, boolean tint) {
        ModelBuilder leafPileModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name(leafPile))).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("blueprint", "block/" + (tint ? "tinted_" : "") + "leaf_pile")))).texture("all", this.blockTexture(leaves));
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(leafPile);
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)leafPileModel).rotationX(270).uvLock(true).addModel()).condition((Property)BlockStateProperties.f_61366_, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)leafPileModel).rotationX(270).uvLock(true).addModel()).condition((Property)BlockStateProperties.f_61366_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61367_, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)leafPileModel).addModel()).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)leafPileModel).addModel()).condition((Property)BlockStateProperties.f_61366_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61367_, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)leafPileModel).rotationY(270).uvLock(true).addModel()).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)leafPileModel).rotationY(270).uvLock(true).addModel()).condition((Property)BlockStateProperties.f_61366_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61367_, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)leafPileModel).rotationY(180).uvLock(true).addModel()).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)leafPileModel).rotationY(180).uvLock(true).addModel()).condition((Property)BlockStateProperties.f_61366_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61367_, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)leafPileModel).rotationY(90).uvLock(true).addModel()).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)leafPileModel).rotationY(90).uvLock(true).addModel()).condition((Property)BlockStateProperties.f_61366_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61367_, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)leafPileModel).rotationX(90).uvLock(true).addModel()).condition((Property)BlockStateProperties.f_61367_, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)leafPileModel).rotationX(90).uvLock(true).addModel()).condition((Property)BlockStateProperties.f_61366_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61367_, (Comparable[])new Boolean[]{false});
        this.generatedItem((ItemLike)leafPile, (ItemLike)leaves, "block");
    }

    public void leafCarpetBlock(Block leaves, Block leafCarpet) {
        this.simpleBlock(leafCarpet, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name(leafCarpet))).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("blueprint", "block/leaf_carpet")))).texture("all", this.blockTexture(leaves)));
        this.blockItem(leafCarpet);
    }

    public void hedgeBlock(Block leaves, Block log, Block hedge) {
        ModelFile hedgePost = this.hedgePost(this.name(hedge) + "_post", this.blockTexture(log), this.blockTexture(leaves));
        ModelFile hedgeSide = this.hedgeSide(this.name(hedge) + "_side", this.blockTexture(leaves));
        ModelFile hedgeExtend = this.hedgeExtend(this.name(hedge) + "_extend", this.blockTexture(leaves));
        this.hedgeBlock(hedge, hedgePost, hedgeSide, hedgeExtend);
        ((ItemModelBuilder)this.itemModels().getBuilder(this.name(hedge))).parent(hedgePost);
    }

    public void postBlock(Block log, Block post) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name(post))).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("blueprint", "block/post")))).texture("texture", this.blockTexture(log));
        ModelFile.UncheckedModelFile chainSmall = new ModelFile.UncheckedModelFile(new ResourceLocation("blueprint", "block/chain_small"));
        ModelFile.UncheckedModelFile chainSmallTop = new ModelFile.UncheckedModelFile(new ResourceLocation("blueprint", "block/chain_small_top"));
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(post).part().modelFile((ModelFile)model).addModel()).condition((Property)RotatedPillarBlock.f_55923_, (Comparable[])new Direction.Axis[]{Direction.Axis.Y}).end().part().modelFile((ModelFile)model).rotationX(90).addModel()).condition((Property)RotatedPillarBlock.f_55923_, (Comparable[])new Direction.Axis[]{Direction.Axis.Z}).end().part().modelFile((ModelFile)model).rotationX(90).rotationY(90).addModel()).condition((Property)RotatedPillarBlock.f_55923_, (Comparable[])new Direction.Axis[]{Direction.Axis.X}).end().part().modelFile((ModelFile)chainSmall).addModel()).condition((Property)CHAINED[0], (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)chainSmallTop).addModel()).condition((Property)CHAINED[1], (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)chainSmallTop).rotationX(90).addModel()).condition((Property)CHAINED[2], (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)chainSmall).rotationX(90).addModel()).condition((Property)CHAINED[3], (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)chainSmall).rotationX(90).rotationY(90).addModel()).condition((Property)CHAINED[4], (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)chainSmallTop).rotationX(90).rotationY(90).addModel()).condition((Property)CHAINED[5], (Comparable[])new Boolean[]{true}).end();
        this.blockItem(post);
    }

    public void hedgeBlock(Block block, ModelFile post, ModelFile side, ModelFile extend) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(block);
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(post).addModel()).condition((Property)BooleanProperty.m_61465_((String)"extend"), (Comparable[])new Boolean[]{false}).end().part().modelFile(extend).addModel()).condition((Property)BooleanProperty.m_61465_((String)"extend"), (Comparable[])new Boolean[]{true});
        PipeBlock.f_55154_.entrySet().forEach(e -> {
            Direction dir = (Direction)e.getKey();
            if (dir.m_122434_().m_122479_()) {
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(side).rotationY(((int)dir.m_122435_() + 180) % 360).uvLock(true).addModel()).condition((Property)e.getValue(), (Comparable[])new Boolean[]{true});
            }
        });
    }

    public ModelFile hedgePost(String name, ResourceLocation log, ResourceLocation leaf) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("blueprint", "block/hedge_post")))).texture("log", log)).texture("leaf", leaf);
    }

    public ModelFile hedgeSide(String name, ResourceLocation leaf) {
        return ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("blueprint", "block/hedge_side")))).texture("leaf", leaf);
    }

    public ModelFile hedgeExtend(String name, ResourceLocation leaf) {
        return ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("blueprint", "block/hedge_extend")))).texture("leaf", leaf);
    }

    public void signBlocks(Block planks, Pair<RegistryObject<BlueprintStandingSignBlock>, RegistryObject<BlueprintWallSignBlock>> pair) {
        this.simpleBlock((Block)((RegistryObject)pair.getFirst()).get(), this.particle((Block)((RegistryObject)pair.getFirst()).get(), this.blockTexture(planks)));
        this.simpleBlock((Block)((RegistryObject)pair.getSecond()).get(), this.particle((Block)((RegistryObject)pair.getFirst()).get(), this.blockTexture(planks)));
        this.generatedItem((ItemLike)((RegistryObject)pair.getFirst()).get(), "item");
    }

    public void chestBlocks(Block planks, Pair<RegistryObject<BlueprintChestBlock>, RegistryObject<BlueprintTrappedChestBlock>> chests) {
        this.simpleBlock((Block)((RegistryObject)chests.getFirst()).get(), this.particle((Block)((RegistryObject)chests.getFirst()).get(), this.blockTexture(planks)));
        this.simpleBlock((Block)((RegistryObject)chests.getSecond()).get(), this.particle((Block)((RegistryObject)chests.getFirst()).get(), this.blockTexture(planks)));
        this.simpleBlockItem((Block)((RegistryObject)chests.getFirst()).get(), (ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("blueprint", "item/template_chest")));
        this.simpleBlockItem((Block)((RegistryObject)chests.getSecond()).get(), (ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("blueprint", "item/template_chest")));
    }

    public ModelFile particle(Block block, ResourceLocation texture) {
        return ((BlockModelBuilder)this.models().getBuilder(this.name(block))).texture("particle", texture);
    }

    public void logBlocks(Block log, Block wood) {
        this.logBlock(log);
        this.axisBlock((RotatedPillarBlock)wood, this.blockTexture(log), this.blockTexture(log));
        this.blockItem(wood);
    }

    public void logBlock(Block block) {
        this.axisBlock((RotatedPillarBlock)block, this.blockTexture(block), this.suffix(this.blockTexture(block), "_top"));
        this.blockItem(block);
    }

    public ModelFile verticalSlab(String name, ResourceLocation texture) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("blueprint", "block/vertical_slab")))).texture("side", texture)).texture("bottom", texture)).texture("top", texture);
    }

    public void verticalSlabBlock(Block planks, VerticalSlabBlock slab) {
        ModelFile verticalSlab = this.verticalSlab(this.name((Block)slab), this.blockTexture(planks));
        this.getVariantBuilder((Block)slab).partialState().with((Property)VerticalSlabBlock.TYPE, (Comparable)VerticalSlabBlock.VerticalSlabType.NORTH).addModels(new ConfiguredModel[]{new ConfiguredModel(verticalSlab, 0, 0, true)}).partialState().with((Property)VerticalSlabBlock.TYPE, (Comparable)VerticalSlabBlock.VerticalSlabType.SOUTH).addModels(new ConfiguredModel[]{new ConfiguredModel(verticalSlab, 0, 180, true)}).partialState().with((Property)VerticalSlabBlock.TYPE, (Comparable)VerticalSlabBlock.VerticalSlabType.EAST).addModels(new ConfiguredModel[]{new ConfiguredModel(verticalSlab, 0, 90, true)}).partialState().with((Property)VerticalSlabBlock.TYPE, (Comparable)VerticalSlabBlock.VerticalSlabType.WEST).addModels(new ConfiguredModel[]{new ConfiguredModel(verticalSlab, 0, 270, true)}).partialState().with((Property)VerticalSlabBlock.TYPE, (Comparable)VerticalSlabBlock.VerticalSlabType.DOUBLE).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().cubeAll(this.name(planks), this.blockTexture(planks)))});
    }

    private String name(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
    }

    private ResourceLocation prefix(String prefix, ResourceLocation rl) {
        return new ResourceLocation(rl.m_135827_(), prefix + rl.m_135815_());
    }

    private ResourceLocation suffix(ResourceLocation rl, String suffix) {
        return new ResourceLocation(rl.m_135827_(), rl.m_135815_() + suffix);
    }

    private ResourceLocation remove(ResourceLocation rl, String remove) {
        return new ResourceLocation(rl.m_135827_(), rl.m_135815_().replace(remove, ""));
    }

    private static /* synthetic */ ModelFile lambda$beehiveBlock$4(ModelFile beehiveHoney, ModelFile beehive, BlockState state) {
        return (Integer)state.m_61143_((Property)BlockStateProperties.f_61421_) == 5 ? beehiveHoney : beehive;
    }

    private static /* synthetic */ ModelFile lambda$blockFamily$3(ModelFile pressurePlateDownModel, ModelFile pressurePlateModel, BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_) != false ? pressurePlateDownModel : pressurePlateModel;
    }

    private static /* synthetic */ ModelFile lambda$blockFamily$2(ModelFile buttonPressedModel, ModelFile buttonModel, BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_) != false ? buttonPressedModel : buttonModel;
    }
}

