/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.slabfish.condition;

import com.teamabnormals.environmental.common.entity.animal.slabfish.Slabfish;
import com.teamabnormals.environmental.common.slabfish.SlabfishManager;
import com.teamabnormals.environmental.common.slabfish.SlabfishType;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class SlabfishConditionContext {
    private final Event event;
    private final LazyLoadedValue<RandomSource> random;
    private final LazyLoadedValue<String> name;
    private final LazyLoadedValue<BlockPos> pos;
    private final LazyLoadedValue<Holder<Biome>> biome;
    private final LazyLoadedValue<Boolean> inRaid;
    private final LazyLoadedValue<BlockState> inBlock;
    private final LazyLoadedValue<FluidState> inFluid;
    private final LazyLoadedValue<Boolean> dayTime;
    private final LazyLoadedValue<Boolean> nightTime;
    private final LazyLoadedValue<Integer> light;
    private final Map<LightLayer, LazyLoadedValue<Integer>> lightTypes;
    private final LazyLoadedValue<ResourceLocation> dimension;
    private final LazyLoadedValue<ResourceLocation> slabfishType;
    private final LazyLoadedValue<Boolean> breederInsomnia;
    private final Pair<SlabfishType, SlabfishType> parents;

    private SlabfishConditionContext(Slabfish slabfish, Event event, @Nullable ServerPlayer breeder, @Nullable Slabfish parent1, @Nullable Slabfish parent2) {
        ServerLevel world = (ServerLevel)slabfish.m_20193_();
        this.event = event;
        this.random = new LazyLoadedValue(() -> ((ServerLevel)world).m_213780_());
        this.name = new LazyLoadedValue(() -> slabfish.m_5446_().getString().trim());
        this.pos = new LazyLoadedValue(() -> new BlockPos(slabfish.m_20182_()));
        this.biome = new LazyLoadedValue(() -> world.m_204166_((BlockPos)this.pos.m_13971_()));
        this.inRaid = new LazyLoadedValue(() -> world.m_8832_((BlockPos)this.pos.m_13971_()) != null);
        this.inBlock = new LazyLoadedValue(() -> world.m_8055_((BlockPos)this.pos.m_13971_()));
        this.inFluid = new LazyLoadedValue(() -> world.m_6425_((BlockPos)this.pos.m_13971_()));
        this.dayTime = new LazyLoadedValue(() -> ((ServerLevel)world).m_46461_());
        this.nightTime = new LazyLoadedValue(() -> ((ServerLevel)world).m_46462_());
        this.light = new LazyLoadedValue(() -> world.m_46803_((BlockPos)this.pos.m_13971_()));
        this.lightTypes = new HashMap<LightLayer, LazyLoadedValue<Integer>>();
        for (LightLayer lightType : LightLayer.values()) {
            this.lightTypes.put(lightType, (LazyLoadedValue<Integer>)new LazyLoadedValue(() -> world.m_45517_(lightType, (BlockPos)this.pos.m_13971_())));
        }
        this.dimension = new LazyLoadedValue(() -> world.m_46472_().m_135782_());
        this.slabfishType = new LazyLoadedValue(slabfish::getSlabfishType);
        this.breederInsomnia = new LazyLoadedValue(() -> breeder != null && breeder.m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12992_)) >= 72000 && world.m_46462_());
        SlabfishManager slabfishManager = SlabfishManager.get((LevelReader)world);
        this.parents = parent1 != null && parent2 != null ? new ImmutablePair((Object)slabfishManager.getSlabfishType(parent1.getSlabfishType()).orElse(SlabfishManager.DEFAULT_SLABFISH), (Object)slabfishManager.getSlabfishType(parent2.getSlabfishType()).orElse(SlabfishManager.DEFAULT_SLABFISH)) : null;
    }

    public static SlabfishConditionContext spawned(Slabfish slabfish) {
        return new SlabfishConditionContext(slabfish, Event.SPAWN, null, null, null);
    }

    public static SlabfishConditionContext rename(Slabfish slabfish) {
        return new SlabfishConditionContext(slabfish, Event.RENAME, null, null, null);
    }

    public static SlabfishConditionContext lightning(Slabfish slabfish) {
        return new SlabfishConditionContext(slabfish, Event.LIGHTNING, null, null, null);
    }

    public static SlabfishConditionContext breeding(Slabfish slabfish, @Nullable ServerPlayer breeder, Slabfish parent1, Slabfish parent2) {
        return new SlabfishConditionContext(slabfish, Event.BREED, breeder, parent1, parent2);
    }

    public Event getEvent() {
        return this.event;
    }

    public RandomSource getRandom() {
        return (RandomSource)this.random.m_13971_();
    }

    public String getName() {
        return (String)this.name.m_13971_();
    }

    public BlockPos getPos() {
        return (BlockPos)this.pos.m_13971_();
    }

    public Holder<Biome> getBiome() {
        return (Holder)this.biome.m_13971_();
    }

    public boolean isDay() {
        return (Boolean)this.dayTime.m_13971_();
    }

    public boolean isNight() {
        return (Boolean)this.nightTime.m_13971_();
    }

    public boolean isInRaid() {
        return (Boolean)this.inRaid.m_13971_();
    }

    public boolean isInBlock(Block block) {
        return ((BlockState)this.inBlock.m_13971_()).m_60713_(block);
    }

    public boolean isInBlock(TagKey<Block> tag) {
        return ((BlockState)this.inBlock.m_13971_()).m_204336_(tag);
    }

    public boolean isInFluid(TagKey<Fluid> tag) {
        return ((FluidState)this.inFluid.m_13971_()).m_205070_(tag);
    }

    public int getLight() {
        return (Integer)this.light.m_13971_();
    }

    public int getLightFor(LightLayer lightType) {
        return (Integer)this.lightTypes.get(lightType).m_13971_();
    }

    public ResourceLocation getDimension() {
        return (ResourceLocation)this.dimension.m_13971_();
    }

    public ResourceLocation getSlabfishType() {
        return (ResourceLocation)this.slabfishType.m_13971_();
    }

    public boolean isBreederInsomnia() {
        return (Boolean)this.breederInsomnia.m_13971_();
    }

    @Nullable
    public Pair<SlabfishType, SlabfishType> getParentTypes() {
        return this.parents;
    }

    public static enum Event {
        SPAWN,
        RENAME,
        LIGHTNING,
        BREED;

    }
}

