/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.slabfish;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.teamabnormals.environmental.common.slabfish.SlabfishManager;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class SweaterType
implements Predicate<ItemStack> {
    private final Ingredient ingredient;
    private ResourceLocation registryName;
    private final LazyLoadedValue<ResourceLocation> textureLocation = new LazyLoadedValue(() -> new ResourceLocation(this.getRegistryName().m_135827_(), "sweater/" + this.getRegistryName().m_135815_()));
    private Component displayName;

    public SweaterType(@Nullable Component displayName, Ingredient ingredient) {
        this.displayName = displayName;
        this.ingredient = ingredient;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static SweaterType readFrom(FriendlyByteBuf buf) {
        ResourceLocation registryName = buf.m_130281_();
        Component displayName = buf.m_130238_();
        Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buf);
        return new SweaterType(displayName, ingredient).setRegistryName(registryName);
    }

    public boolean isEmpty() {
        return this == SlabfishManager.EMPTY_SWEATER;
    }

    @Override
    public boolean test(ItemStack stack) {
        return !this.isEmpty() && this.ingredient != Ingredient.f_43901_ && this.ingredient.test(stack);
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    SweaterType setRegistryName(ResourceLocation registryName) {
        this.registryName = registryName;
        if (this.displayName == null) {
            this.displayName = Component.m_237113_((String)registryName.toString());
        }
        return this;
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getTextureLocation() {
        return (ResourceLocation)this.textureLocation.m_13971_();
    }

    public void writeTo(FriendlyByteBuf buf) {
        buf.m_130085_(this.registryName);
        buf.m_130083_(this.displayName);
        this.ingredient.m_43923_(buf);
    }

    public String toString() {
        return "SweaterType{registryName=" + this.registryName + ", displayName=" + this.displayName.getString() + ", ingredient=" + Arrays.toString(this.ingredient.m_43908_()) + "}";
    }

    public static class Deserializer
    implements JsonDeserializer<SweaterType> {
        public SweaterType deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            TagKey tag;
            JsonObject jsonObject = json.getAsJsonObject();
            if (jsonObject.has("item") && jsonObject.has("tag")) {
                throw new JsonSyntaxException("Either 'item' or 'tag' can be present");
            }
            Component displayName = jsonObject.has("displayName") ? (Component)context.deserialize(jsonObject.get("displayName"), Component.class) : null;
            Item item = jsonObject.has("item") && ForgeRegistries.ITEMS.containsKey(new ResourceLocation(jsonObject.get("item").getAsString())) ? (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(jsonObject.get("item").getAsString())) : null;
            TagKey tagKey = tag = jsonObject.has("tag") ? TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(jsonObject.get("tag").getAsString())) : null;
            Ingredient ingredient = item != null ? Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}) : (tag != null ? Ingredient.m_204132_(tag) : Ingredient.f_43901_);
            return new SweaterType(displayName, ingredient);
        }
    }
}

