/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.slabfish;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.teamabnormals.environmental.common.slabfish.SlabfishManager;
import com.teamabnormals.environmental.common.slabfish.SlabfishType;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.slf4j.Logger;

public class SlabfishProvider
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final DataGenerator generator;
    protected final Map<ResourceLocation, TagBuilder> builders = Maps.newLinkedHashMap();
    protected final String modId;
    protected final ExistingFileHelper existingFileHelper;

    public SlabfishProvider(DataGenerator generator, String modId, @Nullable ExistingFileHelper existingFileHelper) {
        this.generator = generator;
        this.modId = modId;
        this.existingFileHelper = existingFileHelper;
    }

    public void m_213708_(CachedOutput directoryCache) throws IOException {
        Path path = this.generator.m_123916_();
        HashSet set = Sets.newHashSet();
        Consumer<SlabfishType> consumer = slabfishType -> {
            if (!set.add(slabfishType.getRegistryName())) {
                throw new IllegalStateException("Duplicate slabfish type " + slabfishType.getRegistryName());
            }
            Path path1 = SlabfishProvider.createPath(path, slabfishType);
            try {
                DataProvider.m_236072_((CachedOutput)directoryCache, (JsonElement)slabfishType.serializeToJson(), (Path)path1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save slabfish type {}", (Object)path1, (Object)ioexception);
            }
        };
        this.registerSlabfishTypes(consumer, this.existingFileHelper);
    }

    protected void registerSlabfishTypes(Consumer<SlabfishType> consumer, ExistingFileHelper existingFileHelper) {
        SlabfishManager.DEFAULT_SLABFISH.save(consumer, new ResourceLocation("environmental", "test"));
    }

    private static Path createPath(Path path, SlabfishType slabfish) {
        return path.resolve("data/" + slabfish.getRegistryName().m_135827_() + "/slabfish/type/" + slabfish.getRegistryName().m_135815_() + ".json");
    }

    public String m_6055_() {
        return "Slabfish";
    }
}

