/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.slabfish;

import com.teamabnormals.environmental.common.entity.animal.slabfish.SlabfishRarity;
import com.teamabnormals.environmental.common.slabfish.BackpackType;
import com.teamabnormals.environmental.common.slabfish.ClientSlabfishManager;
import com.teamabnormals.environmental.common.slabfish.SlabfishLoader;
import com.teamabnormals.environmental.common.slabfish.SlabfishType;
import com.teamabnormals.environmental.common.slabfish.SweaterType;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishConditionContext;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.LevelReader;
import net.minecraftforge.fml.LogicalSide;

public interface SlabfishManager {
    public static final SlabfishType DEFAULT_SLABFISH = new SlabfishType(new ResourceLocation("environmental", "swamp"), SlabfishRarity.COMMON, (Component)Component.m_237115_((String)"entity.environmental.slabfish.type.swamp"), null, false, true, true, -1, new SlabfishCondition[0]);
    public static final SweaterType EMPTY_SWEATER = new SweaterType(null, Ingredient.f_43901_).setRegistryName(new ResourceLocation("environmental", "empty"));
    public static final BackpackType BROWN_BACKPACK = new BackpackType(null, Ingredient.f_43901_).setRegistryName(new ResourceLocation("environmental", "brown"));
    public static final ResourceLocation GHOST = new ResourceLocation("environmental", "ghost");

    public static SlabfishManager get(LogicalSide side) {
        return side.isClient() ? ClientSlabfishManager.INSTANCE : SlabfishLoader.instance;
    }

    public static SlabfishManager get(LevelReader world) {
        return world.m_5776_() ? ClientSlabfishManager.INSTANCE : SlabfishLoader.instance;
    }

    public Optional<SlabfishType> getSlabfishType(ResourceLocation var1);

    public Optional<SweaterType> getSweaterType(ResourceLocation var1);

    public Optional<BackpackType> getBackpackType(ResourceLocation var1);

    default public Optional<SlabfishType> getSlabfishType(SlabfishConditionContext context) {
        return this.getSlabfishType(__ -> true, context);
    }

    public Optional<SlabfishType> getSlabfishType(Predicate<SlabfishType> var1, SlabfishConditionContext var2);

    public Optional<SweaterType> getSweaterType(ItemStack var1);

    public Optional<BackpackType> getBackpackType(ItemStack var1);

    public Optional<SlabfishType> getRandomSlabfishType(Predicate<SlabfishType> var1, RandomSource var2);

    public SlabfishType[] getAllSlabfishTypes();

    public SweaterType[] getAllSweaterTypes();

    public BackpackType[] getAllBackpackTypes();
}

