/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.levelgen.treedecorators;

import com.mojang.serialization.Codec;
import com.teamabnormals.environmental.common.block.HangingWisteriaLeavesBlock;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import com.teamabnormals.environmental.core.registry.EnvironmentalFeatures;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class HangingWisteriaDecorator
extends TreeDecorator {
    public static final Codec<HangingWisteriaDecorator> CODEC = Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").xmap(HangingWisteriaDecorator::new, decorator -> Float.valueOf(decorator.probability)).codec();
    private final float probability;

    public HangingWisteriaDecorator(float probability) {
        this.probability = probability;
    }

    public void m_214187_(TreeDecorator.Context context) {
        LevelSimulatedReader level = context.m_226058_();
        RandomSource random = context.m_226067_();
        BlockState state = this.getBlockForLeaf();
        for (BlockPos pos : context.m_226069_()) {
            int maxLength;
            for (maxLength = 0; maxLength < 2 && level.m_7433_(pos.m_6625_(maxLength + 1), BlockBehaviour.BlockStateBase::m_60795_); ++maxLength) {
            }
            if (maxLength <= 0) continue;
            int actualLength = maxLength == 2 ? (random.m_188503_(3) != 0 ? 2 : 1) : 1;
            for (int i = 1; i <= actualLength; ++i) {
                context.m_226061_(pos.m_6625_(i), (BlockState)state.m_61124_(HangingWisteriaLeavesBlock.HALF, (Comparable)(i == actualLength ? DoubleBlockHalf.LOWER : DoubleBlockHalf.UPPER)));
            }
        }
    }

    public BlockState getBlockForLeaf() {
        if (this.probability < 0.25f) {
            return ((Block)EnvironmentalBlocks.WHITE_HANGING_WISTERIA_LEAVES.get()).m_49966_();
        }
        if (this.probability < 0.5f) {
            return ((Block)EnvironmentalBlocks.BLUE_HANGING_WISTERIA_LEAVES.get()).m_49966_();
        }
        if (this.probability < 0.75f) {
            return ((Block)EnvironmentalBlocks.PURPLE_HANGING_WISTERIA_LEAVES.get()).m_49966_();
        }
        return ((Block)EnvironmentalBlocks.PINK_HANGING_WISTERIA_LEAVES.get()).m_49966_();
    }

    protected TreeDecoratorType<?> m_6663_() {
        return (TreeDecoratorType)EnvironmentalFeatures.HANGING_WISTERIA_LEAVES.get();
    }
}

