/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.levelgen.feature;

import com.mojang.serialization.Codec;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.FluidState;

public class TasselflowerPatchFeature
extends Feature<NoneFeatureConfiguration> {
    public TasselflowerPatchFeature(Codec<NoneFeatureConfiguration> config) {
        super(config);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        RandomSource random = context.m_225041_();
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        BlockState blockstate = ((Block)EnvironmentalBlocks.TASSELFLOWER.get()).m_49966_();
        if (!(TasselflowerPatchFeature.m_65788_((LevelSimulatedReader)level, (BlockPos)pos.m_7495_()) && level.m_8055_(pos).m_60767_().m_76336_() && TasselflowerPatchFeature.isNearWater(level, pos))) {
            return false;
        }
        int flowers = 0;
        BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 128; ++i) {
            float f = random.m_188501_() * 4.0f;
            float f1 = random.m_188501_() * 4.0f;
            float f2 = random.m_188499_() ? -f1 : f1;
            int x = pos.m_123341_() + Math.round(f *= random.m_188499_() ? -f : f);
            int z = pos.m_123343_() + Math.round(f1 *= f2);
            blockpos.m_122178_(x, level.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, x, z), z);
            if (!level.m_46859_((BlockPos)blockpos) || !blockstate.m_60710_((LevelReader)level, (BlockPos)blockpos) || TasselflowerPatchFeature.isNextToTasselflower(level, (BlockPos)blockpos)) continue;
            level.m_7731_((BlockPos)blockpos, blockstate, 2);
            ++flowers;
        }
        return flowers > 0;
    }

    private static boolean isNextToTasselflower(WorldGenLevel level, BlockPos pos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!level.m_8055_(pos.m_121945_(direction)).m_60713_((Block)EnvironmentalBlocks.TASSELFLOWER.get())) continue;
            return true;
        }
        return false;
    }

    private static boolean isNearWater(WorldGenLevel level, BlockPos pos) {
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-4, -4, -4), (BlockPos)pos.m_7918_(4, 0, 4))) {
            FluidState ifluidstate = level.m_6425_(blockpos);
            if (!ifluidstate.m_205070_(FluidTags.f_13131_) || ifluidstate.m_76186_() != 8) continue;
            return true;
        }
        return false;
    }
}

