/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.levelgen.feature;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.teamabnormals.environmental.common.block.WallHibiscusBlock;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalBlockTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.registries.ForgeRegistries;

public class HibiscusBushFeature
extends Feature<NoneFeatureConfiguration> {
    public HibiscusBushFeature(Codec<NoneFeatureConfiguration> config) {
        super(config);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos pos = context.m_159777_();
        WorldGenLevel level = context.m_159774_();
        RandomSource random = context.m_225041_();
        BlockPos.MutableBlockPos mutablepos = new BlockPos.MutableBlockPos();
        if (pos.m_123342_() > context.m_159775_().m_6337_() + 20 && random.m_188499_()) {
            return false;
        }
        for (int i = 0; i < 8; ++i) {
            int x = pos.m_123341_() + random.m_188503_(8) - random.m_188503_(8);
            int z = pos.m_123343_() + random.m_188503_(8) - random.m_188503_(8);
            mutablepos.m_122178_(x, level.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, x, z), z);
            for (int j = 0; j < 2 && HibiscusBushFeature.isNonHibiscusLeaves(level.m_8055_((BlockPos)mutablepos)); ++j) {
                mutablepos.m_122173_(Direction.UP);
            }
            if (!HibiscusBushFeature.canBushGrowAt((LevelAccessor)level, (BlockPos)mutablepos)) continue;
            HibiscusBushFeature.placeBush(level, (BlockPos)mutablepos, random);
            HibiscusBushFeature.placeGroundHibiscuses(level, (BlockPos)mutablepos, random);
            return true;
        }
        return false;
    }

    private static void placeBush(WorldGenLevel level, BlockPos pos, RandomSource random) {
        int maxZ;
        int maxX = random.m_188503_(3) == 0 ? 2 : 1;
        int maxY = random.m_188503_(2) + 1;
        int n = maxZ = random.m_188503_(3) == 0 ? 2 : 1;
        if (maxX == 2 && maxZ == 2) {
            if (random.m_188499_()) {
                maxX = 1;
            } else {
                maxZ = 1;
            }
        }
        int minX = maxX == 2 ? -1 : -random.m_188503_(2);
        int minY = -1;
        int minZ = maxZ == 2 ? -1 : -random.m_188503_(2);
        HibiscusBushFeature.placeLeafCube(level, pos, minX, minY, minZ, maxX += minX, maxY, maxZ += minZ);
        if (random.m_188503_(4) > 0) {
            int offsetX = random.m_188499_() ? -1 : 1;
            int offsetY = random.m_188499_() ? -1 : 1;
            minZ += offsetY;
            maxZ += offsetY;
            --maxY;
            if (random.m_188499_() && (maxX += offsetX) - (minX += offsetX) > 1) {
                if (offsetX > 0) {
                    ++minX;
                } else {
                    --maxX;
                }
            }
            if (random.m_188499_() && maxZ - minZ > 1) {
                if (offsetY > 0) {
                    ++minZ;
                } else {
                    --maxZ;
                }
            }
            HibiscusBushFeature.placeLeafCube(level, pos, minX, minY, minZ, maxX, maxY, maxZ);
        }
        HibiscusBushFeature.placeWallHibiscuses(level, pos, random);
    }

    private static void placeGroundHibiscuses(WorldGenLevel level, BlockPos pos, RandomSource random) {
        BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 80; ++i) {
            Optional block = ForgeRegistries.BLOCKS.tags().getTag(EnvironmentalBlockTags.HIBISCUSES).getRandomElement(random);
            if (!block.isPresent()) continue;
            BlockState blockstate = ((Block)block.get()).m_49966_();
            blockpos.m_122154_((Vec3i)pos, random.m_188503_(8) - random.m_188503_(8), random.m_188503_(4) - random.m_188503_(4), random.m_188503_(8) - random.m_188503_(8));
            if (!level.m_8055_((BlockPos)blockpos).m_60795_() || !blockstate.m_60710_((LevelReader)level, (BlockPos)blockpos)) continue;
            level.m_7731_((BlockPos)blockpos, blockstate, 2);
        }
    }

    private static void placeLeafCube(WorldGenLevel level, BlockPos pos, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_7918_(minX, minY, minZ), (BlockPos)pos.m_7918_(maxX, maxY, maxZ))) {
            if (!HibiscusBushFeature.isAirOrPlant(level.m_8055_(blockpos))) continue;
            level.m_7731_(blockpos, ((Block)EnvironmentalBlocks.HIBISCUS_LEAVES.get()).m_49966_(), 19);
        }
    }

    private static void placeWallHibiscuses(WorldGenLevel level, BlockPos pos, RandomSource random) {
        BlockPos.MutableBlockPos mutablepos = new BlockPos.MutableBlockPos();
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                for (int y = -1; y <= 3; ++y) {
                    mutablepos.m_122154_((Vec3i)pos, x, y, z);
                    if (random.m_188503_(3) <= 0 || !level.m_8055_((BlockPos)mutablepos).m_60795_()) continue;
                    ArrayList validdirections = Lists.newArrayList();
                    for (Direction direction : Direction.values()) {
                        if (direction == Direction.UP || !level.m_8055_(mutablepos.m_121945_(direction)).m_60713_((Block)EnvironmentalBlocks.HIBISCUS_LEAVES.get())) continue;
                        validdirections.add(direction);
                    }
                    if (validdirections.isEmpty()) continue;
                    Direction direction = ((Direction)validdirections.get(random.m_188503_(validdirections.size()))).m_122424_();
                    ForgeRegistries.BLOCKS.tags().getTag(EnvironmentalBlockTags.WALL_HIBISCUSES).getRandomElement(random).ifPresent(block -> level.m_7731_((BlockPos)mutablepos, WallHibiscusBlock.setPropertiesForDirection(block.m_49966_(), direction, random), 2));
                }
            }
        }
    }

    private static boolean canBushGrowAt(LevelAccessor level, BlockPos pos) {
        BlockPos.MutableBlockPos mutablepos = new BlockPos.MutableBlockPos();
        for (int x = -1; x <= 1; ++x) {
            block1: for (int z = -1; z <= 1; ++z) {
                for (int y = 1; y >= -1; --y) {
                    mutablepos.m_122154_((Vec3i)pos, x, y, z);
                    if (!HibiscusBushFeature.isAirOrPlant(level.m_8055_((BlockPos)mutablepos))) {
                        return false;
                    }
                    if (HibiscusBushFeature.m_65788_((LevelSimulatedReader)level, (BlockPos)mutablepos.m_122173_(Direction.DOWN)) || HibiscusBushFeature.isNonHibiscusLeaves(level.m_8055_((BlockPos)mutablepos))) continue block1;
                    if (y != -1) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean isNonHibiscusLeaves(BlockState state) {
        return state.m_204336_(BlockTags.f_13035_) && state.m_60734_() != EnvironmentalBlocks.HIBISCUS_LEAVES.get();
    }

    private static boolean isAirOrPlant(BlockState state) {
        return state.m_60795_() || state.m_60767_() == Material.f_76302_ || state.m_60767_() == Material.f_76300_;
    }
}

