/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.inventory;

import com.teamabnormals.environmental.common.entity.animal.slabfish.Slabfish;
import com.teamabnormals.environmental.common.inventory.SlabfishInventory;
import com.teamabnormals.environmental.common.slabfish.SlabfishManager;
import com.teamabnormals.environmental.common.slabfish.SlabfishType;
import com.teamabnormals.environmental.core.registry.EnvironmentalMenuTypes;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;

public class SlabfishInventoryMenu
extends AbstractContainerMenu {
    private static final ResourceLocation[] SLOT_INDEX_NAMES = new ResourceLocation[]{new ResourceLocation("environmental", "item/slabfish_sweater_slot"), new ResourceLocation("environmental", "item/slabfish_backpack_slot"), new ResourceLocation("environmental", "item/slabfish_backpack_type_slot")};
    private final Container slabfishInventory;
    private final Slabfish slabfish;

    public SlabfishInventoryMenu(int windowId, Inventory playerInventory, final @Nullable SlabfishInventory slabfishInventory, final @Nullable Slabfish slabfish) {
        super((MenuType)EnvironmentalMenuTypes.SLABFISH_INVENTORY.get(), windowId);
        this.slabfishInventory = slabfishInventory;
        this.slabfish = slabfish;
        if (slabfishInventory != null && slabfish != null) {
            slabfishInventory.m_5856_(playerInventory.f_35978_);
            for (int i = 0; i < 3; ++i) {
                this.m_38897_(new Slot(slabfishInventory, i, 8, 18 + i * 18){

                    public boolean m_5857_(ItemStack stack) {
                        return slabfishInventory.m_7013_(this.getSlotIndex(), stack);
                    }

                    public int m_6641_() {
                        return slabfishInventory.getSlotStackLimit(this.getSlotIndex());
                    }

                    public boolean m_6659_() {
                        if (this.getSlotIndex() != 2) {
                            return true;
                        }
                        SlabfishManager slabfishManager = SlabfishManager.get((LevelReader)slabfish.m_20193_());
                        SlabfishType slabfishType = slabfishManager.getSlabfishType(slabfish.getSlabfishType()).orElse(SlabfishManager.DEFAULT_SLABFISH);
                        return slabfish.hasBackpack() && (slabfishType.getCustomBackpack() == null || !slabfishManager.getBackpackType(slabfishType.getCustomBackpack()).isPresent());
                    }
                }).setBackground(InventoryMenu.f_39692_, SLOT_INDEX_NAMES[i]);
            }
            for (int k = 0; k < 3; ++k) {
                for (int l = 0; l < 5; ++l) {
                    this.m_38897_(new Slot(slabfishInventory, 3 + l + k * 5, 80 + l * 18, 18 + k * 18){

                        public boolean m_6659_() {
                            return slabfish.hasBackpack();
                        }
                    });
                }
            }
        }
        for (int i1 = 0; i1 < 3; ++i1) {
            for (int k1 = 0; k1 < 9; ++k1) {
                this.m_38897_(new Slot((Container)playerInventory, k1 + i1 * 9 + 9, 8 + k1 * 18, 102 + i1 * 18 + -18));
            }
        }
        for (int j1 = 0; j1 < 9; ++j1) {
            this.m_38897_(new Slot((Container)playerInventory, j1, 8 + j1 * 18, 142));
        }
    }

    public SlabfishInventoryMenu(int id, Inventory playerInventory) {
        this(id, playerInventory, null, null);
    }

    public boolean m_6875_(Player player) {
        return this.slabfishInventory.m_6542_(player) && this.slabfish.m_6084_() && this.slabfish.m_20270_((Entity)player) < 8.0f;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemstack = slotStack.m_41777_();
            int i = this.slabfishInventory.m_6643_();
            if (index < i) {
                if (!this.m_38903_(slotStack, i, this.f_38839_.size(), true)) {
                    return ItemStack.f_41583_;
                }
            } else {
                if (this.m_38853_(0).m_5857_(slotStack) && !this.m_38853_(0).m_6657_() && !this.m_38903_(slotStack, 0, 1, false)) {
                    return ItemStack.f_41583_;
                }
                if (this.m_38853_(1).m_5857_(slotStack) && !this.m_38853_(1).m_6657_() && !this.m_38903_(slotStack, 1, 2, false)) {
                    return ItemStack.f_41583_;
                }
                if (this.m_38853_(2).m_5857_(slotStack) && !this.m_38853_(2).m_6657_() && !this.m_38903_(slotStack, 2, 3, false)) {
                    return ItemStack.f_41583_;
                }
                if (i <= 3 || !this.m_38903_(slotStack, 3, i, false)) {
                    int firstInvSlot = 18;
                    int firstHotbarSlot = 45;
                    int lastHotbarSlot = 53;
                    if (index >= firstHotbarSlot && index <= lastHotbarSlot ? !this.m_38903_(slotStack, firstInvSlot, firstHotbarSlot, false) : index >= i && index < firstHotbarSlot && !this.m_38903_(slotStack, firstHotbarSlot, lastHotbarSlot + 1, false)) {
                        return ItemStack.f_41583_;
                    }
                }
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        --this.slabfish.playersUsing;
        this.slabfishInventory.m_5785_(player);
    }
}

