/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.animal.koi;

import com.teamabnormals.environmental.common.entity.animal.koi.KoiBreed;
import com.teamabnormals.environmental.core.EnvironmentalConfig;
import com.teamabnormals.environmental.core.registry.EnvironmentalItems;
import com.teamabnormals.environmental.core.registry.EnvironmentalMobEffects;
import com.teamabnormals.environmental.core.registry.EnvironmentalSoundEvents;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class Koi
extends AbstractFish {
    private static final EntityDataAccessor<Integer> BREED = SynchedEntityData.m_135353_(Koi.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final NormalNoise NOISE = NormalNoise.m_230511_((RandomSource)new WorldgenRandom((RandomSource)new LegacyRandomSource(2345L)), (NormalNoise.NoiseParameters)new NormalNoise.NoiseParameters(-3, 1.3, new double[0]));

    public Koi(EntityType<? extends AbstractFish> type, Level world) {
        super(type, world);
        this.f_21342_ = new MoveHelperController(this);
        this.m_21441_(BlockPathTypes.WATER, 0.4f);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 4.25));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 5.0f, 1.6, 1.4, EntitySelector.f_20408_::test));
        this.f_21345_.m_25352_(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 50));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BREED, (Object)0);
    }

    public void m_7380_(CompoundTag Tag2) {
        super.m_7380_(Tag2);
        Tag2.m_128405_("Variant", this.getVariant());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setVariant(tag.m_128451_("Variant"));
    }

    public void m_6872_(ItemStack stack) {
        super.m_6872_(stack);
        CompoundTag compoundtag = stack.m_41784_();
        compoundtag.m_128405_("BucketVariantTag", this.getVariant());
    }

    public void setVariant(int id) {
        this.f_19804_.m_135381_(BREED, (Object)id);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(BREED);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag tag) {
        spawnGroupData = super.m_6518_(level, difficulty, spawnType, spawnGroupData, tag);
        if (spawnType == MobSpawnType.BUCKET && tag != null && tag.m_128425_("BucketVariantTag", 3)) {
            this.setVariant(tag.m_128451_("BucketVariantTag"));
        } else if (spawnType == MobSpawnType.BUCKET) {
            this.setVariant(this.f_19796_.m_188503_(KoiBreed.values().length));
        } else {
            this.setVariant(Koi.getNoiseVariant(this.m_20183_()));
        }
        return spawnGroupData;
    }

    public static int getNoiseVariant(BlockPos pos) {
        double d0 = Koi.getNoiseValue(pos, 0.25);
        double d1 = Mth.m_14008_((double)((1.0 + d0) / 2.0), (double)0.0, (double)0.9999);
        return (int)(d1 * (double)KoiBreed.values().length);
    }

    protected static double getNoiseValue(BlockPos pos, double val) {
        return NOISE.m_75380_((double)pos.m_123341_() * val, (double)pos.m_123342_() * val, (double)pos.m_123343_() * val);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new WaterBoundPathNavigation((Mob)this, worldIn);
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_6142_() && this.m_20069_()) {
            this.m_19920_(0.01f, travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(travelVector);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        Vec3 vector3d = this.m_20184_();
        if ((double)Mth.m_14154_((float)((float)vector3d.f_82480_)) >= 0.01) {
            this.m_146926_((float)(Mth.m_14136_((double)vector3d.f_82480_, (double)Mth.m_14116_((float)((float)vector3d.m_165925_()))) * 57.2957763671875));
        } else {
            this.m_146926_(0.0f);
        }
        this.m_146926_(Koi.normalizeRotation(this.f_19860_, this.m_146909_()));
    }

    protected static float normalizeRotation(float prevRot, float rot) {
        while (rot - prevRot < -180.0f) {
            prevRot -= 360.0f;
        }
        while (rot - prevRot >= 180.0f) {
            prevRot += 360.0f;
        }
        return Mth.m_14179_((float)0.2f, (float)prevRot, (float)rot);
    }

    public void m_8107_() {
        if (!this.m_20069_() && this.f_19861_ && this.f_19863_) {
            this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f), (double)0.45f, (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f)));
            this.f_19861_ = false;
            this.f_19812_ = true;
            this.m_5496_(this.m_5699_(), this.m_6121_(), this.m_6100_());
        }
        if (this.f_19853_.m_46467_() % 20L == 0L && ((Boolean)EnvironmentalConfig.COMMON.serenityEffect.get()).booleanValue()) {
            int horizontalRange = (Integer)EnvironmentalConfig.COMMON.koiHorizontalSerenityRange.get();
            int verticalRange = (Integer)EnvironmentalConfig.COMMON.koiVerticalSerenityRange.get();
            for (Player player : this.f_19853_.m_45976_(Player.class, this.m_20191_().m_82377_((double)horizontalRange, (double)verticalRange, (double)horizontalRange))) {
                if (this.f_19853_.m_5776_()) continue;
                player.m_7292_(new MobEffectInstance((MobEffect)EnvironmentalMobEffects.SERENITY.get(), 100, 0, false, false));
            }
        }
        super.m_8107_();
    }

    public SoundEvent m_5699_() {
        return (SoundEvent)EnvironmentalSoundEvents.KOI_FLOP.get();
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)EnvironmentalSoundEvents.KOI_AMBIENT.get();
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)EnvironmentalSoundEvents.KOI_DEATH.get();
    }

    public SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)EnvironmentalSoundEvents.KOI_HURT.get();
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)EnvironmentalItems.KOI_BUCKET.get());
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0);
    }

    public static boolean canKoiSpawn(EntityType<? extends AbstractFish> type, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource randomIn) {
        return worldIn.m_8055_(pos).m_60713_(Blocks.f_49990_) && worldIn.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_49990_) && pos.m_123342_() > 55;
    }

    static class MoveHelperController
    extends MoveControl {
        private final Koi koi;

        public MoveHelperController(Koi koi) {
            super((Mob)koi);
            this.koi = koi;
        }

        public void m_8126_() {
            if (this.koi.m_204029_(FluidTags.f_13131_)) {
                this.koi.m_20256_(this.koi.m_20184_().m_82520_(0.0, 0.005, 0.0));
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.koi.m_21573_().m_26571_()) {
                double d0 = this.f_24975_ - this.koi.m_20185_();
                double d1 = this.f_24976_ - this.koi.m_20186_();
                double d2 = this.f_24977_ - this.koi.m_20189_();
                double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d1 * d1 + d2 * d2)));
                if (d0 != 0.0 || (d1 /= d3) != 0.0) {
                    float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.koi.m_146922_(this.m_24991_(this.koi.m_146908_(), f, 15.0f));
                    this.koi.f_20883_ = this.koi.m_146908_();
                    this.koi.f_20885_ = this.koi.m_146908_();
                }
                float f1 = (float)(this.f_24978_ * this.koi.m_21051_(Attributes.f_22279_).m_22135_());
                this.koi.m_7910_(Mth.m_14179_((float)0.125f, (float)this.koi.m_6113_(), (float)f1));
                this.koi.m_20256_(this.koi.m_20184_().m_82520_(0.0, (double)this.koi.m_6113_() * d1 * 0.03, 0.0));
            }
        }
    }
}

