/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.animal.deer;

import com.teamabnormals.environmental.common.entity.animal.deer.AbstractDeer;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalItemTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class Reindeer
extends AbstractDeer {
    private static final EntityDataAccessor<Boolean> HOLIDAY = SynchedEntityData.m_135353_(Reindeer.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public Reindeer(EntityType<? extends Animal> type, Level level) {
        super(type, level);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HOLIDAY, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Holiday", this.isHoliday());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setHoliday(compound.m_128471_("Holiday"));
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(EnvironmentalItemTags.REINDEER_FOOD);
    }

    @Override
    public Ingredient getTemptItems() {
        return Ingredient.m_204132_(EnvironmentalItemTags.REINDEER_TEMPT_ITEMS);
    }

    private void setHoliday(boolean isHoliday) {
        this.f_19804_.m_135381_(HOLIDAY, (Object)isHoliday);
    }

    public boolean isHoliday() {
        return (Boolean)this.f_19804_.m_135370_(HOLIDAY);
    }

    public AgeableMob m_142606_(ServerLevel level, AgeableMob ageable) {
        Reindeer entity = (Reindeer)((EntityType)EnvironmentalEntityTypes.REINDEER.get()).m_20615_((Level)level);
        Reindeer partner = (Reindeer)ageable;
        if (entity != null) {
            entity.setHasAntlers(true);
            entity.setTrusting(this.isTrusting() || partner.isTrusting());
            entity.setHoliday(this.isHolidayCriteria());
        }
        return entity;
    }

    private boolean isHolidayCriteria() {
        return this.f_19796_.m_188503_(9) == 0 && LocalDate.now().get(ChronoField.MONTH_OF_YEAR) == 12;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.setHasAntlers(true);
        this.setHoliday(this.isHolidayCriteria());
        return super.m_6518_(worldIn, difficulty, reason, spawnDataIn, dataTag);
    }
}

