/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.animal.deer;

import com.teamabnormals.environmental.common.entity.animal.deer.AbstractDeer;
import com.teamabnormals.environmental.common.entity.animal.deer.DeerCoatColors;
import com.teamabnormals.environmental.common.entity.animal.deer.DeerCoatTypes;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalItemTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class Deer
extends AbstractDeer {
    private static final EntityDataAccessor<Integer> DEER_COAT_COLOR = SynchedEntityData.m_135353_(Deer.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DEER_COAT_TYPE = SynchedEntityData.m_135353_(Deer.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public Deer(EntityType<? extends Animal> type, Level level) {
        super(type, level);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DEER_COAT_COLOR, (Object)0);
        this.f_19804_.m_135372_(DEER_COAT_TYPE, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("CoatColor", this.getCoatColor());
        compound.m_128405_("CoatType", this.getCoatType());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setCoatColor(compound.m_128451_("CoatColor"));
        this.setCoatType(compound.m_128451_("CoatType"));
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(EnvironmentalItemTags.DEER_FOOD);
    }

    private void setCoatColor(int id) {
        this.f_19804_.m_135381_(DEER_COAT_COLOR, (Object)id);
    }

    public int getCoatColor() {
        return (Integer)this.f_19804_.m_135370_(DEER_COAT_COLOR);
    }

    private void setCoatType(int id) {
        int color = this.getCoatColor();
        if (color == 2 && id == 1) {
            this.f_19804_.m_135381_(DEER_COAT_TYPE, (Object)0);
        } else {
            this.f_19804_.m_135381_(DEER_COAT_TYPE, (Object)id);
        }
    }

    public int getCoatType() {
        return (Integer)this.f_19804_.m_135370_(DEER_COAT_TYPE);
    }

    public AgeableMob m_142606_(ServerLevel level, AgeableMob ageable) {
        Deer entity = (Deer)((EntityType)EnvironmentalEntityTypes.DEER.get()).m_20615_((Level)level);
        Deer partner = (Deer)ageable;
        if (entity != null) {
            entity.setCoatColor(this.f_19796_.m_188499_() ? partner.getCoatColor() : this.getCoatColor());
            entity.setCoatType(this.f_19796_.m_188499_() ? partner.getCoatType() : this.getCoatType());
            entity.setHasAntlers(this.f_19796_.m_188499_());
            entity.setTrusting(this.isTrusting() || partner.isTrusting());
        }
        return entity;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        int deerCoatColor;
        if (spawnDataIn instanceof DeerSpawnGroupData) {
            DeerSpawnGroupData deerSpawnGroupData = (DeerSpawnGroupData)spawnDataIn;
            deerCoatColor = deerSpawnGroupData.coatColor;
        } else {
            deerCoatColor = this.f_19796_.m_188503_(DeerCoatColors.values().length);
            spawnDataIn = new DeerSpawnGroupData(deerCoatColor);
        }
        this.setCoatColor(deerCoatColor);
        this.setCoatType(this.f_19796_.m_188503_(DeerCoatTypes.values().length));
        this.setHasAntlers(this.f_19796_.m_188499_());
        return super.m_6518_(worldIn, difficulty, reason, spawnDataIn, dataTag);
    }

    public static class DeerSpawnGroupData
    extends AgeableMob.AgeableMobGroupData
    implements SpawnGroupData {
        public final int coatColor;

        public DeerSpawnGroupData(int coatColor) {
            super(0.3f);
            this.coatColor = coatColor;
        }
    }
}

