/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.animal;

import com.teamabnormals.environmental.common.damagesource.MountDamageSource;
import com.teamabnormals.environmental.common.entity.ai.goal.HerdLandWanderGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.zebra.ZebraAttackGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.zebra.ZebraAvoidEntityGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.zebra.ZebraFleeGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.zebra.ZebraFollowParentGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.zebra.ZebraHurtByTargetGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.zebra.ZebraRunAroundLikeCrazyGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.zebra.ZebraTemptGoal;
import com.teamabnormals.environmental.common.network.message.C2SZebraJumpMessage;
import com.teamabnormals.environmental.core.Environmental;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalEntityTypeTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalSoundEvents;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class Zebra
extends AbstractHorse
implements NeutralMob {
    private static final UUID SPEED_MODIFIER_KICKING_ID = UUID.fromString("AF33F716-0F4D-43CA-9C8E-1068AE2F38E6");
    private static final AttributeModifier SPEED_MODIFIER_KICKING = new AttributeModifier(SPEED_MODIFIER_KICKING_ID, "Kicking speed reduction", -0.8, AttributeModifier.Operation.MULTIPLY_BASE);
    private final Predicate<LivingEntity> kickablePredicate = living -> living.m_6084_() && living != this && !living.m_6095_().m_204039_(EnvironmentalEntityTypeTags.ZEBRAS_DONT_KICK) && EntitySelector.f_20406_.test(living) && !living.m_20159_();
    private static final EntityDataAccessor<Integer> KICK_TIME = SynchedEntityData.m_135353_(Zebra.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)16, (int)32);
    private int remainingPersistentAngerTime;
    private UUID persistentAngerTarget;
    private ZebraFleeGoal fleeGoal;
    private float jumpStrength = -1.0f;
    private int kickCounter = 20;
    private float backKickAnim;
    private float backKickAnimO;
    private float frontKickAnim;
    private float frontKickAnimO;

    public Zebra(EntityType<? extends AbstractHorse> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        this.fleeGoal = new ZebraFleeGoal(this, 1.8);
        this.f_21345_.m_25352_(1, (Goal)new ZebraAttackGoal(this, 1.6));
        this.f_21345_.m_25352_(2, (Goal)this.fleeGoal);
        this.f_21345_.m_25352_(3, (Goal)new ZebraRunAroundLikeCrazyGoal(this, 1.6));
        this.f_21345_.m_25352_(4, (Goal)new BreedGoal((Animal)this, 1.0, AbstractHorse.class));
        this.f_21345_.m_25352_(5, (Goal)new ZebraFollowParentGoal(this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new HerdLandWanderGoal((PathfinderMob)this, 0.7, 1.2, 16));
        this.f_21345_.m_25352_(7, new ZebraAvoidEntityGoal<Player>(this, Player.class, 8.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new ZebraHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((Zebra)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(3, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
        this.m_7509_();
    }

    protected void m_7509_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new ZebraTemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42677_, Items.f_42436_, Items.f_42437_})));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(KICK_TIME, (Object)0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.m_21678_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.m_147285_(this.f_19853_, compound);
    }

    protected void m_214179_(RandomSource random) {
        this.m_21051_(Attributes.f_22276_).m_22100_((double)this.m_218805_(random));
        this.m_21051_(Attributes.f_22279_).m_22100_(this.m_218811_(random));
        this.m_21051_(Attributes.f_22288_).m_22100_(this.m_218809_(random));
        this.m_21051_(Attributes.f_22281_).m_22100_(this.generateRandomAttackDamage(random));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return AbstractHorse.m_30627_().m_22266_(Attributes.f_22281_).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22277_, 8.0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19861_ || this.isInFluidType()) {
            this.jumpStrength = -1.0f;
        }
        if (this.m_6142_() && this.m_6084_()) {
            boolean resetkickcounter = true;
            if (!this.m_6162_() && !this.isKicking()) {
                boolean isfleeing;
                LivingEntity rider = this.m_6688_();
                boolean jumpkick = this.canJumpKick();
                boolean bl = isfleeing = this.isFleeing() && !this.m_6107_() && !this.m_21573_().m_26571_();
                if (!this.m_30622_() || jumpkick) {
                    List nearby = this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_((double)0.9f), this.kickablePredicate);
                    boolean shouldkick = false;
                    boolean backkick = true;
                    for (LivingEntity living : nearby) {
                        Vec3 attackAngleVector = living.m_20182_().m_82546_(this.m_20182_()).m_82541_();
                        attackAngleVector = new Vec3(attackAngleVector.f_82479_, 0.0, attackAngleVector.f_82481_);
                        double angle = attackAngleVector.m_82526_(Vec3.m_82498_((float)0.0f, (float)this.m_213816_()).m_82541_());
                        if (angle > 0.7) {
                            if (!isfleeing && !jumpkick && (rider == null || !(rider.f_20902_ > 0.0f))) continue;
                            shouldkick = true;
                            backkick = false;
                            break;
                        }
                        if (!(angle < -0.7) || jumpkick) continue;
                        if (isfleeing) {
                            shouldkick = true;
                            continue;
                        }
                        if (rider == null) {
                            if (!living.m_20163_() && --this.kickCounter <= 0) {
                                shouldkick = true;
                                continue;
                            }
                            resetkickcounter = false;
                            continue;
                        }
                        if (!(rider.f_20902_ <= 0.0f)) continue;
                        shouldkick = true;
                    }
                    if (shouldkick) {
                        this.kick(backkick, rider == null && !isfleeing);
                        this.playKickingSound();
                    }
                }
            } else {
                this.setKickTime(this.getKickTime() + 1);
                if (this.getKickTime() > 10) {
                    this.setKickTime(0);
                    this.m_21051_(Attributes.f_22279_).m_22130_(SPEED_MODIFIER_KICKING);
                }
            }
            if (resetkickcounter) {
                this.kickCounter = 20;
            }
        }
        this.backKickAnimO = this.backKickAnim;
        if (this.backKickAnim > 0.0f) {
            this.backKickAnim -= 1.0f;
        }
        this.frontKickAnimO = this.frontKickAnim;
        if (this.frontKickAnim > 0.0f) {
            this.frontKickAnim -= 1.0f;
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_) {
            this.m_21666_((ServerLevel)this.f_19853_, true);
        }
    }

    public void m_7023_(Vec3 motion) {
        boolean flag = !this.m_30616_();
        super.m_7023_(motion);
        if (flag && this.m_30616_() && this.m_6688_() instanceof Player) {
            Environmental.PLAY.sendToServer((Object)new C2SZebraJumpMessage((float)this.m_20184_().f_82480_));
        }
    }

    public void m_6703_(@Nullable LivingEntity attacker) {
        if (attacker != null && this.f_19853_ instanceof ServerLevel) {
            int fleetime = this.m_217043_().m_188503_(40) + 100;
            float fleedirection = this.m_217043_().m_188501_() * 360.0f;
            List<Zebra> zebras = this.f_19853_.m_6443_(Zebra.class, this.m_20191_().m_82377_(10.0, 4.0, 10.0), zebra -> zebra != this && !zebra.isFleeing() && !zebra.m_30614_() && zebra.m_5448_() == null).stream().sorted(Comparator.comparingDouble(entity -> entity.m_20280_((Entity)this))).limit(3L).toList();
            for (Zebra zebra2 : zebras) {
                zebra2.getFleeGoal().trigger(fleetime, fleedirection);
            }
            if (this.m_6162_()) {
                this.fleeGoal.trigger(fleetime, fleedirection);
            }
        }
        super.m_6703_(attacker);
    }

    public ZebraFleeGoal getFleeGoal() {
        return this.fleeGoal;
    }

    public boolean isFleeing() {
        return this.fleeGoal.running();
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!this.m_6162_()) {
            if (this.m_30614_() && player.m_36341_()) {
                this.m_213583_(player);
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            if (this.m_20160_()) {
                return super.m_6071_(player, hand);
            }
        }
        if (!stack.m_41619_()) {
            boolean flag;
            if (this.m_6898_(stack) && this.m_5448_() == null) {
                return this.m_30580_(player, stack);
            }
            InteractionResult result = stack.m_41647_(player, (LivingEntity)this, hand);
            if (result.m_19077_()) {
                return result;
            }
            if (!this.m_30614_()) {
                if (this.m_5448_() == null) {
                    this.m_7564_();
                    this.m_6710_((LivingEntity)player);
                    return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
                }
                return InteractionResult.CONSUME;
            }
            boolean bl = flag = !this.m_6162_() && !this.m_6254_() && stack.m_150930_(Items.f_42450_);
            if (this.m_6010_(stack) || flag) {
                this.m_213583_(player);
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
        }
        if (!this.m_6162_()) {
            this.m_6835_(player);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public InteractionResult m_30580_(Player player, ItemStack stack) {
        if (!this.m_30614_()) {
            this.m_7564_();
            this.m_6710_((LivingEntity)player);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_30580_(player, stack);
    }

    public boolean isKicking() {
        return this.getKickTime() > 0;
    }

    private int getKickTime() {
        return (Integer)this.f_19804_.m_135370_(KICK_TIME);
    }

    private void setKickTime(int time) {
        this.f_19804_.m_135381_(KICK_TIME, (Object)time);
    }

    public void setJumpStrength(float strength) {
        this.jumpStrength = strength;
    }

    private float getBackKickAnim(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.backKickAnimO, (float)this.backKickAnim);
    }

    public float getBackKickBodyRot(float partialTick) {
        float anim = this.getBackKickAnim(partialTick);
        return anim < 5.0f ? Zebra.smoothAnim(0.0f, 5.0f, anim) : (anim < 6.0f ? 1.0f : Zebra.smoothAnim(10.0f, 6.0f, anim));
    }

    public float getBackKickLegRot(float partialTick) {
        float anim = this.getBackKickAnim(partialTick);
        return anim < 5.0f ? Zebra.smoothAnim(0.0f, 5.0f, anim) : (anim < 8.0f ? Zebra.smoothAnim(8.0f, 5.0f, anim) : 0.0f);
    }

    private float getFrontKickAnim(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.frontKickAnimO, (float)this.frontKickAnim);
    }

    public float getFrontKickBodyRot(float partialTick) {
        float anim = this.getFrontKickAnim(partialTick);
        return anim < 6.0f ? Zebra.smoothAnim(0.0f, 6.0f, anim) : (anim < 8.0f ? 1.0f : Zebra.smoothAnim(12.0f, 8.0f, anim));
    }

    public float getFrontKickLegRot(float partialTick) {
        float anim = this.getFrontKickAnim(partialTick);
        return anim < 6.0f ? Zebra.smoothAnim(0.0f, 6.0f, anim) : (anim < 7.0f ? 1.0f : (anim < 10.0f ? Zebra.smoothAnim(10.0f, 7.0f, anim) : 0.0f));
    }

    private static float smoothAnim(float min, float max, float progress) {
        return 1.0f - Mth.m_14207_((float)((progress - max) / (max - min)));
    }

    public void playBackKickAnim() {
        this.backKickAnim = 10.0f;
        this.frontKickAnim = 0.0f;
        this.backKickAnimO = this.backKickAnim;
        this.frontKickAnimO = this.frontKickAnim;
    }

    public void playFrontKickAnim() {
        this.backKickAnim = 0.0f;
        this.frontKickAnim = 12.0f;
        this.backKickAnimO = this.backKickAnim;
        this.frontKickAnimO = this.frontKickAnim;
    }

    public void kick(boolean backKick) {
        this.kick(backKick, false);
    }

    public void kick(boolean backKick, boolean softBackKick) {
        this.setKickTime(1);
        this.m_30661_(false);
        AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22279_);
        if (!attributeinstance.m_22109_(SPEED_MODIFIER_KICKING)) {
            attributeinstance.m_22118_(SPEED_MODIFIER_KICKING);
        }
        if (!backKick) {
            this.playFrontKickAnim();
            this.f_19853_.m_7605_((Entity)this, (byte)8);
        } else {
            this.playBackKickAnim();
            this.f_19853_.m_7605_((Entity)this, (byte)9);
        }
        List nearby = this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(1.0), this.kickablePredicate);
        for (LivingEntity living : nearby) {
            boolean flag;
            Vec3 attackAngleVector = living.m_20182_().m_82546_(this.m_20182_()).m_82541_();
            attackAngleVector = new Vec3(attackAngleVector.f_82479_, 0.0, attackAngleVector.f_82481_);
            float rot = this.m_213816_();
            float x = Mth.m_14031_((float)(rot * ((float)Math.PI / 180)));
            float z = -Mth.m_14089_((float)(rot * ((float)Math.PI / 180)));
            double angle = attackAngleVector.m_82526_(Vec3.m_82498_((float)0.0f, (float)rot).m_82541_());
            boolean jumpkick = this.canJumpKick();
            if (!(!backKick && angle > 0.7) && (!backKick || !(angle < -0.7))) continue;
            LivingEntity rider = this.m_6688_();
            Object source = rider != null ? new MountDamageSource("ridingZebra", (Entity)this, (Entity)rider) : DamageSource.m_19370_((LivingEntity)this);
            float damage = (float)this.m_21133_(Attributes.f_22281_);
            float knockback = (float)this.m_21133_(Attributes.f_22282_);
            if (jumpkick) {
                float f = this.jumpStrength;
                if (rider != null && rider.f_20902_ <= 0.0f) {
                    f *= 0.5f;
                }
                damage += f * 6.0f;
                knockback = knockback * 0.8f + f * 1.1f;
            } else if (backKick) {
                if (!softBackKick) {
                    damage += 2.0f;
                } else if (damage > 1.0f) {
                    damage = 1.0f;
                }
                knockback *= 1.2f;
            } else {
                knockback *= 0.8f;
            }
            if (!(flag = living.m_6469_(source, (float)((int)damage)))) continue;
            this.m_19970_((LivingEntity)this, (Entity)living);
            if (!backKick) {
                living.m_147240_((double)knockback, (double)x, (double)z);
                continue;
            }
            living.m_147240_((double)knockback, (double)(-x), (double)(-z));
        }
    }

    public void flingPassengers(boolean backFling) {
        float rot = this.m_213816_();
        float x = Mth.m_14031_((float)(rot * ((float)Math.PI / 180)));
        float z = -Mth.m_14089_((float)(rot * ((float)Math.PI / 180)));
        for (int i = this.m_20197_().size() - 1; i >= 0; --i) {
            Entity passenger = (Entity)this.m_20197_().get(i);
            passenger.m_8127_();
            Vec3 vec3 = new Vec3((double)x, 0.0, (double)z).m_82490_((double)0.8f);
            if (backFling) {
                vec3 = vec3.m_82490_(-1.0);
            }
            passenger.m_5997_(vec3.f_82479_, 0.8, vec3.f_82481_);
            passenger.f_19864_ = true;
        }
    }

    protected double generateRandomAttackDamage(RandomSource random) {
        return 1.0f + (float)random.m_188503_(2) + (float)random.m_188503_(2) + (float)random.m_188503_(2);
    }

    public void m_21463_(Entity entity, boolean broadcast) {
        super.m_21463_(entity, broadcast);
        if (entity instanceof LivingEntity) {
            this.m_6710_((LivingEntity)entity);
        }
    }

    private boolean canDoIdleAnimation() {
        return !this.isKicking() && this.m_21566_().m_24999_() <= 1.0;
    }

    private boolean canJumpKick() {
        return this.jumpStrength >= 0.0f;
    }

    public boolean m_7559_() {
        return this.canDoIdleAnimation();
    }

    public boolean m_6779_(LivingEntity target) {
        return (!this.m_30614_() || !(target instanceof Player)) && super.m_6779_(target);
    }

    public void m_21662_() {
        super.m_21662_();
        this.m_6598_(null);
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public void m_7870_(int time) {
        this.remainingPersistentAngerTime = time;
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_6925_(UUID target) {
        this.persistentAngerTarget = target;
    }

    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    protected SoundEvent m_7515_() {
        if (this.canDoIdleAnimation()) {
            super.m_7515_();
        }
        return (SoundEvent)EnvironmentalSoundEvents.ZEBRA_AMBIENT.get();
    }

    protected SoundEvent m_7871_() {
        if (this.canDoIdleAnimation()) {
            super.m_7871_();
        }
        return (SoundEvent)EnvironmentalSoundEvents.ZEBRA_ANGRY.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)EnvironmentalSoundEvents.ZEBRA_DEATH.get();
    }

    protected SoundEvent m_7872_() {
        return (SoundEvent)EnvironmentalSoundEvents.ZEBRA_EAT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        if (!this.isKicking()) {
            super.m_7975_(source);
        }
        return (SoundEvent)EnvironmentalSoundEvents.ZEBRA_HURT.get();
    }

    public void playKickingSound() {
        this.m_5496_(this.m_7515_(), this.m_6121_(), this.m_6100_());
    }

    public void playAngrySound() {
        this.m_5496_(this.m_7871_(), this.m_6121_(), this.m_6100_());
    }

    protected void m_5877_(SoundType soundType) {
        this.m_5496_((SoundEvent)EnvironmentalSoundEvents.ZEBRA_GALLOP.get(), soundType.m_56773_() * 0.15f, soundType.m_56774_());
        if (this.f_19796_.m_188503_(10) == 0) {
            this.m_5496_((SoundEvent)EnvironmentalSoundEvents.ZEBRA_BREATHE.get(), soundType.m_56773_() * 0.6f, soundType.m_56774_());
        }
    }

    protected void m_7486_() {
        this.m_5496_((SoundEvent)EnvironmentalSoundEvents.ZEBRA_JUMP.get(), 0.4f, 1.0f);
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        if (!state.m_60767_().m_76332_()) {
            BlockState blockstate = this.f_19853_.m_8055_(pos.m_7494_());
            SoundType soundtype = state.getSoundType((LevelReader)this.f_19853_, pos, (Entity)this);
            if (blockstate.m_60713_(Blocks.f_50125_)) {
                soundtype = blockstate.getSoundType((LevelReader)this.f_19853_, pos, (Entity)this);
            }
            if ((this.m_20160_() || this.m_21566_().m_24999_() > 1.6) && this.f_30523_) {
                ++this.f_30524_;
                if (this.f_30524_ > 5 && this.f_30524_ % 3 == 0) {
                    this.m_5877_(soundtype);
                } else if (this.f_30524_ <= 5) {
                    this.m_5496_(SoundEvents.f_12036_, soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
                }
            } else if (soundtype == SoundType.f_56736_) {
                this.m_5496_(SoundEvents.f_12036_, soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
            } else {
                this.m_5496_(SoundEvents.f_12035_, soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
            }
        }
    }

    public void m_7332_(Entity rider) {
        super.m_7332_(rider);
        float f = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float f1 = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float f2 = 0.0f;
        float f3 = 0.0f;
        float nostandanim = 1.0f - this.f_30514_;
        if (this.f_30514_ > 0.0f) {
            f2 += 0.7f * this.f_30514_;
            f3 += 0.15f * this.f_30514_;
            if (rider instanceof LivingEntity) {
                ((LivingEntity)rider).f_20883_ = this.f_20883_;
            }
        }
        if (this.backKickAnimO > 0.0f) {
            float rot = this.getBackKickBodyRot(0.0f);
            f2 += -0.2f * rot * nostandanim;
            f3 += 0.15f * rot * nostandanim;
        } else if (this.frontKickAnimO > 0.0f) {
            float rot = this.getFrontKickBodyRot(0.0f);
            f2 += 0.2f * rot * nostandanim;
            f3 += 0.15f * rot * nostandanim;
        }
        rider.m_6034_(this.m_20185_() + (double)(f2 * f), this.m_20186_() + this.m_6048_() + rider.m_6049_() + (double)f3, this.m_20189_() - (double)(f2 * f1));
    }

    public void m_7822_(byte id) {
        if (id == 8) {
            this.playFrontKickAnim();
        } else if (id == 9) {
            this.playBackKickAnim();
        } else {
            super.m_7822_(id);
        }
    }

    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        return (AgeableMob)((EntityType)EnvironmentalEntityTypes.ZEBRA.get()).m_20615_((Level)level);
    }

    protected void m_149508_(AgeableMob parentA, AbstractHorse parentB) {
        super.m_149508_(parentA, parentB);
        double d0 = this.m_21172_(Attributes.f_22281_) + parentA.m_21172_(Attributes.f_22281_) + this.generateRandomAttackDamage(this.f_19796_);
        parentB.m_21051_(Attributes.f_22281_).m_22100_(d0 / 3.0);
    }

    public double m_6048_() {
        return super.m_6048_() - 0.175;
    }
}

