/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.animal;

import com.teamabnormals.environmental.common.entity.ai.goal.tapir.TapirHuntFloraGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.tapir.TapirPanicGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.tapir.TapirSniffForFloraGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.tapir.TapirTemptGoal;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalParticleTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalSoundEvents;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class Tapir
extends Animal {
    private static final EntityDataAccessor<Integer> TRACKING_TIME = SynchedEntityData.m_135353_(Tapir.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> HAS_BABY_PATTERN = SynchedEntityData.m_135353_(Tapir.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> BEING_TEMPTED = SynchedEntityData.m_135353_(Tapir.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_SNIFFING = SynchedEntityData.m_135353_(Tapir.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_GRAZING = SynchedEntityData.m_135353_(Tapir.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<BlockPos>> FLORA_POS = SynchedEntityData.m_135353_(Tapir.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private Item floraItem;
    private boolean running;
    private int sniffTimer;
    private float sniffAmount;
    private float sniffAmount0;
    private float snoutRaiseAmount;
    private float snoutRaiseAmount0;
    private float noAnimAmount;
    private float noAnimAmount0;
    private float neckAngle;
    private float neckAngle0;
    private int headShakeAnim;
    private int headShakeAnim0;

    public Tapir(EntityType<? extends Tapir> type, Level world) {
        super(type, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new TapirPanicGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new TapirSniffForFloraGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new TapirHuntFloraGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new TapirTemptGoal(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TRACKING_TIME, (Object)0);
        this.f_19804_.m_135372_(HAS_BABY_PATTERN, (Object)false);
        this.f_19804_.m_135372_(BEING_TEMPTED, (Object)false);
        this.f_19804_.m_135372_(IS_SNIFFING, (Object)false);
        this.f_19804_.m_135372_(IS_GRAZING, (Object)false);
        this.f_19804_.m_135372_(FLORA_POS, Optional.empty());
    }

    public void m_7380_(CompoundTag compound) {
        BlockPos florapos;
        super.m_7380_(compound);
        compound.m_128379_("BabyPattern", this.hasBabyPattern());
        if (this.floraItem != null) {
            compound.m_128359_("FloraItem", ForgeRegistries.ITEMS.getKey((Object)this.floraItem).toString());
        }
        if ((florapos = this.getFloraPos()) != null) {
            compound.m_128405_("FloraX", florapos.m_123341_());
            compound.m_128405_("FloraY", florapos.m_123342_());
            compound.m_128405_("FloraZ", florapos.m_123343_());
        }
        compound.m_128405_("TrackingTime", this.getTrackingTime());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setHasBabyPattern(compound.m_128471_("BabyPattern"));
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(compound.m_128461_("FloraItem")));
        if (item != Items.f_41852_) {
            this.floraItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(compound.m_128461_("FloraItem")));
        }
        if (compound.m_128425_("FloraX", 99) && compound.m_128425_("FloraY", 99) && compound.m_128425_("FloraZ", 99)) {
            BlockPos blockpos = new BlockPos(compound.m_128451_("FloraX"), compound.m_128451_("FloraY"), compound.m_128451_("FloraZ"));
            this.setFloraPos(blockpos);
        }
        this.setTrackingTime(compound.m_128451_("TrackingTime"));
    }

    public void stopTracking() {
        this.setTrackingTime(0);
        this.setFloraPos(null);
        this.floraItem = null;
        this.f_27555_ = null;
    }

    public int getTrackingTime() {
        return (Integer)this.f_19804_.m_135370_(TRACKING_TIME);
    }

    public void setTrackingTime(int time) {
        this.f_19804_.m_135381_(TRACKING_TIME, (Object)time);
    }

    public boolean hasBabyPattern() {
        return (Boolean)this.f_19804_.m_135370_(HAS_BABY_PATTERN);
    }

    public void setHasBabyPattern(boolean hasBabyPattern) {
        this.f_19804_.m_135381_(HAS_BABY_PATTERN, (Object)hasBabyPattern);
    }

    public boolean isBeingTempted() {
        return (Boolean)this.f_19804_.m_135370_(BEING_TEMPTED);
    }

    public void setBeingTempted(boolean tempted) {
        this.f_19804_.m_135381_(BEING_TEMPTED, (Object)tempted);
    }

    public boolean isSniffing() {
        return (Boolean)this.f_19804_.m_135370_(IS_SNIFFING);
    }

    public void setSniffing(boolean sniffing) {
        this.f_19804_.m_135381_(IS_SNIFFING, (Object)sniffing);
    }

    public boolean isGrazing() {
        return (Boolean)this.f_19804_.m_135370_(IS_GRAZING);
    }

    public void setGrazing(boolean grazing) {
        this.f_19804_.m_135381_(IS_GRAZING, (Object)grazing);
    }

    public boolean hasFloraPos() {
        return this.getFloraPos() != null;
    }

    public BlockPos getFloraPos() {
        return ((Optional)this.f_19804_.m_135370_(FLORA_POS)).orElse(null);
    }

    public void setFloraPos(BlockPos pos) {
        this.f_19804_.m_135381_(FLORA_POS, Optional.ofNullable(pos));
    }

    public Item getFloraItem() {
        return this.floraItem;
    }

    public boolean hasFloraItem() {
        return this.floraItem != null;
    }

    public float getSnoutRaiseAmount(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.snoutRaiseAmount0, (float)this.snoutRaiseAmount);
    }

    public float getNoAnimAmount(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.noAnimAmount0, (float)this.noAnimAmount);
    }

    public float getNeckAngle(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.neckAngle0, (float)this.neckAngle);
    }

    public float getHeadShakeAnim(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.headShakeAnim0, (float)this.headShakeAnim);
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockitem = (BlockItem)item;
            if (!this.m_6162_() && this.m_6898_(stack)) {
                if (this.getTrackingTime() <= 0) {
                    if (!this.f_19853_.m_5776_()) {
                        this.floraItem = blockitem;
                        this.f_27555_ = player.m_20148_();
                        this.setTrackingTime(300);
                        this.f_19853_.m_7605_((Entity)this, (byte)4);
                    }
                    return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
                }
                return InteractionResult.PASS;
            }
        }
        return super.m_6071_(player, hand);
    }

    public void m_8119_() {
        super.m_8119_();
        this.sniffAmount0 = this.sniffAmount;
        this.sniffAmount = this.isSniffing() ? Math.min(1.0f, this.sniffAmount + 0.25f) : Math.max(0.0f, this.sniffAmount - 0.25f);
        this.headShakeAnim0 = this.headShakeAnim;
        if (this.headShakeAnim > 0) {
            --this.headShakeAnim;
        }
        this.noAnimAmount0 = this.noAnimAmount;
        this.noAnimAmount = this.isSniffing() || this.isGrazing() ? Math.min(1.0f, this.noAnimAmount + 0.15f) : Math.max(0.0f, this.noAnimAmount - 0.15f);
        this.neckAngle0 = this.neckAngle;
        if (this.isSniffing()) {
            this.neckAngle = Math.min(1.0f, this.neckAngle + 0.15f);
        } else if (this.isGrazing()) {
            boolean lookup;
            BlockPos florapos = this.getFloraPos();
            boolean bl = lookup = florapos != null && this.f_19853_.m_8055_(florapos).m_60808_((BlockGetter)this.f_19853_, florapos).m_83288_(Direction.Axis.Y) + (double)florapos.m_123342_() > this.m_20188_();
            this.neckAngle = lookup ? Math.max(-1.0f, this.neckAngle - 0.15f) : Math.min(1.0f, this.neckAngle + 0.15f);
        } else {
            this.neckAngle = this.neckAngle > 0.0f ? Math.max(0.0f, this.neckAngle - 0.15f) : Math.min(0.0f, this.neckAngle + 0.15f);
        }
        this.snoutRaiseAmount0 = this.snoutRaiseAmount;
        this.snoutRaiseAmount = this.isBeingTempted() ? Math.min(1.0f, this.snoutRaiseAmount + 0.25f) : Math.max(0.0f, this.snoutRaiseAmount - 0.25f);
    }

    public void m_8024_() {
        this.m_6858_(!this.m_20069_() && this.m_21566_().m_24995_() && this.running);
        super.m_8024_();
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.m_5776_()) {
            if (this.getTrackingTime() > 0) {
                if (this.hasFloraPos()) {
                    if (!this.isGrazing()) {
                        if (this.m_21523_()) {
                            this.setTrackingTime(this.getTrackingTime() - 3);
                        } else {
                            this.setTrackingTime(this.getTrackingTime() - 1);
                        }
                        if (this.getTrackingTime() == 0) {
                            this.stopTracking();
                        }
                    }
                } else if (!this.isSniffing()) {
                    this.setTrackingTime(this.getTrackingTime() - 1);
                    if (this.getTrackingTime() == 0) {
                        this.stopTracking();
                    }
                }
            }
            if (this.isSniffing()) {
                if (this.sniffTimer-- <= 0) {
                    this.m_5496_((SoundEvent)EnvironmentalSoundEvents.TAPIR_SNIFF.get(), 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                    this.sniffTimer = 10 + this.f_19796_.m_188503_(20);
                }
            } else {
                this.sniffTimer = 0;
            }
            if (this.f_19797_ % 20 == 0 && this.isGrazing() && this.hasFloraPos()) {
                this.m_5496_(SoundEvents.f_11912_, 0.5f + 0.5f * (float)this.f_19796_.m_188503_(2), (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                this.f_19853_.m_7605_((Entity)this, (byte)7);
            }
        } else if (this.f_19797_ % 10 == 0 && this.getTrackingTime() > 0 && this.hasFloraItem()) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.f_19853_.m_7106_((ParticleOptions)EnvironmentalParticleTypes.TAPIR_FINDS_FLORA.get(), this.m_20208_(0.5), this.m_20187_() + 0.5, this.m_20262_(0.5), d0, d1, d2);
        }
    }

    public void m_7822_(byte id) {
        if (id == 4) {
            for (int i = 0; i < 7; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                this.f_19853_.m_7106_((ParticleOptions)EnvironmentalParticleTypes.TAPIR_FINDS_FLORA.get(), this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
            }
        } else if (id == 5) {
            for (int i = 0; i < 7; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
            }
        } else if (id == 6) {
            this.headShakeAnim = 20;
            this.headShakeAnim0 = 20;
        } else if (id == 7) {
            if (this.getFloraPos() != null) {
                for (int i = 0; i < 8; ++i) {
                    Vec3 vector3d = new Vec3(((double)this.f_19796_.m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, ((double)this.f_19796_.m_188501_() - 0.5) * 0.1);
                    vector3d = vector3d.m_82496_(-this.m_146909_() * ((float)Math.PI / 180));
                    vector3d = vector3d.m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
                    double d0 = (double)(-this.f_19796_.m_188501_()) * 0.2;
                    Vec3 vector3d1 = new Vec3(((double)this.f_19796_.m_188501_() - 0.5) * 0.2, d0, 0.9 - 0.05 * (double)this.neckAngle + ((double)this.f_19796_.m_188501_() - 0.5) * 0.1);
                    vector3d1 = vector3d1.m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
                    vector3d1 = vector3d1.m_82520_(this.m_20185_(), this.m_20188_() - 0.15 - 0.35 * (double)this.neckAngle, this.m_20189_());
                    this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, this.f_19853_.m_8055_(this.getFloraPos())), vector3d1.f_82479_, vector3d1.f_82480_, vector3d1.f_82481_, vector3d.f_82479_, vector3d.f_82480_ + 0.05, vector3d.f_82481_);
                }
            }
        } else {
            super.m_7822_(id);
        }
    }

    public boolean m_5957_() {
        return false;
    }

    protected float m_6108_() {
        return 0.98f;
    }

    protected SoundEvent m_7515_() {
        return this.isSniffing() ? null : (SoundEvent)EnvironmentalSoundEvents.TAPIR_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)EnvironmentalSoundEvents.TAPIR_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)EnvironmentalSoundEvents.TAPIR_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        AABB aabb = this.m_20191_();
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)(aabb.f_82288_ + 0.001)), (int)Mth.m_14107_((double)(aabb.f_82289_ + 0.001)), (int)Mth.m_14107_((double)(aabb.f_82290_ + 0.001)), (int)Mth.m_14107_((double)(aabb.f_82291_ - 0.001)), (int)Mth.m_14107_((double)(aabb.f_82292_ - 0.001)), (int)Mth.m_14107_((double)(aabb.f_82293_ - 0.001)))) {
            if (!(this.f_19853_.m_8055_(blockpos).m_60734_() instanceof LeavesBlock)) continue;
            this.m_5496_((SoundEvent)EnvironmentalSoundEvents.TAPIR_LEAF_STEP.get(), 0.6f, 1.0f);
            break;
        }
        this.m_5496_((SoundEvent)EnvironmentalSoundEvents.TAPIR_STEP.get(), 0.15f, 1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.3);
    }

    public Tapir getBreedOffspring(ServerLevel level, AgeableMob mob) {
        Tapir child = (Tapir)((EntityType)EnvironmentalEntityTypes.TAPIR.get()).m_20615_((Level)level);
        child.setHasBabyPattern(true);
        return child;
    }

    protected void m_30232_() {
        super.m_30232_();
        if (!this.m_6162_() && this.f_19796_.m_188501_() < 0.9f) {
            this.setHasBabyPattern(false);
        }
    }

    public boolean m_6898_(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            BlockState state = blockItem.m_40614_().m_49966_();
            Material material = state.m_60767_();
            return material == Material.f_76300_ || material == Material.f_76301_ || material == Material.f_76302_ || material == Material.f_76303_ || material == Material.f_76304_ || material == Material.f_76270_ || material == Material.f_76271_ || material == Material.f_76274_ || material == Material.f_76277_ || material == Material.f_164530_ || material == Material.f_76285_;
        }
        return false;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        SpawnGroupData data = super.m_6518_(level, difficulty, spawnType, groupData, tag);
        if (this.m_6162_()) {
            this.setHasBabyPattern(true);
        }
        return data;
    }

    protected PathNavigation m_6037_(Level level) {
        return new TapirNavigator((Mob)this, level);
    }

    public static class TapirNavigator
    extends GroundPathNavigation {
        public TapirNavigator(Mob mob, Level level) {
            super(mob, level);
        }

        protected PathFinder m_5532_(int p_33382_) {
            this.f_26508_ = new TapirNodeEvaluator();
            this.f_26508_.m_77351_(true);
            return new PathFinder(this.f_26508_, p_33382_);
        }
    }

    public static class TapirNodeEvaluator
    extends WalkNodeEvaluator {
        protected BlockPathTypes m_6603_(BlockGetter level, boolean p_33388_, boolean p_33389_, BlockPos p_33390_, BlockPathTypes p_33391_) {
            return p_33391_ == BlockPathTypes.LEAVES ? BlockPathTypes.WALKABLE : super.m_6603_(level, p_33388_, p_33389_, p_33390_, p_33391_);
        }
    }
}

