/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.ai.goal.pineconegolem;

import com.google.common.collect.Lists;
import com.teamabnormals.environmental.common.entity.animal.PineconeGolem;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;

public class PineconeGolemPlantSaplingGoal
extends Goal {
    private final PineconeGolem golem;
    private final double moveSpeed;
    private int nextStartTicks;
    private int tryTicks;
    private int maxStayTicks;
    private boolean canPlant;
    private BlockPos targetPos = BlockPos.f_121853_;
    private ItemStack heldItem;
    private BlockState saplingState;

    public PineconeGolemPlantSaplingGoal(PineconeGolem golem, double speed) {
        this.golem = golem;
        this.moveSpeed = speed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        Item item;
        if (this.nextStartTicks > 0) {
            --this.nextStartTicks;
            return false;
        }
        this.nextStartTicks = this.m_183277_(20);
        if (!ForgeEventFactory.getMobGriefingEvent((Level)this.golem.f_19853_, (Entity)this.golem)) {
            return false;
        }
        ItemStack itemstack = this.golem.m_21205_();
        if (itemstack.m_204117_(ItemTags.f_13180_) && (item = itemstack.m_41720_()) instanceof BlockItem) {
            BlockItem blockitem = (BlockItem)item;
            BlockState blockstate = blockitem.m_40614_().m_49966_();
            BlockPos.MutableBlockPos mutablepos = new BlockPos.MutableBlockPos();
            int y = 0;
            while (y >= -1) {
                ArrayList list = Lists.newArrayList();
                for (int x = -3; x <= 3; ++x) {
                    for (int z = -3; z <= 3; ++z) {
                        list.add(new BlockPos((Vec3i)mutablepos.m_122154_((Vec3i)this.golem.m_20183_(), x, y, z)));
                    }
                }
                while (!list.isEmpty()) {
                    BlockPos blockpos = (BlockPos)list.remove(this.golem.m_217043_().m_188503_(list.size()));
                    if (!this.isValidTarget(blockpos, blockstate) || !this.golem.m_21444_(blockpos) || !this.hasSpaceForTree(blockpos) || !this.moveMobToBlock(blockpos)) continue;
                    this.targetPos = blockpos;
                    this.heldItem = itemstack;
                    this.saplingState = blockstate;
                    return true;
                }
                y = y < 0 ? -y : -y - 1;
            }
        }
        return false;
    }

    public boolean m_8045_() {
        if (this.tryTicks < -this.maxStayTicks || this.tryTicks > 1200) {
            return false;
        }
        if (this.golem.m_21205_() != this.heldItem) {
            return false;
        }
        return this.canPlant && this.isValidTarget(this.targetPos, this.saplingState);
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8056_() {
        this.tryTicks = 0;
        this.maxStayTicks = this.golem.m_217043_().m_188503_(this.golem.m_217043_().m_188503_(1200) + 1200) + 1200;
        this.canPlant = true;
    }

    public void m_8041_() {
        this.heldItem = null;
        this.saplingState = null;
        this.golem.m_21573_().m_26573_();
    }

    public void m_8037_() {
        if (!this.targetPos.m_203195_((Position)this.golem.m_20182_(), 1.25)) {
            ++this.tryTicks;
            if (this.tryTicks % 40 == 0 && !this.moveMobToBlock(this.targetPos)) {
                this.canPlant = false;
            }
        } else {
            if (this.hasSpaceForTree(this.targetPos) && !ForgeEventFactory.onBlockPlace((Entity)this.golem, (BlockSnapshot)BlockSnapshot.create((ResourceKey)this.golem.f_19853_.m_46472_(), (LevelAccessor)this.golem.f_19853_, (BlockPos)this.targetPos.m_7495_()), (Direction)Direction.UP)) {
                this.golem.f_19853_.m_46597_(this.targetPos, this.saplingState);
                SoundType soundtype = this.saplingState.getSoundType((LevelReader)this.golem.f_19853_, this.targetPos, (Entity)this.golem);
                this.golem.f_19853_.m_5594_(null, this.targetPos, this.saplingState.getSoundType((LevelReader)this.golem.f_19853_, this.targetPos, (Entity)this.golem).m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
                this.golem.f_19853_.m_220407_(GameEvent.f_157797_, this.targetPos, GameEvent.Context.m_223719_((Entity)this.golem, (BlockState)this.saplingState));
                this.golem.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            }
            this.canPlant = false;
        }
    }

    private boolean isValidTarget(BlockPos pos, BlockState state) {
        return this.golem.f_19853_.m_46859_(pos) && state.m_60734_().m_7898_(state, (LevelReader)this.golem.f_19853_, pos);
    }

    private boolean hasSpaceForTree(BlockPos pos) {
        BlockPos.MutableBlockPos mutablepos = new BlockPos.MutableBlockPos();
        for (int y = -2; y <= 6; ++y) {
            for (int x = -3; x <= 3; ++x) {
                for (int z = -3; z <= 3; ++z) {
                    mutablepos.m_122154_((Vec3i)pos, x, y, z);
                    if ((y <= 0 || TreeFeature.m_67272_((LevelSimulatedReader)this.golem.f_19853_, (BlockPos)mutablepos)) && !this.golem.f_19853_.m_8055_((BlockPos)mutablepos).m_204336_(BlockTags.f_13104_)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean moveMobToBlock(BlockPos pos) {
        Path path = this.golem.m_21573_().m_26524_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 0);
        if (path != null && path.m_77403_()) {
            this.golem.m_21573_().m_26536_(path, this.moveSpeed);
            return true;
        }
        return false;
    }
}

