/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.block;

import com.google.common.collect.Maps;
import com.teamabnormals.environmental.common.block.DwarfSpruceBlock;
import com.teamabnormals.environmental.common.block.DwarfSprucePlantBlock;
import com.teamabnormals.environmental.common.block.RedstoneDwarfSpruceBlock;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.registries.ForgeRegistries;

public class DwarfSpruceHeadBlock
extends BushBlock
implements DwarfSpruceBlock,
BonemealableBlock {
    private static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
    public static final BooleanProperty TOP = BooleanProperty.m_61465_((String)"top");
    public static final BooleanProperty STAR = BooleanProperty.m_61465_((String)"star");
    private static final Map<Supplier<? extends Item>, Block> TORCH_SPRUCES = Maps.newHashMap();
    protected DwarfSprucePlantBlock bodyBlock;
    private final Supplier<Item> torch;

    public DwarfSpruceHeadBlock(BlockBehaviour.Properties properties) {
        this(properties, (Supplier<Item>)null);
    }

    public DwarfSpruceHeadBlock(BlockBehaviour.Properties properties, ResourceLocation torch) {
        this(properties, () -> (Item)ForgeRegistries.ITEMS.getValue(torch));
    }

    public DwarfSpruceHeadBlock(BlockBehaviour.Properties properties, Supplier<Item> torch) {
        super(properties);
        this.torch = torch;
        if (torch != null) {
            TORCH_SPRUCES.put(torch, (Block)this);
        }
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)TOP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)STAR, (Comparable)Boolean.valueOf(false)));
    }

    public void setBodyBlock(DwarfSprucePlantBlock block) {
        this.bodyBlock = block;
    }

    @Override
    public Item getTorch() {
        return this.torch == null || this.torch.get() == Items.f_41852_ ? null : this.torch.get();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        int light = state.m_60791_();
        return (Boolean)state.m_61143_((Property)STAR) != false && light < 10 ? 10 : light;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos belowpos = pos.m_7495_();
        BlockState belowstate = level.m_8055_(belowpos);
        return belowstate.m_60734_() instanceof DwarfSpruceBlock || DwarfSpruceHeadBlock.m_49863_((LevelReader)level, (BlockPos)belowpos, (Direction)Direction.UP) || belowstate.m_60734_() instanceof LeavesBlock;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState belowstate = level.m_8055_(pos.m_7495_());
        boolean flag = belowstate.m_60734_() instanceof DwarfSpruceHeadBlock;
        if (DwarfSprucePlantBlock.isValidAboveBlock(level.m_8055_(pos.m_7494_()))) {
            return (BlockState)((Block)EnvironmentalBlocks.DWARF_SPRUCE_PLANT.get()).m_49966_().m_61124_((Property)DwarfSprucePlantBlock.BOTTOM, (Comparable)Boolean.valueOf(!flag));
        }
        if (flag) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)TOP, (Comparable)Boolean.valueOf(true))).m_61124_((Property)STAR, (Comparable)((Boolean)belowstate.m_61143_((Property)STAR)));
        }
        return this.m_49966_();
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            level.m_46961_(pos, true);
        }
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState offsetState, LevelAccessor level, BlockPos pos, BlockPos offsetPos) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            level.m_186460_(pos, (Block)this, 1);
        }
        return direction == Direction.UP && DwarfSprucePlantBlock.isValidAboveBlock(offsetState) ? this.getBodyState(state) : state;
    }

    protected BlockState getBodyState(BlockState originalState) {
        return (BlockState)this.bodyBlock.m_49966_().m_61124_((Property)DwarfSprucePlantBlock.BOTTOM, (Comparable)Boolean.valueOf((Boolean)originalState.m_61143_((Property)TOP) == false));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        Block torchspruce;
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        Item torch = this.getTorch();
        if (itemstack.canPerformAction(ToolActions.SHEARS_HARVEST)) {
            boolean flag = false;
            if (((Boolean)state.m_61143_((Property)STAR)).booleanValue()) {
                DwarfSpruceHeadBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.f_42686_));
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)STAR, (Comparable)Boolean.valueOf(false)));
                flag = true;
            } else if (torch != null) {
                DwarfSpruceHeadBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)torch));
                level.m_46597_(pos, this.getWithoutTorchesState(state));
                flag = true;
            }
            if (flag) {
                itemstack.m_41622_(1, (LivingEntity)player, player1 -> player1.m_21190_(hand));
                level.m_5594_(null, pos, SoundEvents.f_12480_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
                level.m_142346_((Entity)player, GameEvent.f_157781_, pos);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        if (item != Items.f_41852_ && torch == null && (torchspruce = (Block)TORCH_SPRUCES.getOrDefault(TORCH_SPRUCES.keySet().stream().filter(key -> item == key.get()).findFirst().orElse(null), null)) != null) {
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            BlockState blockstate = (BlockState)((BlockState)torchspruce.m_49966_().m_61124_((Property)TOP, (Comparable)((Boolean)state.m_61143_((Property)TOP)))).m_61124_((Property)STAR, (Comparable)((Boolean)state.m_61143_((Property)STAR)));
            if (item == Items.f_41978_) {
                blockstate = RedstoneDwarfSpruceBlock.setLitPoweredState(blockstate, level, pos);
            }
            level.m_46597_(pos, blockstate);
            level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (!((Boolean)state.m_61143_((Property)STAR)).booleanValue() && item == Items.f_42686_) {
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)STAR, (Comparable)Boolean.valueOf(true)));
            level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, result);
    }

    @Override
    public BlockState getWithoutTorchesState(BlockState state) {
        return (BlockState)((BlockState)((Block)EnvironmentalBlocks.DWARF_SPRUCE.get()).m_49966_().m_61124_((Property)TOP, (Comparable)((Boolean)state.m_61143_((Property)TOP)))).m_61124_((Property)STAR, (Comparable)((Boolean)state.m_61143_((Property)STAR)));
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        List drops = super.m_7381_(state, builder);
        Item torch = this.getTorch();
        if (torch != null) {
            drops.add(new ItemStack((ItemLike)torch));
        }
        return drops;
    }

    public boolean m_7370_(BlockGetter level, BlockPos pos, BlockState state, boolean isClient) {
        return level.m_8055_(pos.m_7494_()).m_60795_();
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        level.m_46597_(pos.m_7494_(), (BlockState)((BlockState)((Block)EnvironmentalBlocks.DWARF_SPRUCE.get()).m_49966_().m_61124_((Property)TOP, (Comparable)Boolean.valueOf(true))).m_61124_((Property)STAR, (Comparable)((Boolean)state.m_61143_((Property)STAR))));
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)EnvironmentalBlocks.DWARF_SPRUCE.get());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TOP, STAR});
    }
}

