/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.client.model;

import com.google.common.collect.ImmutableList;
import com.teamabnormals.environmental.common.entity.animal.Zebra;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class ZebraModel<T extends Zebra>
extends AgeableListModel<T> {
    protected final ModelPart body;
    protected final ModelPart headParts;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightHindBabyLeg;
    private final ModelPart leftHindBabyLeg;
    private final ModelPart rightFrontBabyLeg;
    private final ModelPart leftFrontBabyLeg;
    private final ModelPart tail;
    private final ModelPart[] saddleParts;
    private final ModelPart[] ridingParts;

    public ZebraModel(ModelPart part) {
        super(true, 16.2f, 1.36f, 2.7272f, 2.0f, 20.0f);
        this.body = part.m_171324_("body");
        this.headParts = part.m_171324_("head_parts");
        this.rightHindLeg = part.m_171324_("right_hind_leg");
        this.leftHindLeg = part.m_171324_("left_hind_leg");
        this.rightFrontLeg = part.m_171324_("right_front_leg");
        this.leftFrontLeg = part.m_171324_("left_front_leg");
        this.rightHindBabyLeg = part.m_171324_("right_hind_baby_leg");
        this.leftHindBabyLeg = part.m_171324_("left_hind_baby_leg");
        this.rightFrontBabyLeg = part.m_171324_("right_front_baby_leg");
        this.leftFrontBabyLeg = part.m_171324_("left_front_baby_leg");
        this.tail = this.body.m_171324_("tail");
        ModelPart modelpart = this.body.m_171324_("saddle");
        ModelPart modelpart1 = this.headParts.m_171324_("left_saddle_mouth");
        ModelPart modelpart2 = this.headParts.m_171324_("right_saddle_mouth");
        ModelPart modelpart3 = this.headParts.m_171324_("left_saddle_line");
        ModelPart modelpart4 = this.headParts.m_171324_("right_saddle_line");
        ModelPart modelpart5 = this.headParts.m_171324_("head_saddle");
        ModelPart modelpart6 = this.headParts.m_171324_("mouth_saddle_wrap");
        this.saddleParts = new ModelPart[]{modelpart, modelpart1, modelpart2, modelpart5, modelpart6};
        this.ridingParts = new ModelPart[]{modelpart3, modelpart4};
    }

    public static MeshDefinition createBodyMesh(CubeDeformation deformation) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 35).m_171488_(-4.5f, -6.0f, -17.0f, 9.0f, 9.0f, 20.0f, new CubeDeformation(0.05f)), PartPose.m_171419_((float)0.0f, (float)10.0f, (float)5.5f));
        PartDefinition headParts = partdefinition.m_171599_("head_parts", CubeListBuilder.m_171558_().m_171514_(0, 38).m_171481_(-2.05f, -6.0f, -3.0f, 4.0f, 11.0f, 6.0f), PartPose.m_171423_((float)0.0f, (float)6.0f, (float)-12.0f, (float)0.5235988f, (float)0.0f, (float)0.0f));
        PartDefinition head = headParts.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-3.0f, -11.0f, -4.0f, 6.0f, 5.0f, 7.0f, deformation), PartPose.f_171404_);
        headParts.m_171599_("mane", CubeListBuilder.m_171558_().m_171514_(50, 36).m_171488_(-1.0f, -11.0f, 3.01f, 2.0f, 15.0f, 3.0f, deformation), PartPose.f_171404_);
        headParts.m_171599_("upper_mouth", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171488_(-2.0f, -11.0f, -9.0f, 4.0f, 5.0f, 5.0f, deformation), PartPose.f_171404_);
        partdefinition.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171514_(48, 23).m_171480_().m_171488_(-2.5f, -0.01f, -1.5f, 3.0f, 10.0f, 3.0f, deformation), PartPose.m_171419_((float)4.0f, (float)14.0f, (float)7.0f));
        partdefinition.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171514_(48, 23).m_171488_(-0.5f, -0.01f, -1.5f, 3.0f, 10.0f, 3.0f, deformation), PartPose.m_171419_((float)-4.0f, (float)14.0f, (float)7.0f));
        partdefinition.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(48, 23).m_171480_().m_171488_(-2.5f, -0.01f, -1.4f, 3.0f, 10.0f, 3.0f, deformation), PartPose.m_171419_((float)4.0f, (float)14.0f, (float)-10.0f));
        partdefinition.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(48, 23).m_171488_(-0.5f, -0.01f, -1.4f, 3.0f, 10.0f, 3.0f, deformation), PartPose.m_171419_((float)-4.0f, (float)14.0f, (float)-10.0f));
        CubeDeformation cubedeformation = deformation.m_171471_(0.0f, 5.0f, 0.0f);
        partdefinition.m_171599_("left_hind_baby_leg", CubeListBuilder.m_171558_().m_171514_(48, 23).m_171480_().m_171488_(-2.5f, -0.01f, -2.0f, 3.0f, 10.0f, 3.0f, cubedeformation), PartPose.m_171419_((float)4.0f, (float)14.0f, (float)7.0f));
        partdefinition.m_171599_("right_hind_baby_leg", CubeListBuilder.m_171558_().m_171514_(48, 23).m_171488_(-0.5f, -0.01f, -2.0f, 3.0f, 10.0f, 3.0f, cubedeformation), PartPose.m_171419_((float)-4.0f, (float)14.0f, (float)7.0f));
        partdefinition.m_171599_("left_front_baby_leg", CubeListBuilder.m_171558_().m_171514_(48, 23).m_171480_().m_171488_(-2.5f, -0.01f, 0.1f, 3.0f, 10.0f, 3.0f, cubedeformation), PartPose.m_171419_((float)4.0f, (float)14.0f, (float)-12.0f));
        partdefinition.m_171599_("right_front_baby_leg", CubeListBuilder.m_171558_().m_171514_(48, 23).m_171488_(-0.5f, -0.01f, 0.1f, 3.0f, 10.0f, 3.0f, cubedeformation), PartPose.m_171419_((float)-4.0f, (float)14.0f, (float)-12.0f));
        body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(38, 38).m_171488_(-1.5f, -1.0f, 0.5f, 3.0f, 14.0f, 3.0f, deformation), PartPose.m_171423_((float)0.0f, (float)-2.5f, (float)3.0f, (float)0.5235988f, (float)0.0f, (float)0.0f));
        body.m_171599_("saddle", CubeListBuilder.m_171558_().m_171514_(26, 0).m_171488_(-4.5f, -6.0f, -9.5f, 9.0f, 9.0f, 9.0f, new CubeDeformation(0.5f)), PartPose.f_171404_);
        headParts.m_171599_("left_saddle_mouth", CubeListBuilder.m_171558_().m_171514_(29, 5).m_171488_(2.0f, -10.0f, -7.0f, 1.0f, 2.0f, 2.0f, deformation), PartPose.f_171404_);
        headParts.m_171599_("right_saddle_mouth", CubeListBuilder.m_171558_().m_171514_(29, 5).m_171488_(-3.0f, -10.0f, -7.0f, 1.0f, 2.0f, 2.0f, deformation), PartPose.f_171404_);
        headParts.m_171599_("left_saddle_line", CubeListBuilder.m_171558_().m_171514_(32, 2).m_171488_(3.1f, -6.5f, -9.5f, 0.0f, 3.0f, 16.0f, deformation), PartPose.m_171430_((float)-0.5235988f, (float)0.0f, (float)0.0f));
        headParts.m_171599_("right_saddle_line", CubeListBuilder.m_171558_().m_171514_(32, 2).m_171488_(-3.1f, -6.5f, -9.5f, 0.0f, 3.0f, 16.0f, deformation), PartPose.m_171430_((float)-0.5235988f, (float)0.0f, (float)0.0f));
        headParts.m_171599_("head_saddle", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, -11.0f, -3.9f, 6.0f, 5.0f, 7.0f, new CubeDeformation(0.2f)), PartPose.f_171404_);
        headParts.m_171599_("mouth_saddle_wrap", CubeListBuilder.m_171558_().m_171514_(19, 0).m_171488_(-2.0f, -11.0f, -6.0f, 4.0f, 5.0f, 2.0f, new CubeDeformation(0.2f)), PartPose.f_171404_);
        head.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(19, 19).m_171488_(0.55f, -14.0f, 2.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(-0.001f)), PartPose.f_171404_);
        head.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(19, 19).m_171488_(-2.55f, -14.0f, 2.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(-0.001f)), PartPose.f_171404_);
        return meshdefinition;
    }

    public void setupAnim(T zebra, float p_102786_, float p_102787_, float p_102788_, float p_102789_, float p_102790_) {
        boolean isSaddled = zebra.m_6254_();
        boolean isVehicle = zebra.m_20160_();
        for (ModelPart modelpart : this.saddleParts) {
            modelpart.f_104207_ = isSaddled;
        }
        for (ModelPart modelpart1 : this.ridingParts) {
            modelpart1.f_104207_ = isVehicle && isSaddled;
        }
    }

    public Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.headParts);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body, (Object)this.rightHindLeg, (Object)this.leftHindLeg, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg, (Object)this.rightHindBabyLeg, (Object)this.leftHindBabyLeg, (Object)this.rightFrontBabyLeg, (Object)this.leftFrontBabyLeg);
    }

    public void prepareMobModel(T zebra, float limbSwing, float limbSwingAmount, float partialTick) {
        super.m_6839_(zebra, limbSwing, limbSwingAmount, partialTick);
        float bodyrot = Mth.m_14201_((float)((Zebra)((Object)zebra)).f_20884_, (float)((Zebra)((Object)zebra)).f_20883_, (float)partialTick);
        float headrot = Mth.m_14201_((float)((Zebra)((Object)zebra)).f_20886_, (float)((Zebra)((Object)zebra)).f_20885_, (float)partialTick);
        float headyangle = headrot - bodyrot;
        float headswing = Mth.m_14179_((float)partialTick, (float)((Zebra)((Object)zebra)).f_19860_, (float)zebra.m_146909_()) * ((float)Math.PI / 180);
        if (headyangle > 20.0f) {
            headyangle = 20.0f;
        }
        if (headyangle < -20.0f) {
            headyangle = -20.0f;
        }
        if (limbSwingAmount > 0.2f) {
            headswing += Mth.m_14089_((float)(limbSwing * 0.4f)) * 0.15f * limbSwingAmount;
        }
        float eatanim = zebra.m_30663_(partialTick);
        float standanim = zebra.m_30667_(partialTick);
        float nostandanim = 1.0f - standanim;
        float mouthanim = zebra.m_30533_(partialTick);
        boolean movingtail = ((Zebra)((Object)zebra)).f_30517_ != 0;
        float ageinticks = (float)((Zebra)((Object)zebra)).f_19797_ + partialTick;
        this.headParts.f_104201_ = 6.0f;
        this.headParts.f_104202_ = -10.5f;
        this.body.f_104203_ = 0.0f;
        this.headParts.f_104203_ = 0.5235988f + headswing;
        this.headParts.f_104204_ = headyangle * ((float)Math.PI / 180);
        float legswingspeed = zebra.m_20069_() ? 0.2f : 1.0f;
        float hindlegswing = Mth.m_14089_((float)(legswingspeed * limbSwing * 0.6662f + (float)Math.PI));
        float frontlegswing = hindlegswing * 0.8f * limbSwingAmount;
        float headxangle = (1.0f - Math.max(standanim, eatanim)) * (0.5235988f + headswing + mouthanim * Mth.m_14031_((float)ageinticks) * 0.05f);
        this.headParts.f_104203_ = standanim * (0.2617994f + headswing) + eatanim * (2.1816616f + Mth.m_14031_((float)ageinticks) * 0.05f) + headxangle;
        this.headParts.f_104204_ = standanim * headyangle * ((float)Math.PI / 180) + (1.0f - Math.max(standanim, eatanim)) * this.headParts.f_104204_;
        this.headParts.f_104201_ = standanim * -4.0f + eatanim * 11.0f + (1.0f - Math.max(standanim, eatanim)) * this.headParts.f_104201_;
        this.headParts.f_104202_ = standanim * -4.0f + eatanim * -12.0f + (1.0f - Math.max(standanim, eatanim)) * this.headParts.f_104202_;
        this.body.f_104203_ = standanim * -0.7853982f + nostandanim * this.body.f_104203_;
        float standlegangle = 0.2617994f * standanim;
        float standswing = Mth.m_14089_((float)(ageinticks * 0.6f + (float)Math.PI));
        this.leftFrontLeg.f_104201_ = 2.0f * standanim + 14.0f * nostandanim;
        this.leftFrontLeg.f_104202_ = -6.0f * standanim - 10.0f * nostandanim;
        float leftfrontlegangle = (-1.0471976f + standswing) * standanim + frontlegswing * nostandanim;
        float rightfrontlegangle = (-1.0471976f - standswing) * standanim - frontlegswing * nostandanim;
        this.leftHindLeg.f_104203_ = standlegangle - hindlegswing * 0.5f * limbSwingAmount * nostandanim;
        this.rightHindLeg.f_104203_ = standlegangle + hindlegswing * 0.5f * limbSwingAmount * nostandanim;
        this.leftFrontLeg.f_104203_ = leftfrontlegangle;
        this.rightFrontLeg.f_104203_ = rightfrontlegangle;
        this.tail.f_104203_ = 0.5235988f + limbSwingAmount * 0.75f;
        this.tail.f_104201_ = -2.5f + limbSwingAmount;
        this.tail.f_104202_ = 1.0f + limbSwingAmount * 2.0f;
        float backkickbodyrot = ((Zebra)((Object)zebra)).getBackKickBodyRot(partialTick);
        float backkicklegrot = ((Zebra)((Object)zebra)).getBackKickLegRot(partialTick);
        backkickbodyrot *= nostandanim;
        backkicklegrot *= nostandanim;
        float frontkickbodyrot = ((Zebra)((Object)zebra)).getFrontKickBodyRot(partialTick);
        float frontkicklegrot = ((Zebra)((Object)zebra)).getFrontKickLegRot(partialTick);
        frontkickbodyrot *= nostandanim;
        frontkicklegrot *= nostandanim;
        this.body.f_104201_ = 11.0f;
        this.body.f_104202_ = 5.5f;
        this.leftHindLeg.f_104201_ = 14.0f;
        this.leftHindLeg.f_104202_ = 7.0f;
        this.headParts.f_104201_ += backkickbodyrot;
        this.headParts.f_104202_ += -3.5f * backkickbodyrot;
        this.headParts.f_104203_ += 0.15f * backkickbodyrot;
        this.body.f_104201_ += -14.0f * Mth.m_14031_((float)(0.5235988f * backkickbodyrot));
        this.body.f_104202_ += 14.0f * Mth.m_14089_((float)(0.5235988f * backkickbodyrot)) - 14.0f - backkickbodyrot;
        this.body.f_104203_ += 0.5235988f * backkickbodyrot;
        this.leftHindLeg.f_104201_ += -9.5f * backkickbodyrot;
        this.leftHindLeg.f_104202_ += -backkickbodyrot;
        this.rightHindLeg.f_104201_ = this.leftHindLeg.f_104201_;
        this.rightHindLeg.f_104202_ = this.leftHindLeg.f_104202_;
        this.leftHindLeg.f_104203_ += 1.7278761f * backkicklegrot;
        this.rightHindLeg.f_104203_ += 1.7278761f * backkicklegrot;
        this.headParts.f_104201_ += -6.0f * frontkickbodyrot;
        this.headParts.f_104202_ += 4.0f * frontkickbodyrot;
        this.headParts.f_104203_ += -0.1f * frontkickbodyrot;
        this.body.f_104203_ += -0.5235988f * frontkickbodyrot;
        this.leftHindLeg.f_104203_ += 0.2f * frontkickbodyrot;
        this.rightHindLeg.f_104203_ += 0.2f * frontkickbodyrot;
        this.leftFrontLeg.f_104201_ += -9.0f * frontkickbodyrot;
        this.leftFrontLeg.f_104202_ += frontkickbodyrot;
        this.rightFrontLeg.f_104201_ = this.leftFrontLeg.f_104201_;
        this.rightFrontLeg.f_104202_ = this.leftFrontLeg.f_104202_;
        this.leftFrontLeg.f_104203_ += (-1.7278761f + standswing * 0.3f) * frontkicklegrot;
        this.rightFrontLeg.f_104203_ += (-1.7278761f - standswing * 0.3f) * frontkicklegrot;
        this.tail.f_104204_ = movingtail ? Mth.m_14089_((float)(ageinticks * 0.7f)) : 0.0f;
        this.rightHindBabyLeg.f_104201_ = this.rightHindLeg.f_104201_;
        this.rightHindBabyLeg.f_104202_ = this.rightHindLeg.f_104202_;
        this.rightHindBabyLeg.f_104203_ = this.rightHindLeg.f_104203_;
        this.leftHindBabyLeg.f_104201_ = this.leftHindLeg.f_104201_;
        this.leftHindBabyLeg.f_104202_ = this.leftHindLeg.f_104202_;
        this.leftHindBabyLeg.f_104203_ = this.leftHindLeg.f_104203_;
        this.rightFrontBabyLeg.f_104201_ = this.rightFrontLeg.f_104201_;
        this.rightFrontBabyLeg.f_104202_ = this.rightFrontLeg.f_104202_;
        this.rightFrontBabyLeg.f_104203_ = this.rightFrontLeg.f_104203_;
        this.leftFrontBabyLeg.f_104201_ = this.leftFrontLeg.f_104201_;
        this.leftFrontBabyLeg.f_104202_ = this.leftFrontLeg.f_104202_;
        this.leftFrontBabyLeg.f_104203_ = this.leftFrontLeg.f_104203_;
        boolean isbaby = zebra.m_6162_();
        this.rightHindLeg.f_104207_ = !isbaby;
        this.leftHindLeg.f_104207_ = !isbaby;
        this.rightFrontLeg.f_104207_ = !isbaby;
        this.leftFrontLeg.f_104207_ = !isbaby;
        this.rightHindBabyLeg.f_104207_ = isbaby;
        this.leftHindBabyLeg.f_104207_ = isbaby;
        this.rightFrontBabyLeg.f_104207_ = isbaby;
        this.leftFrontBabyLeg.f_104207_ = isbaby;
    }
}

