/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teamabnormals.environmental.common.entity.animal.koi.Koi;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class KoiModel<T extends Koi>
extends EntityModel<T> {
    private final ModelPart front;
    private final ModelPart back;
    private final ModelPart tail;

    public KoiModel(ModelPart root) {
        this.front = root.m_171324_("front");
        this.back = root.m_171324_("back");
        this.tail = root.m_171324_("back").m_171324_("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.m_171576_();
        PartDefinition front = root.m_171599_("front", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)19.0f, (float)1.0f));
        PartDefinition head = front.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(20, 3).m_171488_(-1.5f, -4.0f, -4.0f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)-5.0f));
        PartDefinition leftWhisker = head.m_171599_("leftWhisker", CubeListBuilder.m_171558_().m_171514_(20, 9).m_171488_(1.5f, -3.0f, -8.0f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)4.0f));
        PartDefinition rightWhisker = head.m_171599_("rightWhisker", CubeListBuilder.m_171558_().m_171514_(20, 9).m_171488_(-1.5f, -3.0f, -8.0f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)4.0f));
        PartDefinition bodyFront = front.m_171599_("bodyFront", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -4.0f, -6.0f, 4.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition frontFin = bodyFront.m_171599_("frontFin", CubeListBuilder.m_171558_().m_171514_(14, -1).m_171488_(0.0f, -10.0f, -3.0f, 0.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)-1.0f));
        PartDefinition frontLeftFin = bodyFront.m_171599_("frontLeftFin", CubeListBuilder.m_171558_().m_171514_(6, 14).m_171488_(2.0f, -3.0f, -5.0f, 0.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)-1.0f));
        PartDefinition frontRightFin = bodyFront.m_171599_("frontRightFin", CubeListBuilder.m_171558_().m_171514_(6, 14).m_171488_(-2.0f, -3.0f, -5.0f, 0.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)-1.0f));
        PartDefinition back = root.m_171599_("back", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)19.0f, (float)1.0f));
        PartDefinition bodyBack = back.m_171599_("bodyBack", CubeListBuilder.m_171558_().m_171514_(0, 10).m_171488_(-2.0f, -4.0f, 0.0f, 4.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition backFin = bodyBack.m_171599_("backFin", CubeListBuilder.m_171558_().m_171514_(15, 9).m_171488_(0.0f, -10.0f, 1.0f, 0.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)-1.0f));
        PartDefinition backRightFin = bodyBack.m_171599_("backRightFin", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-2.0f, -3.0f, 3.0f, 0.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)-1.0f));
        PartDefinition backLeftFin = bodyBack.m_171599_("backLeftFin", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(2.0f, -3.0f, 3.0f, 0.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)-1.0f));
        PartDefinition tail = back.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(22, 12).m_171488_(0.0f, -5.0f, 0.0f, 0.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)7.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void m_7695_(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        ImmutableList.of((Object)this.front, (Object)this.back).forEach(modelRenderer -> modelRenderer.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha));
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.m_20069_()) {
            this.front.f_104204_ = Mth.m_14031_((float)(0.6f * ageInTicks)) * 0.3f * limbSwingAmount;
            this.back.f_104204_ = Mth.m_14089_((float)(0.6f * ageInTicks)) * 0.7f * limbSwingAmount;
            this.tail.f_104204_ = Mth.m_14031_((float)(0.6f * ageInTicks)) * 0.75f * limbSwingAmount;
        } else {
            this.back.f_104204_ = Mth.m_14089_((float)(1.0200001f * ageInTicks)) * 0.325f;
        }
    }
}

