/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.client.model;

import com.google.common.collect.ImmutableList;
import com.teamabnormals.environmental.common.entity.animal.Duck;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DuckModel<T extends Duck>
extends AgeableListModel<T> {
    public ModelPart head;
    public ModelPart body;
    public ModelPart rightLeg;
    public ModelPart leftLeg;
    public ModelPart rightWing;
    public ModelPart leftWing;

    public DuckModel(ModelPart root) {
        this.head = root.m_171324_("head");
        this.body = root.m_171324_("body");
        this.rightLeg = root.m_171324_("right_leg");
        this.leftLeg = root.m_171324_("left_leg");
        this.rightWing = root.m_171324_("right_wing");
        this.leftWing = root.m_171324_("left_wing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.m_171576_();
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171506_(-2.0f, -6.0f, -2.0f, 4.0f, 8.0f, 3.0f, false).m_171514_(0, 11).m_171506_(-1.5f, -4.0f, -5.0f, 3.0f, 2.0f, 3.0f, false), PartPose.m_171423_((float)0.0f, (float)16.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(14, 0).m_171506_(-3.0f, -4.0f, 0.0f, 6.0f, 8.0f, 5.0f, false), PartPose.m_171423_((float)0.0f, (float)20.0f, (float)0.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg = root.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(36, 0).m_171506_(-1.5f, 0.0f, -3.0f, 3.0f, 4.0f, 3.0f, false), PartPose.m_171423_((float)-1.5f, (float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = root.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(48, 0).m_171506_(-1.5f, 0.0f, -3.0f, 3.0f, 4.0f, 3.0f, false), PartPose.m_171423_((float)1.5f, (float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightWing = root.m_171599_("right_wing", CubeListBuilder.m_171558_().m_171514_(14, 13).m_171506_(-0.5f, 0.0f, -3.0f, 1.0f, 5.0f, 6.0f, false), PartPose.m_171423_((float)-3.5f, (float)15.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftWing = root.m_171599_("left_wing", CubeListBuilder.m_171558_().m_171514_(30, 13).m_171506_(-0.5f, 0.0f, -3.0f, 1.0f, 5.0f, 6.0f, false), PartPose.m_171423_((float)3.5f, (float)15.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body, (Object)this.rightLeg, (Object)this.leftLeg, (Object)this.rightWing, (Object)this.leftWing);
    }

    public void prepareMobModel(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        float f;
        super.m_6839_(entityIn, limbSwing, limbSwingAmount, partialTick);
        this.rightWing.f_104205_ = f = ((Duck)((Object)entityIn)).getWingRotation(partialTick);
        this.leftWing.f_104205_ = -f;
        if (((Duck)((Object)entityIn)).isEating()) {
            this.head.f_104203_ = ((Duck)((Object)entityIn)).getHeadLean(partialTick) * 2.5f;
        }
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = ageInTicks - (float)((Duck)((Object)entityIn)).f_19797_;
        float f1 = ((Duck)((Object)entityIn)).getHeadLean(f);
        float f2 = 1.0f - f1;
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180) * f2;
        this.head.f_104203_ += f1 * 1.4f + Mth.m_14089_((float)ageInTicks) * 0.15f * f1;
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180) * f2;
        this.head.f_104201_ = 16.0f + f1;
        this.head.f_104202_ = -3.0f - f1;
        if (!entityIn.m_20069_()) {
            this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.rightLeg.f_104201_ = 20.0f;
            this.leftLeg.f_104201_ = 20.0f;
        } else {
            float f3 = !entityIn.m_6162_() ? 0.2f : 0.4f;
            this.rightLeg.f_104203_ = 0.5f + Mth.m_14089_((float)(ageInTicks * f3)) * 0.8f * (limbSwingAmount + 0.2f);
            this.leftLeg.f_104203_ = 0.5f + Mth.m_14089_((float)(ageInTicks * f3 + (float)Math.PI)) * 0.8f * (limbSwingAmount + 0.2f);
            this.rightLeg.f_104201_ = 18.0f;
            this.leftLeg.f_104201_ = 18.0f;
        }
    }
}

