/*
 * Decompiled with CFR 0.152.
 */
package traben.tconfig.gui.entries;

import com.demonwav.mcdev.annotations.Translatable;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import traben.entity_texture_features.ETFVersionDifferenceHandler;
import traben.tconfig.gui.entries.TConfigEntry;

public class TConfigEntryText
extends TConfigEntry {
    protected final AbstractWidget widget;

    public TConfigEntryText(@Translatable String text, TextAlignment alignment) {
        super(text, null);
        this.widget = new ETFTextWidget(this.getText(), alignment);
    }

    public TConfigEntryText(@Translatable String text) {
        this(text, TextAlignment.CENTER);
    }

    public static Collection<TConfigEntry> fromLongOrMultilineTranslation(@Translatable String translationKey, int width) {
        return TConfigEntryText.fromLongOrMultilineTranslation(translationKey, width, TextAlignment.CENTER);
    }

    public static List<TConfigEntry> fromLongOrMultilineTranslation(@Translatable String translationKey, int width, TextAlignment alignment) {
        Component translated = ETFVersionDifferenceHandler.getTextFromTranslation(translationKey);
        List lines = Minecraft.m_91087_().f_91062_.m_92865_().m_92414_((FormattedText)translated, width, Style.f_131099_);
        ArrayList<TConfigEntry> list = new ArrayList<TConfigEntry>();
        String lastLine = null;
        for (FormattedText line : lines) {
            if (lastLine != null) {
                list.add(new TwoLines(lastLine, line.getString(), alignment));
                lastLine = null;
                continue;
            }
            lastLine = line.getString();
        }
        if (lastLine != null) {
            list.add(new TwoLines(lastLine, "", alignment));
        }
        return list;
    }

    @Override
    public AbstractWidget getWidget(int x, int y, int width, int height) {
        this.widget.f_93620_ = x;
        this.widget.f_93621_ = y;
        this.widget.f_93619_ = height;
        this.widget.m_93674_(width);
        return this.widget;
    }

    @Override
    boolean hasChangedFromInitial() {
        return false;
    }

    @Override
    boolean saveValuesToConfig() {
        return false;
    }

    @Override
    void setValuesToDefault() {
    }

    @Override
    void resetValuesToInitial() {
    }

    private class ETFTextWidget
    extends AbstractWidget {
        private final TextAlignment alignment;
        private int color;

        public void setColor(int color) {
            this.color = color;
        }

        public ETFTextWidget(Component text, TextAlignment alignment) {
            super(0, 0, 0, 0, text);
            this.color = 0xFFFFFF;
            this.alignment = alignment;
        }

        public void m_142291_(NarrationElementOutput builder) {
        }

        public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
            switch (this.alignment) {
                case LEFT: {
                    Minecraft.m_91087_().f_91062_.m_92889_(matrices, this.m_6035_(), (float)this.f_93620_, (float)this.f_93621_, this.color);
                    break;
                }
                case CENTER: {
                    Minecraft.m_91087_().f_91062_.m_92763_(matrices, this.m_6035_(), (float)this.f_93620_ + (float)(this.f_93618_ - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)TConfigEntryText.this.getText())) / 2.0f, (float)this.f_93621_, this.color);
                    break;
                }
                case RIGHT: {
                    Minecraft.m_91087_().f_91062_.m_92763_(matrices, this.m_6035_(), (float)(this.f_93620_ + this.f_93618_ - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)TConfigEntryText.this.getText())), (float)this.f_93621_, this.color);
                }
            }
        }
    }

    public static enum TextAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }

    public static class TwoLines
    extends TConfigEntryText {
        protected final ETFTextWidget widget2;

        public TwoLines(@Translatable String text1, @Translatable String text2) {
            this(text1, text2, TextAlignment.CENTER);
        }

        public TwoLines(@Translatable String text1, @Translatable String text2, TextAlignment alignment) {
            super(text1, alignment);
            this.widget2 = new ETFTextWidget(ETFVersionDifferenceHandler.getTextFromTranslation(text2), alignment);
            if (!this.widget2.m_6035_().getString().contains("\u00a7")) {
                this.widget2.setColor(0xCCCCCC);
            }
        }

        @Override
        public AbstractWidget getWidget(int x, int y, int width, int height) {
            this.widget.f_93620_ = x;
            this.widget.f_93621_ = y;
            this.widget.f_93619_ = height / 2;
            this.widget.m_93674_(width);
            this.widget2.f_93620_ = x;
            this.widget2.f_93621_ = y + height / 2 + 2;
            this.widget2.f_93619_ = height / 2;
            this.widget2.m_93674_(width);
            return this.widget;
        }

        @Override
        public void m_6311_(PoseStack context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.lastWidgetRendered = this.getWidget(x, y, entryWidth, entryHeight);
            this.widget.m_6305_(context, mouseX, mouseY, tickDelta);
            this.widget2.m_6305_(context, mouseX, mouseY, tickDelta);
        }
    }
}

