/*
 * Decompiled with CFR 0.152.
 */
package traben.tconfig.gui.entries;

import com.demonwav.mcdev.annotations.Translatable;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import traben.tconfig.gui.TConfigScreenList;
import traben.tconfig.gui.entries.TConfigEntry;

public class TConfigEntryCategory
extends TConfigEntry {
    private final Object2ObjectLinkedOpenHashMap<String, TConfigEntry> options = new Object2ObjectLinkedOpenHashMap();
    private final String translationKey;
    private TConfigScreenList screen = null;
    private Component emptyTooltip = Component.m_237115_((String)"config.entity_features.empty");
    private TConfigScreenList.Align align = TConfigScreenList.Align.CENTER;
    private TConfigScreenList.Renderable renderFeature = null;

    public TConfigEntryCategory(@Translatable String text, @Translatable String tooltip) {
        super(text, tooltip);
        this.translationKey = text;
    }

    public TConfigEntryCategory(@Translatable String text) {
        super(text, null);
        this.translationKey = text;
    }

    public void setAlign(TConfigScreenList.Align align) {
        this.align = align;
    }

    public Object2ObjectLinkedOpenHashMap<String, TConfigEntry> getOptions() {
        return this.options;
    }

    public TConfigScreenList getScreen() {
        if (this.screen == null) {
            this.screen = new TConfigScreenList(this.translationKey, Minecraft.m_91087_().f_91080_, (TConfigEntry[])this.options.values().toArray((Object[])new TConfigEntry[0]), this::setValuesToDefault, this::resetValuesToInitial, this.align);
            this.screen.setRenderFeature(this.renderFeature);
        }
        return this.screen;
    }

    @Override
    public AbstractWidget getWidget(int x, int y, int width, int height) {
        return new CategoryButton(x, y, width, height, this.getText(), button -> Minecraft.m_91087_().m_91152_((Screen)this.getScreen()));
    }

    @Override
    public boolean saveValuesToConfig() {
        boolean found = false;
        for (TConfigEntry option : this.options.values()) {
            found |= option.saveValuesToConfig();
        }
        return found;
    }

    @Override
    public void setValuesToDefault() {
        for (TConfigEntry option : this.options.values()) {
            option.setValuesToDefault();
        }
    }

    @Override
    public void resetValuesToInitial() {
        for (TConfigEntry option : this.options.values()) {
            option.resetValuesToInitial();
        }
    }

    public TConfigEntryCategory add(TConfigEntry ... option) {
        for (TConfigEntry tConfigEntry : option) {
            this.add(tConfigEntry);
        }
        return this;
    }

    public TConfigEntryCategory addAll(Collection<TConfigEntry> option) {
        if (option == null) {
            return this;
        }
        for (TConfigEntry tConfigEntry : option) {
            this.add(tConfigEntry);
        }
        return this;
    }

    public TConfigEntryCategory add(TConfigEntry option) {
        if (option == null) {
            return this;
        }
        if (option instanceof TConfigEntryCategory) {
            TConfigEntryCategory category = (TConfigEntryCategory)option;
            return this.addOrMerge(category);
        }
        this.options.put((Object)option.getText().getString(), (Object)option);
        return this;
    }

    private TConfigEntryCategory addOrMerge(TConfigEntryCategory category) {
        Object object;
        if (this.options.containsKey((Object)category.getText().getString()) && (object = this.options.get((Object)category.getText().getString())) instanceof TConfigEntryCategory) {
            TConfigEntryCategory existingCategory = (TConfigEntryCategory)((Object)object);
            for (TConfigEntry option : category.options.values()) {
                existingCategory.add(option);
            }
        } else {
            this.options.put((Object)category.getText().getString(), (Object)category);
        }
        return this;
    }

    @Override
    boolean hasChangedFromInitial() {
        boolean changed = false;
        for (TConfigEntry value : this.options.values()) {
            if (!value.hasChangedFromInitial()) continue;
            changed = true;
            break;
        }
        return changed;
    }

    public TConfigEntryCategory setEmptyTooltip(@NotNull @Translatable String emptyTooltipKey) {
        this.emptyTooltip = Component.m_237115_((String)emptyTooltipKey);
        return this;
    }

    public void setRenderFeature(TConfigScreenList.Renderable renderFeature) {
        this.renderFeature = renderFeature;
    }

    private class CategoryButton
    extends Button {
        protected CategoryButton(int x, int y, int width, int height, Component message, Button.OnPress onPress) {
            super(x, y, width, height, message, onPress, TConfigEntryCategory.this.options.isEmpty() ? TConfigEntry.getTooltip(TConfigEntryCategory.this.emptyTooltip) : TConfigEntryCategory.this.getTooltip());
            this.f_93623_ = !TConfigEntryCategory.this.options.isEmpty();
        }

        public Component m_6035_() {
            return TConfigEntryCategory.this.hasChangedFromInitial() ? Component.m_130674_((String)("\u00a7a" + super.m_6035_().getString())) : super.m_6035_();
        }
    }

    public static class Empty
    extends TConfigEntryCategory {
        public Empty() {
            super("", null);
        }

        @Override
        public AbstractWidget getWidget(int x, int y, int width, int height) {
            return null;
        }
    }
}

