/*
 * Decompiled with CFR 0.152.
 */
package traben.tconfig.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import traben.tconfig.TConfig;
import traben.tconfig.TConfigHandler;
import traben.tconfig.gui.TConfigEntryListWidget;
import traben.tconfig.gui.TConfigScreen;
import traben.tconfig.gui.entries.TConfigEntry;
import traben.tconfig.gui.entries.TConfigEntryCategory;

public abstract class TConfigScreenMain
extends TConfigScreen {
    protected final TConfigEntryCategory entries;
    protected final List<ResourceLocation> modIcons;
    protected final Set<TConfigHandler<?>> configHandlers;
    boolean haveInitConfigs = false;

    public TConfigScreenMain(String title, Screen parent, Set<TConfigHandler<?>> inputHandlers, List<TConfigEntry> defaultEntries) {
        super(title, parent, true);
        this.entries = new TConfigEntryCategory.Empty().addAll(defaultEntries);
        this.modIcons = new ArrayList<ResourceLocation>();
        this.configHandlers = inputHandlers;
        this.resetDefaultValuesRunnable = this.entries::setValuesToDefault;
        this.undoChangesRunnable = this.entries::resetValuesToInitial;
    }

    @Override
    protected Component getBackButtonText() {
        return CommonComponents.f_130655_;
    }

    private void initConfigs() {
        if (this.haveInitConfigs) {
            return;
        }
        this.haveInitConfigs = true;
        for (TConfigHandler<?> configHandler : this.configHandlers) {
            if (!configHandler.doesGUI()) continue;
            Object config = configHandler.getConfig();
            for (TConfigEntry value : ((TConfig)config).getGUIOptions().getOptions().values()) {
                this.entries.add(value);
            }
            ResourceLocation icon = ((TConfig)config).getModIcon();
            if (icon == null) continue;
            this.modIcons.add(icon);
        }
    }

    @Override
    public void m_7379_() {
        if (this.entries.saveValuesToConfig()) {
            for (TConfigHandler<?> configHandler : this.configHandlers) {
                configHandler.saveToFile();
            }
            Minecraft.m_91087_().m_91391_();
        }
        super.m_7379_();
    }

    @Override
    protected void m_7856_() {
        this.initConfigs();
        super.m_7856_();
        TConfigEntryListWidget child = new TConfigEntryListWidget((int)((double)this.f_96543_ * 0.3), (int)((double)this.f_96544_ * 0.7), (int)((double)this.f_96544_ * 0.15), (int)((double)this.f_96543_ * 0.6), 24, (TConfigEntry[])this.entries.getOptions().values().toArray((Object[])new TConfigEntry[0]));
        this.m_142416_((GuiEventListener)child);
    }

    @Override
    public void m_6305_(PoseStack context, int mouseX, int mouseY, float delta) {
        super.m_6305_(context, mouseX, mouseY, delta);
        if (!this.modIcons.isEmpty()) {
            int ix = this.f_96543_ - this.modIcons.size() * 34;
            for (ResourceLocation modIcon : this.modIcons) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)modIcon);
                TConfigScreenMain.m_93133_((PoseStack)context, (int)ix, (int)2, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
                ix += 34;
            }
        }
    }
}

