/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.features.texture_handlers;

import com.mojang.blaze3d.platform.NativeImage;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import org.jetbrains.annotations.NotNull;
import traben.entity_texture_features.features.texture_handlers.ETFTexture;
import traben.entity_texture_features.utils.ETFUtils2;

public class ETFSprite {
    public final boolean isETFAltered;
    private final TextureAtlasSprite sprite;
    private final TextureAtlasSprite emissiveSprite;

    public ETFSprite(@NotNull TextureAtlasSprite originalSprite, @NotNull ETFTexture etfTexture) {
        Optional resource;
        ResourceLocation emissiveId;
        TextureAtlasSprite sprite1;
        block11: {
            if (etfTexture.getVariantNumber() != 0) {
                ResourceLocation variantId = etfTexture.getTextureIdentifier(null);
                Optional resource2 = Minecraft.m_91087_().m_91098_().m_213713_(variantId);
                if (resource2.isPresent()) {
                    try {
                        NativeImage image = ETFUtils2.getNativeImageElseNull(variantId);
                        Optional meta = ((Resource)resource2.get()).m_215509_().m_214059_((MetadataSectionSerializer)AnimationMetadataSection.f_119011_);
                        if (image != null) {
                            AnimationMetadataSection anim = meta.orElse(AnimationMetadataSection.f_119012_);
                            TextureAtlasSprite.Info info = new TextureAtlasSprite.Info(new ResourceLocation(variantId + "-etf_sprite"), anim.m_119031_(16), anim.m_119026_(16), anim);
                            sprite1 = new TextureAtlasSprite(new TextureAtlas(variantId), info, 1, info.m_118434_(), info.m_118437_(), 0, 0, image);
                            break block11;
                        }
                        sprite1 = originalSprite;
                    }
                    catch (Exception e) {
                        sprite1 = originalSprite;
                    }
                } else {
                    sprite1 = originalSprite;
                }
            } else {
                sprite1 = originalSprite;
            }
        }
        this.sprite = sprite1;
        this.isETFAltered = !this.sprite.equals(originalSprite);
        TextureAtlasSprite possibleEmissive = null;
        if (etfTexture.eSuffix != null && (emissiveId = etfTexture.getEmissiveIdentifierOfCurrentState()) != null && (resource = Minecraft.m_91087_().m_91098_().m_213713_(emissiveId)).isPresent()) {
            try {
                NativeImage image = ETFUtils2.getNativeImageElseNull(emissiveId);
                Optional meta = ((Resource)resource.get()).m_215509_().m_214059_((MetadataSectionSerializer)AnimationMetadataSection.f_119011_);
                if (image != null) {
                    AnimationMetadataSection anim = meta.orElse(AnimationMetadataSection.f_119012_);
                    TextureAtlasSprite.Info info = new TextureAtlasSprite.Info(new ResourceLocation(emissiveId + "-etf_sprite"), anim.m_119031_(16), anim.m_119026_(16), anim);
                    possibleEmissive = new TextureAtlasSprite(new TextureAtlas(emissiveId), info, 1, info.m_118434_(), info.m_118437_(), 0, 0, image);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.emissiveSprite = possibleEmissive;
        System.out.println("discovered painting texture: " + etfTexture.thisIdentifier + ", isVariant=" + this.isETFAltered + ", isEmissive=" + this.isEmissive());
    }

    @NotNull
    public TextureAtlasSprite getEmissive() {
        return this.emissiveSprite;
    }

    public boolean isEmissive() {
        return this.emissiveSprite != null;
    }

    @NotNull
    public TextureAtlasSprite getSpriteVariant() {
        return this.sprite;
    }
}

