/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.forge.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import traben.entity_texture_features.config.ETFConfig;
import traben.entity_texture_features.config.screens.ETFConfigScreen;
import traben.entity_texture_features.features.ETFManager;
import traben.entity_texture_features.features.ETFRenderContext;
import traben.entity_texture_features.features.texture_handlers.ETFTexture;

@Mixin(value={HumanoidArmorLayer.class})
public abstract class MixinArmorFeatureRenderer<T extends LivingEntity, M extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    @Unique
    private ETFTexture entity_texture_features$thisETFTexture = null;

    public MixinArmorFeatureRenderer(RenderLayerParent<T, M> context) {
        super(context);
    }

    @Inject(method={"render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/entity/LivingEntity;FFFFFF)V"}, at={@At(value="HEAD")})
    private void etf$markNotToChange(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, T livingEntity, float f, float g, float h, float j, float k, float l, CallbackInfo ci) {
        ETFRenderContext.preventRenderLayerTextureModify();
        ETFRenderContext.allowTexturePatching();
    }

    @Inject(method={"render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/entity/LivingEntity;FFFFFF)V"}, at={@At(value="RETURN")})
    private void etf$markAllowedToChange(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, T livingEntity, float f, float g, float h, float j, float k, float l, CallbackInfo ci) {
        ETFRenderContext.allowRenderLayerTextureModify();
        ETFRenderContext.preventTexturePatching();
    }

    @ModifyArg(method={"renderModel"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/RenderLayer;getArmorCutoutNoCull(Lnet/minecraft/util/Identifier;)Lnet/minecraft/client/render/RenderLayer;"))
    private ResourceLocation etf$changeTexture(ResourceLocation texture) {
        if (ETFConfig.getInstance().enableArmorAndTrims) {
            this.entity_texture_features$thisETFTexture = ETFManager.getInstance().getETFTextureNoVariation(texture);
            if (this.entity_texture_features$thisETFTexture != null) {
                this.entity_texture_features$thisETFTexture.reRegisterBaseTexture();
                return this.entity_texture_features$thisETFTexture.getTextureIdentifier(null);
            }
        }
        return texture;
    }

    @Inject(method={"renderModel"}, at={@At(value="TAIL")})
    private void etf$applyEmissive(PoseStack arg, MultiBufferSource arg2, int i, boolean bl, Model arg3, float f, float g, float h, ResourceLocation armorResource, CallbackInfo ci) {
        ResourceLocation emissive;
        if (this.entity_texture_features$thisETFTexture != null && ETFConfig.getInstance().enableEmissiveTextures && (emissive = this.entity_texture_features$thisETFTexture.getEmissiveIdentifierOfCurrentState()) != null) {
            VertexConsumer textureVert = arg2.m_6299_(RenderType.m_110431_((ResourceLocation)emissive));
            ETFRenderContext.startSpecialRenderOverlayPhase();
            arg3.m_7695_(arg, textureVert, 0xF000F2, OverlayTexture.f_118083_, f, g, h, 1.0f);
            ETFRenderContext.endSpecialRenderOverlayPhase();
        }
    }

    @Inject(method={"render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/entity/LivingEntity;FFFFFF)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void etf$cancelIfUi(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, T livingEntity, float f, float g, float h, float j, float k, float l, CallbackInfo ci) {
        if (Minecraft.m_91087_() != null && Minecraft.m_91087_().f_91080_ instanceof ETFConfigScreen) {
            ci.cancel();
        }
    }
}

