/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.UUID;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.config.ETFConfig;
import traben.entity_texture_features.config.screens.warnings.ETFConfigWarning;
import traben.entity_texture_features.config.screens.warnings.ETFConfigWarnings;
import traben.entity_texture_features.features.ETFManager;
import traben.entity_texture_features.features.property_reading.PropertiesRandomProvider;
import traben.entity_texture_features.features.property_reading.TrueRandomProvider;
import traben.entity_texture_features.features.property_reading.properties.RandomProperties;
import traben.entity_texture_features.features.texture_handlers.ETFTexture;
import traben.entity_texture_features.utils.ETFEntity;
import traben.entity_texture_features.utils.ETFUtils2;

public final class ETFApi {
    public static final int ETFApiVersion = 9;
    @Deprecated
    public static ETFConfig getETFConfigObject = null;
    public static final UUID ETF_GENERIC_UUID = UUID.nameUUIDFromBytes("GENERIC".getBytes());
    public static final long ETF_SPAWNER_MARKER = 0x303900003039L;

    public static ETFConfig getETFConfigObject() {
        return ETFConfig.getInstance();
    }

    public static void setETFConfigObject(ETFConfig newETFConfig) {
        if (newETFConfig != null) {
            ETFConfig.setInstance(newETFConfig);
            ETFApi.saveETFConfigChangesAndResetETF();
        } else {
            ETFUtils2.logError("new config was null: ignoring.");
        }
    }

    public static ETFConfig getCopyOfETFConfigObject() {
        return ETFConfig.copyFrom(ETFConfig.getInstance());
    }

    public static ETFConfig getDefaultETFConfigObject() {
        return new ETFConfig();
    }

    public static void saveETFConfigChangesAndResetETF() {
        ETFConfig.saveConfig();
        ETFManager.resetInstance();
    }

    public static void resetETF() {
        ETFManager.resetInstance();
    }

    public static UUID getUUIDForBlockEntity(BlockEntity blockEntity) {
        long most = blockEntity.m_58900_().hashCode();
        long least = blockEntity.m_58899_().hashCode();
        return new UUID(most, least);
    }

    @NotNull
    public static ResourceLocation getCurrentETFVariantTextureOfEntity(@NotNull Entity entity, @NotNull ResourceLocation defaultTexture) {
        if (entity != null) {
            ResourceLocation etfIdentifier;
            ETFEntity etfEntity = (ETFEntity)entity;
            ETFTexture etfTexture = ETFManager.getInstance().getETFTextureVariant(defaultTexture, etfEntity);
            if (etfTexture != null && (etfIdentifier = etfTexture.getTextureIdentifier(etfEntity)) != null) {
                return etfIdentifier;
            }
        }
        return defaultTexture;
    }

    public static ResourceLocation getCurrentETFVariantTextureOfBlockEntity(@NotNull BlockEntity entity, @NotNull ResourceLocation defaultTexture) {
        if (entity != null) {
            ETFEntity etfEntity = (ETFEntity)entity;
            return ETFApi.getCurrentETFVariantTextureOfBlockEntityInternal(etfEntity, defaultTexture);
        }
        return defaultTexture;
    }

    public static ResourceLocation getCurrentETFVariantTextureOfBlockEntity(@NotNull BlockEntity entity, @NotNull ResourceLocation defaultTexture, @NotNull UUID specifiedUUID) {
        if (entity != null) {
            ETFEntity etfEntity = (ETFEntity)entity;
            return ETFApi.getCurrentETFVariantTextureOfBlockEntityInternal(etfEntity, defaultTexture);
        }
        return defaultTexture;
    }

    private static ResourceLocation getCurrentETFVariantTextureOfBlockEntityInternal(@NotNull ETFEntity etfEntity, @NotNull ResourceLocation defaultTexture) {
        ResourceLocation etfIdentifier;
        ETFTexture etfTexture = ETFManager.getInstance().getETFTextureVariant(defaultTexture, etfEntity);
        if (etfTexture != null && (etfIdentifier = etfTexture.getTextureIdentifier(etfEntity)) != null) {
            return etfIdentifier;
        }
        return defaultTexture;
    }

    @Deprecated
    @NotNull
    public static ResourceLocation getCurrentETFVariantTextureOfEntity(@NotNull BlockEntity entity, @NotNull ResourceLocation defaultTexture, UUID ignore) {
        return ETFApi.getCurrentETFVariantTextureOfBlockEntity(entity, defaultTexture);
    }

    @Nullable
    public static ResourceLocation getCurrentETFEmissiveTextureOfEntityOrNull(@NotNull Entity entity, @NotNull ResourceLocation defaultTexture) {
        ETFTexture etfTexture;
        if (entity != null && (etfTexture = ETFManager.getInstance().getETFTextureVariant(defaultTexture, (ETFEntity)entity)) != null) {
            return etfTexture.getEmissiveIdentifierOfCurrentState();
        }
        return null;
    }

    @Nullable
    public static ResourceLocation getCurrentETFEmissiveTextureOfBlockEntityOrNull(@NotNull BlockEntity entity, @NotNull ResourceLocation defaultTexture) {
        ETFTexture etfTexture;
        if (entity != null && (etfTexture = ETFManager.getInstance().getETFTextureVariant(defaultTexture, (ETFEntity)entity)) != null) {
            return etfTexture.getEmissiveIdentifierOfCurrentState();
        }
        return null;
    }

    public static void renderETFEmissiveModel(@NotNull Entity entity, @NotNull ResourceLocation defaultTextureOfEntity, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource vertexConsumerProvider, @NotNull Model model) {
        ETFTexture etfTexture = ETFManager.getInstance().getETFTextureVariant(defaultTextureOfEntity, (ETFEntity)entity);
        if (etfTexture != null) {
            etfTexture.renderEmissive(matrixStack, vertexConsumerProvider, model);
        }
    }

    public static void renderETFEmissiveModelPart(@NotNull Entity entity, @NotNull ResourceLocation defaultTextureOfEntity, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource vertexConsumerProvider, @NotNull ModelPart modelPart) {
        ETFTexture etfTexture = ETFManager.getInstance().getETFTextureVariant(defaultTextureOfEntity, (ETFEntity)entity);
        if (etfTexture != null) {
            etfTexture.renderEmissive(matrixStack, vertexConsumerProvider, modelPart);
        }
    }

    public static void renderETFEmissiveModel(@NotNull BlockEntity entity, @NotNull ResourceLocation defaultTextureOfEntity, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource vertexConsumerProvider, @NotNull Model model) {
        ETFTexture etfTexture = ETFManager.getInstance().getETFTextureVariant(defaultTextureOfEntity, (ETFEntity)entity);
        if (etfTexture != null) {
            etfTexture.renderEmissive(matrixStack, vertexConsumerProvider, model);
        }
    }

    public static void renderETFEmissiveModelPart(@NotNull BlockEntity entity, @NotNull ResourceLocation defaultTextureOfEntity, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource vertexConsumerProvider, @NotNull ModelPart modelPart) {
        ETFTexture etfTexture = ETFManager.getInstance().getETFTextureVariant(defaultTextureOfEntity, (ETFEntity)entity);
        if (etfTexture != null) {
            etfTexture.renderEmissive(matrixStack, vertexConsumerProvider, modelPart);
        }
    }

    @Nullable
    public static ETFVariantSuffixProvider getVariantSupplierOrNull(ResourceLocation propertiesFileIdentifier, ResourceLocation vanillaIdentifier, String ... suffixKeys) {
        return ETFVariantSuffixProvider.getVariantProviderOrNull(propertiesFileIdentifier, vanillaIdentifier, suffixKeys);
    }

    public static int getLastMatchingRuleOfEntity(Entity entity) {
        Integer ruleIndex = ETFManager.getInstance().LAST_MET_RULE_INDEX.getInt(entity.m_20148_());
        return ruleIndex == null ? 0 : ruleIndex;
    }

    public static int getLastMatchingRuleOfBlockEntity(BlockEntity entity) {
        Integer ruleIndex = ETFManager.getInstance().LAST_MET_RULE_INDEX.getInt(((ETFEntity)entity).etf$getUuid());
        return ruleIndex == null ? 0 : ruleIndex;
    }

    public static void registerCustomRandomPropertyFactory(String yourModId, RandomProperties.RandomPropertyFactory ... factories) {
        if (factories != null && factories.length != 0) {
            RandomProperties.register(factories);
            ETFUtils2.logMessage(factories.length + " new ETF Random Properties registered by " + yourModId);
        }
    }

    public static void registerCustomETFConfigWarning(String yourModId, ETFConfigWarning ... warnings) {
        if (warnings != null && warnings.length != 0) {
            ETFConfigWarnings.registerConfigWarning(warnings);
            ETFUtils2.logMessage(warnings.length + " new ETF Config Warnings registered by " + yourModId);
        }
    }

    public static interface ETFVariantSuffixProvider {
        @Nullable
        public static ETFVariantSuffixProvider getVariantProviderOrNull(ResourceLocation propertiesFileIdentifier, ResourceLocation vanillaIdentifier, String ... suffixKeyName) {
            PropertiesRandomProvider optifine = PropertiesRandomProvider.of(propertiesFileIdentifier, vanillaIdentifier, suffixKeyName);
            TrueRandomProvider random = TrueRandomProvider.of(vanillaIdentifier);
            if (optifine == null && vanillaIdentifier.m_135815_().endsWith(".png") && "minecraft".equals(vanillaIdentifier.m_135827_()) && vanillaIdentifier.m_135815_().contains("_")) {
                String vanId = vanillaIdentifier.m_135815_().replaceAll("_(tame|angry|nectar|shooting|cold)", "");
                optifine = PropertiesRandomProvider.of(new ResourceLocation(vanId.replace(".png", ".properties")), new ResourceLocation(vanId), suffixKeyName);
            }
            if (random == null && optifine == null) {
                return null;
            }
            if (optifine == null) {
                return random;
            }
            if (random == null) {
                return optifine;
            }
            if (optifine.getPackName() != null && optifine.getPackName().equals(ETFUtils2.returnNameOfHighestPackFromTheseTwo(random.getPackName(), optifine.getPackName()))) {
                return optifine;
            }
            return random;
        }

        public boolean entityCanUpdate(UUID var1);

        public IntOpenHashSet getAllSuffixes();

        public int size();

        default public int getSuffixForEntity(Entity entityToBeTested) {
            return this.getSuffixForETFEntity((ETFEntity)entityToBeTested);
        }

        default public int getSuffixForBlockEntity(BlockEntity entityToBeTested) {
            return this.getSuffixForETFEntity((ETFEntity)entityToBeTested);
        }

        public int getSuffixForETFEntity(ETFEntity var1);
    }
}

