/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.propeties;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import traben.entity_model_features.models.animation.math.MathValue;
import traben.entity_model_features.utils.EMFEntity;
import traben.entity_texture_features.features.property_reading.properties.RandomProperty;
import traben.entity_texture_features.utils.ETFEntity;

public class EntityVariableBooleanProperty
extends RandomProperty {
    private final Map<String, Boolean> VARIABLE_MAP;

    protected EntityVariableBooleanProperty(Properties properties, int propertyNum) throws RandomProperty.RandomPropertyException {
        String keyPrefix = "varb." + propertyNum + ".";
        this.VARIABLE_MAP = new Object2ObjectLinkedOpenHashMap();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            if (key != null && ((String)key).startsWith(keyPrefix)) {
                String instruction = ((String)value).trim();
                String variableKey = "varb." + ((String)key).replaceAll(keyPrefix, "");
                if (!variableKey.isBlank() && !instruction.isBlank()) {
                    boolean matchTrue = instruction.contains("true");
                    this.VARIABLE_MAP.put(variableKey, matchTrue);
                }
            }
        }));
        if (this.VARIABLE_MAP.isEmpty()) {
            throw new RandomProperty.RandomPropertyException("Variable booleans failed");
        }
    }

    public static EntityVariableBooleanProperty getPropertyOrNull(Properties properties, int propertyNum) {
        try {
            return new EntityVariableBooleanProperty(properties, propertyNum);
        }
        catch (RandomProperty.RandomPropertyException var3) {
            return null;
        }
    }

    protected boolean testEntityInternal(ETFEntity etfEntity) {
        if (etfEntity instanceof EMFEntity) {
            EMFEntity emfEntity = (EMFEntity)etfEntity;
            for (Map.Entry<String, Boolean> stringFunctionEntry : this.VARIABLE_MAP.entrySet()) {
                boolean value = MathValue.toBoolean(emfEntity.emf$getVariableMap().getFloat((Object)stringFunctionEntry.getKey()));
                if (stringFunctionEntry.getValue() == value) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @NotNull
    public String[] getPropertyIds() {
        return new String[]{"varb"};
    }

    protected String getPrintableRuleInfo() {
        return null;
    }
}

