/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation.math.variables;

import com.demonwav.mcdev.annotations.Translatable;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.EMFAnimationEntityContext;
import traben.entity_model_features.models.animation.math.MathComponent;
import traben.entity_model_features.models.animation.math.MathConstant;
import traben.entity_model_features.models.animation.math.MathValue;
import traben.entity_model_features.models.animation.math.MathVariable;
import traben.entity_model_features.models.animation.math.variables.factories.GlobalVariableFactory;
import traben.entity_model_features.models.animation.math.variables.factories.ModelPartVariableFactory;
import traben.entity_model_features.models.animation.math.variables.factories.ModelVariableFactory;
import traben.entity_model_features.models.animation.math.variables.factories.RenderVariableFactory;
import traben.entity_model_features.models.animation.math.variables.factories.UniqueVariableFactory;
import traben.entity_model_features.utils.EMFEntity;
import traben.entity_model_features.utils.EMFManager;
import traben.entity_model_features.utils.EMFUtils;

public final class VariableRegistry {
    private static final VariableRegistry INSTANCE = new VariableRegistry();
    private final Map<String, MathComponent> singletonVariables = new Object2ObjectOpenHashMap();
    private final Map<String, String> singletonVariableExplanationTranslationKeys = new Object2ObjectOpenHashMap();
    private final List<UniqueVariableFactory> uniqueVariableFactories = new ArrayList<UniqueVariableFactory>();

    private VariableRegistry() {
        this.singletonVariables.put("pi", new MathConstant((float)Math.PI));
        this.singletonVariables.put("-pi", new MathConstant((float)(-Math.PI)));
        this.singletonVariableExplanationTranslationKeys.put("pi", VariableRegistry.emfTranslationKey("pi"));
        this.singletonVariables.put("e", new MathConstant((float)Math.E));
        this.singletonVariables.put("-e", new MathConstant(-2.7182817f));
        this.singletonVariableExplanationTranslationKeys.put("e", VariableRegistry.emfTranslationKey("e"));
        this.singletonVariables.put("true", new MathConstant(Float.POSITIVE_INFINITY));
        this.singletonVariables.put("!true", new MathConstant(Float.NEGATIVE_INFINITY));
        this.singletonVariableExplanationTranslationKeys.put("true", VariableRegistry.emfTranslationKey("true"));
        this.singletonVariables.put("false", new MathConstant(Float.NEGATIVE_INFINITY));
        this.singletonVariables.put("!false", new MathConstant(Float.POSITIVE_INFINITY));
        this.singletonVariableExplanationTranslationKeys.put("false", VariableRegistry.emfTranslationKey("false"));
        this.registerSimpleFloatVariable("limb_swing", EMFAnimationEntityContext::getLimbAngle);
        this.registerSimpleFloatVariable("frame_time", EMFAnimationEntityContext::getFrameTime);
        this.registerSimpleFloatVariable("limb_speed", EMFAnimationEntityContext::getLimbDistance);
        this.registerSimpleFloatVariable("age", EMFAnimationEntityContext::getAge);
        this.registerSimpleFloatVariable("head_pitch", EMFAnimationEntityContext::getHeadPitch);
        this.registerSimpleFloatVariable("head_yaw", EMFAnimationEntityContext::getHeadYaw);
        this.registerSimpleFloatVariable("swing_progress", EMFAnimationEntityContext::getSwingProgress);
        this.registerSimpleFloatVariable("hurt_time", EMFAnimationEntityContext::getHurtTime);
        this.registerSimpleFloatVariable("dimension", EMFAnimationEntityContext::getDimension);
        this.registerSimpleFloatVariable("time", EMFAnimationEntityContext::getTime);
        this.registerSimpleFloatVariable("player_pos_x", VariableRegistry.emfTranslationKey("player_pos"), EMFAnimationEntityContext::getPlayerX);
        this.registerSimpleFloatVariable("player_pos_y", VariableRegistry.emfTranslationKey("player_pos"), EMFAnimationEntityContext::getPlayerY);
        this.registerSimpleFloatVariable("player_pos_z", VariableRegistry.emfTranslationKey("player_pos"), EMFAnimationEntityContext::getPlayerZ);
        this.registerSimpleFloatVariable("pos_x", VariableRegistry.emfTranslationKey("pos"), EMFAnimationEntityContext::getEntityX);
        this.registerSimpleFloatVariable("pos_y", VariableRegistry.emfTranslationKey("pos"), EMFAnimationEntityContext::getEntityY);
        this.registerSimpleFloatVariable("pos_z", VariableRegistry.emfTranslationKey("pos"), EMFAnimationEntityContext::getEntityZ);
        this.registerSimpleFloatVariable("player_rot_x", VariableRegistry.emfTranslationKey("player_rot"), EMFAnimationEntityContext::getPlayerRX);
        this.registerSimpleFloatVariable("player_rot_y", VariableRegistry.emfTranslationKey("player_rot"), EMFAnimationEntityContext::getPlayerRY);
        this.registerSimpleFloatVariable("rot_x", VariableRegistry.emfTranslationKey("rot"), EMFAnimationEntityContext::getEntityRX);
        this.registerSimpleFloatVariable("rot_y", VariableRegistry.emfTranslationKey("rot"), EMFAnimationEntityContext::getEntityRY);
        this.registerSimpleFloatVariable("health", EMFAnimationEntityContext::getHealth);
        this.registerSimpleFloatVariable("death_time", EMFAnimationEntityContext::getDeathTime);
        this.registerSimpleFloatVariable("anger_time", EMFAnimationEntityContext::getAngerTime);
        this.registerSimpleFloatVariable("max_health", EMFAnimationEntityContext::getMaxHealth);
        this.registerSimpleFloatVariable("id", EMFAnimationEntityContext::getId);
        this.registerSimpleFloatVariable("day_time", EMFAnimationEntityContext::getDayTime);
        this.registerSimpleFloatVariable("day_count", EMFAnimationEntityContext::getDayCount);
        this.registerSimpleFloatVariable("rule_index", EMFAnimationEntityContext::getRuleIndex);
        this.registerSimpleFloatVariable("anger_time_start", EMFAnimationEntityContext::getAngerTimeStart);
        this.registerSimpleFloatVariable("move_forward", EMFAnimationEntityContext::getMoveForward);
        this.registerSimpleFloatVariable("move_strafing", EMFAnimationEntityContext::getMoveStrafe);
        this.registerSimpleFloatVariable("height_above_ground", EMFAnimationEntityContext::getHeightAboveGround);
        this.registerSimpleFloatVariable("fluid_depth", EMFAnimationEntityContext::getFluidDepth);
        this.registerSimpleFloatVariable("fluid_depth_down", EMFAnimationEntityContext::getFluidDepthDown);
        this.registerSimpleFloatVariable("fluid_depth_up", EMFAnimationEntityContext::getFluidDepthUp);
        this.registerSimpleFloatVariable("nan", () -> EMFManager.getInstance().isAnimationValidationPhase ? 0.0f : Float.NaN);
        this.registerSimpleFloatVariable("distance", () -> {
            if (EMFAnimationEntityContext.getEMFEntity() == null) {
                return 0.0f;
            }
            return EMFAnimationEntityContext.getEMFEntity().etf$distanceTo((Entity)Minecraft.m_91087_().f_91074_);
        });
        this.registerSimpleBoolVariable("is_first_person_hand", () -> EMFAnimationEntityContext.isFirstPersonHand);
        this.registerSimpleBoolVariable("is_right_handed", () -> {
            LivingEntity entity;
            if (EMFAnimationEntityContext.getEMFEntity() == null) {
                return false;
            }
            EMFEntity patt7387$temp = EMFAnimationEntityContext.getEMFEntity();
            return patt7387$temp instanceof LivingEntity && (entity = (LivingEntity)patt7387$temp).m_5737_() == HumanoidArm.RIGHT;
        });
        this.registerSimpleBoolVariable("is_swinging_right_arm", () -> EMFAnimationEntityContext.isUsingHand(true));
        this.registerSimpleBoolVariable("is_swinging_left_arm", () -> EMFAnimationEntityContext.isUsingHand(false));
        this.registerSimpleBoolVariable("is_swimming", () -> {
            Entity entity;
            if (EMFAnimationEntityContext.getEMFEntity() == null) {
                return false;
            }
            EMFEntity patt7895$temp = EMFAnimationEntityContext.getEMFEntity();
            return patt7895$temp instanceof Entity && (entity = (Entity)patt7895$temp).m_6069_();
        });
        this.registerSimpleBoolVariable("is_gliding", () -> {
            LivingEntity entity;
            if (EMFAnimationEntityContext.getEMFEntity() == null) {
                return false;
            }
            EMFEntity patt8159$temp = EMFAnimationEntityContext.getEMFEntity();
            return patt8159$temp instanceof LivingEntity && (entity = (LivingEntity)patt8159$temp).m_21255_();
        });
        this.registerSimpleBoolVariable("is_blocking", () -> {
            LivingEntity livingEntity;
            if (EMFAnimationEntityContext.getEMFEntity() == null) {
                return false;
            }
            EMFEntity patt8436$temp = EMFAnimationEntityContext.getEMFEntity();
            return patt8436$temp instanceof LivingEntity && (livingEntity = (LivingEntity)patt8436$temp).m_21254_();
        });
        this.registerSimpleBoolVariable("is_crawling", () -> {
            Entity entity;
            if (EMFAnimationEntityContext.getEMFEntity() == null) {
                return false;
            }
            EMFEntity patt8717$temp = EMFAnimationEntityContext.getEMFEntity();
            return patt8717$temp instanceof Entity && (entity = (Entity)patt8717$temp).m_20143_();
        });
        this.registerSimpleBoolVariable("is_climbing", EMFAnimationEntityContext::isClimbing);
        this.registerSimpleBoolVariable("is_child", EMFAnimationEntityContext::isChild);
        this.registerSimpleBoolVariable("is_in_water", EMFAnimationEntityContext::isInWater);
        this.registerSimpleBoolVariable("is_riding", EMFAnimationEntityContext::isRiding);
        this.registerSimpleBoolVariable("is_on_ground", EMFAnimationEntityContext::isOnGround);
        this.registerSimpleBoolVariable("is_burning", EMFAnimationEntityContext::isBurning);
        this.registerSimpleBoolVariable("is_alive", EMFAnimationEntityContext::isAlive);
        this.registerSimpleBoolVariable("is_glowing", EMFAnimationEntityContext::isGlowing);
        this.registerSimpleBoolVariable("is_aggressive", EMFAnimationEntityContext::isAggressive);
        this.registerSimpleBoolVariable("is_hurt", EMFAnimationEntityContext::isHurt);
        this.registerSimpleBoolVariable("is_in_hand", EMFAnimationEntityContext::isInHand);
        this.registerSimpleBoolVariable("is_in_item_frame", EMFAnimationEntityContext::isInItemFrame);
        this.registerSimpleBoolVariable("is_in_ground", EMFAnimationEntityContext::isInGround);
        this.registerSimpleBoolVariable("is_in_gui", EMFAnimationEntityContext::isInGui);
        this.registerSimpleBoolVariable("is_in_lava", EMFAnimationEntityContext::isInLava);
        this.registerSimpleBoolVariable("is_invisible", EMFAnimationEntityContext::isInvisible);
        this.registerSimpleBoolVariable("is_on_head", EMFAnimationEntityContext::isOnHead);
        this.registerSimpleBoolVariable("is_on_shoulder", EMFAnimationEntityContext::isOnShoulder);
        this.registerSimpleBoolVariable("is_ridden", EMFAnimationEntityContext::isRidden);
        this.registerSimpleBoolVariable("is_sitting", EMFAnimationEntityContext::isSitting);
        this.registerSimpleBoolVariable("is_sneaking", EMFAnimationEntityContext::isSneaking);
        this.registerSimpleBoolVariable("is_sprinting", EMFAnimationEntityContext::isSprinting);
        this.registerSimpleBoolVariable("is_tamed", EMFAnimationEntityContext::isTamed);
        this.registerSimpleBoolVariable("is_wet", EMFAnimationEntityContext::isWet);
        this.registerSimpleBoolVariable("is_jumping", EMFAnimationEntityContext::isJumping);
        this.registerContextVariable(new ModelPartVariableFactory());
        this.registerContextVariable(new ModelVariableFactory());
        this.registerContextVariable(new RenderVariableFactory());
        this.registerContextVariable(new GlobalVariableFactory());
    }

    private static String emfTranslationKey(String key) {
        return "entity_model_features.config.variable_explanation." + key;
    }

    public static VariableRegistry getInstance() {
        return INSTANCE;
    }

    public Map<String, String> getSingletonVariableExplanationTranslationKeys() {
        return this.singletonVariableExplanationTranslationKeys;
    }

    public List<UniqueVariableFactory> getUniqueVariableFactories() {
        return this.uniqueVariableFactories;
    }

    public void registerContextVariable(UniqueVariableFactory factory) {
        if (factory == null) {
            EMFUtils.logWarn("Tried to register a null context variable factory");
            return;
        }
        if (this.uniqueVariableFactories.contains(factory)) {
            EMFUtils.logWarn("Tried to register a duplicate context variable factory: " + factory.getClass().getName());
            return;
        }
        this.uniqueVariableFactories.add(factory);
    }

    private void registerSimpleFloatVariable(String variableName, MathValue.ResultSupplier supplier) {
        this.registerSimpleFloatVariable(variableName, VariableRegistry.emfTranslationKey(variableName), supplier);
    }

    public void registerSimpleFloatVariable(String variableName, @Translatable String explanationTranslationKey, MathValue.ResultSupplier supplier) {
        if (this.singletonVariables.containsKey(variableName)) {
            EMFUtils.log("Duplicate variable: " + variableName + ". ignoring duplicate");
            return;
        }
        this.singletonVariables.put(variableName, new MathVariable(variableName, false, supplier));
        this.singletonVariables.put("-" + variableName, new MathVariable("-" + variableName, true, supplier));
        this.singletonVariableExplanationTranslationKeys.put(variableName, explanationTranslationKey);
    }

    private void registerSimpleBoolVariable(String variableName, BooleanSupplier boolGetter) {
        this.registerSimpleBoolVariable(variableName, VariableRegistry.emfTranslationKey(variableName), boolGetter);
    }

    public void registerSimpleBoolVariable(String variableName, @Translatable String explanationTranslationKey, BooleanSupplier boolGetter) {
        if (this.singletonVariables.containsKey(variableName)) {
            EMFUtils.log("Duplicate variable: " + variableName + ". ignoring duplicate");
            return;
        }
        this.singletonVariables.put(variableName, new MathVariable(variableName, () -> MathValue.fromBoolean(boolGetter)));
        this.singletonVariables.put("!" + variableName, new MathVariable("!" + variableName, () -> MathValue.invertBoolean(boolGetter)));
        this.singletonVariableExplanationTranslationKeys.put(variableName, explanationTranslationKey);
    }

    public MathComponent getVariable(String variableName, boolean isNegative, EMFAnimation calculationInstance) {
        try {
            Object variableWithNegative;
            Object object = variableWithNegative = isNegative ? "-" + variableName : variableName;
            if (this.singletonVariables.containsKey(variableWithNegative)) {
                return this.singletonVariables.get(variableWithNegative);
            }
            boolean invertBooleans = variableName.startsWith("!");
            String variableNameWithoutBooleanInvert = invertBooleans ? variableName.substring(1) : variableName;
            for (UniqueVariableFactory uniqueVariableFactory : this.uniqueVariableFactories) {
                MathValue.ResultSupplier supplier;
                if (!uniqueVariableFactory.createsThisVariable(variableNameWithoutBooleanInvert) || (supplier = uniqueVariableFactory.getSupplierOrNull(variableNameWithoutBooleanInvert, calculationInstance)) == null) continue;
                return new MathVariable(variableName, isNegative, invertBooleans ? () -> MathValue.invertBoolean(supplier) : supplier);
            }
            EMFUtils.logWarn("Variable [" + variableName + "] not found in animation [" + calculationInstance.animKey + "] of model [" + calculationInstance.modelName + "]. EMF will treat the variable as zero.");
        }
        catch (Exception e) {
            EMFUtils.logWarn("Error finding variable: [" + variableName + "] in animation [" + calculationInstance.animKey + "] of model [" + calculationInstance.modelName + "]. EMF will treat the variable as zero.");
        }
        return MathConstant.ZERO_CONST;
    }
}

