/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.config;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.jetbrains.annotations.NotNull;
import traben.entity_model_features.models.animation.math.methods.MethodRegistry;
import traben.entity_model_features.models.animation.math.variables.VariableRegistry;
import traben.entity_model_features.models.animation.math.variables.factories.UniqueVariableFactory;
import traben.entity_model_features.utils.EMFManager;
import traben.entity_model_features.utils.EMFOptiFinePartNameMappings;
import traben.entity_model_features.utils.OptifineMobNameForFileAndEMFMapId;
import traben.entity_texture_features.ETFApi;
import traben.entity_texture_features.ETFVersionDifferenceHandler;
import traben.entity_texture_features.config.ETFConfig;
import traben.tconfig.TConfig;
import traben.tconfig.gui.entries.TConfigEntry;
import traben.tconfig.gui.entries.TConfigEntryBoolean;
import traben.tconfig.gui.entries.TConfigEntryCategory;
import traben.tconfig.gui.entries.TConfigEntryCustomButton;
import traben.tconfig.gui.entries.TConfigEntryEnumButton;
import traben.tconfig.gui.entries.TConfigEntryEnumSlider;
import traben.tconfig.gui.entries.TConfigEntryInt;
import traben.tconfig.gui.entries.TConfigEntryText;

public class EMFConfig
extends TConfig {
    public boolean logModelCreationData = false;
    public boolean debugOnRightClick = false;
    public RenderModeChoice renderModeChoice = RenderModeChoice.NORMAL;
    public VanillaModelRenderMode vanillaModelHologramRenderMode_2 = VanillaModelRenderMode.OFF;
    public boolean attemptRevertingEntityModelsAlteredByAnotherMod = true;
    public ModelPrintMode modelExportMode = ModelPrintMode.NONE;
    public PhysicsModCompatChoice attemptPhysicsModPatch_2 = PhysicsModCompatChoice.CUSTOM;
    public ETFConfig.UpdateFrequency modelUpdateFrequency = ETFConfig.UpdateFrequency.Average;
    public ETFConfig.String2EnumNullMap<RenderModeChoice> entityRenderModeOverrides = new ETFConfig.String2EnumNullMap();
    public ETFConfig.String2EnumNullMap<PhysicsModCompatChoice> entityPhysicsModPatchOverrides = new ETFConfig.String2EnumNullMap();
    public ETFConfig.String2EnumNullMap<VanillaModelRenderMode> entityVanillaHologramOverrides = new ETFConfig.String2EnumNullMap();
    public ObjectOpenHashSet<String> modelsNamesDisabled = new ObjectOpenHashSet();
    public boolean allowEBEModConfigModify = true;
    public int animationLODDistance = 20;
    public boolean retainDetailOnLowFps = true;
    public boolean retainDetailOnLargerMobs = true;
    public boolean preventFirstPersonHandAnimating = false;
    public boolean onlyClientPlayerModel = false;

    public TConfigEntryCategory getGUIOptions() {
        return new TConfigEntryCategory.Empty().add(new TConfigEntry[]{new TConfigEntryCategory("config.entity_features.models_main").add(new TConfigEntry[]{new TConfigEntryCategory("entity_model_features.config.options", "entity_model_features.config.options.tooltip").add(new TConfigEntry[]{new TConfigEntryBoolean("entity_model_features.config.force_models", "entity_model_features.config.force_models.tooltip", () -> this.attemptRevertingEntityModelsAlteredByAnotherMod, value -> {
            this.attemptRevertingEntityModelsAlteredByAnotherMod = value;
        }, true), new TConfigEntryEnumButton("entity_model_features.config.physics", "entity_model_features.config.physics.tooltip", () -> this.attemptPhysicsModPatch_2, value -> {
            this.attemptPhysicsModPatch_2 = value;
        }, (Enum)PhysicsModCompatChoice.CUSTOM), new TConfigEntryBoolean("entity_model_features.config.ebe_config_modify", "entity_model_features.config.ebe_config_modify.tooltip", () -> this.allowEBEModConfigModify, value -> {
            this.allowEBEModConfigModify = value;
        }, true)}), new TConfigEntryCategory("entity_model_features.config.player_settings").add(new TConfigEntry[]{new TConfigEntryBoolean("entity_model_features.config.prevent_hand", "entity_model_features.config.prevent_hand.tooltip", () -> this.preventFirstPersonHandAnimating, value -> {
            this.preventFirstPersonHandAnimating = value;
        }, false), new TConfigEntryBoolean("entity_model_features.config.only_client", "entity_model_features.config.only_client.tooltip", () -> this.onlyClientPlayerModel, value -> {
            this.onlyClientPlayerModel = value;
        }, false)}), new TConfigEntryCategory("entity_model_features.config.performance").add(new TConfigEntry[]{new TConfigEntryEnumSlider("entity_model_features.config.update", "entity_model_features.config.update.tooltip", () -> this.modelUpdateFrequency, value -> {
            this.modelUpdateFrequency = value;
        }, (Enum)ETFConfig.UpdateFrequency.Average), new TConfigEntryInt("entity_model_features.config.lod", "entity_model_features.config.lod.tooltip", () -> this.animationLODDistance, value -> {
            this.animationLODDistance = value;
        }, 20, 0, 65, true, true), new TConfigEntryBoolean("entity_model_features.config.low_fps_lod", "entity_model_features.config.low_fps_lod.tooltip", () -> this.retainDetailOnLowFps, value -> {
            this.retainDetailOnLowFps = value;
        }, true), new TConfigEntryBoolean("entity_model_features.config.large_mob_lod", "entity_model_features.config.large_mob_lod.tooltip", () -> this.retainDetailOnLargerMobs, value -> {
            this.retainDetailOnLargerMobs = value;
        }, true)}), new TConfigEntryCategory("entity_model_features.config.tools", "entity_model_features.config.tools.tooltip").add(new TConfigEntry[]{new TConfigEntryEnumSlider("entity_model_features.config.vanilla_render", "entity_model_features.config.vanilla_render.tooltip", () -> this.vanillaModelHologramRenderMode_2, value -> {
            this.vanillaModelHologramRenderMode_2 = value;
        }, (Enum)VanillaModelRenderMode.OFF), new TConfigEntryEnumSlider("entity_model_features.config.print_mode", "entity_model_features.config.print_mode.tooltip", () -> this.modelExportMode, value -> {
            this.modelExportMode = value;
        }, (Enum)ModelPrintMode.NONE)}), new TConfigEntryCategory("entity_model_features.config.debug", "entity_model_features.config.debug.tooltip").add(new TConfigEntry[]{new TConfigEntryEnumSlider("entity_model_features.config.render", "entity_model_features.config.render.tooltip", () -> this.renderModeChoice, value -> {
            this.renderModeChoice = value;
        }, (Enum)RenderModeChoice.NORMAL), new TConfigEntryBoolean("entity_model_features.config.log_models", "entity_model_features.config.log_models.tooltip", () -> this.logModelCreationData, value -> {
            this.logModelCreationData = value;
        }, false), new TConfigEntryBoolean("entity_model_features.config.debug_right_click", "entity_model_features.config.debug_right_click.tooltip", () -> this.debugOnRightClick, value -> {
            this.debugOnRightClick = value;
        }, false)}), this.getModelSettings(), this.getMathInfo()}), this.getEntitySettings()});
    }

    private TConfigEntryCategory getMathInfo() {
        TConfigEntryCategory category = new TConfigEntryCategory("entity_model_features.config.math");
        category.addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)"entity_model_features.config.math.explain", (int)200, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
        TConfigEntryCategory variables = new TConfigEntryCategory("entity_model_features.config.variables");
        category.add((TConfigEntry)variables);
        variables.addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)"entity_model_features.config.variables.explain", (int)200, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
        for (UniqueVariableFactory uniqueVariableFactory : VariableRegistry.getInstance().getUniqueVariableFactories()) {
            TConfigEntryCategory unique = new TConfigEntryCategory(uniqueVariableFactory.getTitleTranslationKey()).addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)uniqueVariableFactory.getExplanationTranslationKey(), (int)200, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
            variables.add((TConfigEntry)unique);
        }
        VariableRegistry.getInstance().getSingletonVariableExplanationTranslationKeys().keySet().stream().sorted().forEach(key -> {
            String value = VariableRegistry.getInstance().getSingletonVariableExplanationTranslationKeys().get(key);
            TConfigEntryCategory unique = new TConfigEntryCategory(key).addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)value, (int)200, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
            variables.add((TConfigEntry)unique);
        });
        TConfigEntryCategory methods = new TConfigEntryCategory("entity_model_features.config.functions");
        category.add((TConfigEntry)methods);
        methods.addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)"entity_model_features.config.functions.explain", (int)200, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
        MethodRegistry.getInstance().getMethodExplanationTranslationKeys().keySet().stream().sorted().forEach(key -> {
            String value = MethodRegistry.getInstance().getMethodExplanationTranslationKeys().get(key);
            TConfigEntryCategory method = new TConfigEntryCategory(key + "()").addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)value, (int)200, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
            methods.add((TConfigEntry)method);
        });
        return category;
    }

    private TConfigEntryCategory getModelSettings() {
        TConfigEntryCategory category = new TConfigEntryCategory("entity_model_features.config.models");
        category.addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)"entity_model_features.config.models_text", (int)200, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
        EMFManager.getInstance().cache_LayersByModelName.keySet().stream().sorted().forEach(mapData -> {
            LayerDefinition vanilla;
            ModelLayerLocation layer = (ModelLayerLocation)EMFManager.getInstance().cache_LayersByModelName.get(mapData);
            if (layer != null && (vanilla = (LayerDefinition)Minecraft.m_91087_().m_167973_().f_171099_.get(layer)) != null) {
                String namespace = "minecraft".equals(mapData.getNamespace()) ? "" : mapData.getNamespace() + ":";
                String fileName = namespace + mapData.getfileName();
                TConfigEntryCategory model = new TConfigEntryCategory(fileName + ".jem");
                category.add((TConfigEntry)model);
                model.add(new TConfigEntry[]{new TConfigEntryBoolean("entity_model_features.config.models.enabled", "entity_model_features.config.models.enabled.tooltip", () -> !this.modelsNamesDisabled.contains((Object)fileName), value -> {
                    if (value.booleanValue()) {
                        this.modelsNamesDisabled.remove((Object)fileName);
                    } else {
                        this.modelsNamesDisabled.add((Object)fileName);
                    }
                }, true), new TConfigEntryCategory("entity_model_features.config.models.part_names").addAll(this.getmappings(mapData.getMapId())), this.getExport((OptifineMobNameForFileAndEMFMapId)mapData, layer)});
                model.addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)("assets/" + mapData.getNamespace() + "/optifine/cem/" + mapData.getfileName() + ".jem\nassets/" + mapData.getNamespace() + "/emf/cem/" + mapData.getfileName() + ".jem\n"), (int)100, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
            }
        });
        category.addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)"entity_model_features.config.models.arrows", (int)200, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
        category.addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)"entity_model_features.config.models.cape", (int)200, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
        return category;
    }

    @NotNull
    private TConfigEntry getExport(OptifineMobNameForFileAndEMFMapId key, ModelLayerLocation layer) {
        TConfigEntryText.TwoLines export;
        try {
            Objects.requireNonNull(key.getMapId());
            Objects.requireNonNull((LayerDefinition)Minecraft.m_91087_().m_167973_().f_171099_.get(layer));
            export = new TConfigEntryCustomButton("entity_model_features.config.models.export", "entity_model_features.config.models.export.tooltip", button -> {
                ModelPrintMode old = this.modelExportMode;
                this.modelExportMode = ModelPrintMode.ALL_LOG_AND_JEM;
                try {
                    EMFOptiFinePartNameMappings.getMapOf(key.getMapId(), ((LayerDefinition)Minecraft.m_91087_().m_167973_().f_171099_.get(layer)).m_171564_(), false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.modelExportMode = old;
                button.f_93623_ = false;
                button.m_93666_(ETFVersionDifferenceHandler.getTextFromTranslation((String)"entity_model_features.config.models.export.success"));
            });
        }
        catch (Exception e) {
            export = new TConfigEntryText.TwoLines("entity_model_features.config.models.export.fail", e.getMessage());
        }
        return export;
    }

    private Collection<TConfigEntry> getmappings(String mapKey) {
        Map<String, String> map;
        ArrayList<TConfigEntry> list = new ArrayList<TConfigEntry>();
        if (EMFOptiFinePartNameMappings.OPTIFINE_MODEL_MAP_CACHE.containsKey(mapKey)) {
            list.add((TConfigEntry)new TConfigEntryText("entity_model_features.config.variable_explanation.optifine_parts"));
            list.add((TConfigEntry)new TConfigEntryText("\\/"));
            map = EMFOptiFinePartNameMappings.OPTIFINE_MODEL_MAP_CACHE.get(mapKey);
        } else {
            list.add((TConfigEntry)new TConfigEntryText("entity_model_features.config.variable_explanation.unknown_parts"));
            list.add((TConfigEntry)new TConfigEntryText("\\/"));
            map = EMFOptiFinePartNameMappings.UNKNOWN_MODEL_MAP_CACHE.get(mapKey);
        }
        if (map == null) {
            return List.of();
        }
        for (String entry : map.keySet()) {
            list.add((TConfigEntry)new TConfigEntryText(entry));
        }
        return list;
    }

    private TConfigEntryCategory getEntitySettings() {
        TConfigEntryCategory category = new TConfigEntryCategory("config.entity_features.per_entity_settings");
        try {
            Registry.f_122826_.forEach(entityType -> {
                String translationKey = entityType.m_20675_();
                TConfigEntryCategory entityCategory = new TConfigEntryCategory(translationKey);
                this.addEntityConfigs(entityCategory, translationKey);
                category.add((TConfigEntry)entityCategory);
            });
            BlockEntityRenderers.f_173587_.keySet().forEach(entityType -> {
                String translationKey = ETFApi.getBlockEntityTypeToTranslationKey((BlockEntityType)entityType);
                TConfigEntryCategory entityCategory = new TConfigEntryCategory(translationKey);
                this.addEntityConfigs(entityCategory, translationKey);
                category.add((TConfigEntry)entityCategory);
            });
        }
        catch (Exception var4) {
            var4.printStackTrace();
        }
        return category;
    }

    private void addEntityConfigs(TConfigEntryCategory entityCategory, String translationKey) {
        TConfigEntryCategory category = new TConfigEntryCategory("config.entity_features.models_main");
        entityCategory.add((TConfigEntry)category);
        category.add(new TConfigEntry[]{new TConfigEntryEnumSlider("entity_model_features.config.render", "entity_model_features.config.render.tooltip", () -> (RenderModeChoice)this.entityRenderModeOverrides.getNullable(translationKey), layer -> this.entityRenderModeOverrides.putNullable(translationKey, (Enum)layer), null, RenderModeChoice.class), new TConfigEntryEnumButton("entity_model_features.config.vanilla_render", "entity_model_features.config.vanilla_render.tooltip", () -> (VanillaModelRenderMode)this.entityVanillaHologramOverrides.getNullable(translationKey), layer -> this.entityVanillaHologramOverrides.putNullable(translationKey, (Enum)layer), null, VanillaModelRenderMode.class), new TConfigEntryEnumButton("entity_model_features.config.physics", "entity_model_features.config.physics.tooltip", () -> (PhysicsModCompatChoice)this.entityPhysicsModPatchOverrides.getNullable(translationKey), layer -> this.entityPhysicsModPatchOverrides.putNullable(translationKey, (Enum)layer), null, PhysicsModCompatChoice.class)});
    }

    public ResourceLocation getModIcon() {
        return new ResourceLocation("entity_model_features", "textures/gui/icon.png");
    }

    public static enum RenderModeChoice {
        NORMAL((Component)Component.m_237115_((String)"entity_model_features.config.render.normal")),
        GREEN((Component)Component.m_237115_((String)"entity_model_features.config.render.green")),
        LINES_AND_TEXTURE((Component)Component.m_237115_((String)"entity_model_features.config.render.lines_texture")),
        LINES_AND_TEXTURE_FLASH((Component)Component.m_237115_((String)"entity_model_features.config.render.lines_texture_flash")),
        LINES((Component)Component.m_237115_((String)"entity_model_features.config.render.lines")),
        NONE((Component)Component.m_237115_((String)"entity_model_features.config.render.none"));

        private final String text;

        private RenderModeChoice(Component text) {
            this.text = text.getString();
        }

        public String toString() {
            return this.text;
        }
    }

    public static enum VanillaModelRenderMode {
        OFF(CommonComponents.f_130654_),
        NORMAL((Component)Component.m_237115_((String)"entity_model_features.config.vanilla_render.normal")),
        OFFSET((Component)Component.m_237115_((String)"entity_model_features.config.vanilla_render.offset"));

        private final Component text;

        private VanillaModelRenderMode(Component text) {
            this.text = text;
        }

        public String toString() {
            return this.text.getString();
        }
    }

    public static enum ModelPrintMode {
        NONE(CommonComponents.f_130654_),
        LOG_ONLY((Component)Component.m_237115_((String)"entity_model_features.config.print_mode.log")),
        LOG_AND_JEM((Component)Component.m_237115_((String)"entity_model_features.config.print_mode.log_jem")),
        ALL_LOG_ONLY((Component)Component.m_237115_((String)"entity_model_features.config.print_mode.all_log")),
        ALL_LOG_AND_JEM((Component)Component.m_237115_((String)"entity_model_features.config.print_mode.all_log_jem"));

        private final Component text;

        private ModelPrintMode(Component text) {
            this.text = text;
        }

        public boolean doesJems() {
            return this == LOG_AND_JEM || this == ALL_LOG_AND_JEM;
        }

        public boolean doesAll() {
            return this == ALL_LOG_ONLY || this == ALL_LOG_AND_JEM;
        }

        public boolean doesLog() {
            return this != NONE;
        }

        public String toString() {
            return this.text.getString();
        }
    }

    public static enum PhysicsModCompatChoice {
        OFF(CommonComponents.f_130654_),
        VANILLA((Component)Component.m_237115_((String)"entity_model_features.config.physics.1")),
        CUSTOM((Component)Component.m_237115_((String)"entity_model_features.config.physics.2"));

        private final Component text;

        private PhysicsModCompatChoice(Component text) {
            this.text = text;
        }

        public String toString() {
            return this.text.getString();
        }
    }
}

