/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import org.jetbrains.annotations.Nullable;
import traben.entity_model_features.EMFVersionDifferenceManager;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.mixin.accessor.MinecraftClientAccessor;
import traben.entity_model_features.mixin.accessor.ModelPartAccessor;
import traben.entity_model_features.models.EMFModelPartMutable;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.EMFAnimationVariableSuppliers;
import traben.entity_model_features.models.animation.EMFDefaultModelVariable;
import traben.entity_model_features.models.jem_objects.EMFJemData;
import traben.entity_model_features.models.jem_objects.EMFPartData;
import traben.entity_model_features.utils.EMFOptiFinePartNameMappings;
import traben.entity_model_features.utils.EMFUtils;
import traben.entity_texture_features.ETFApi;
import traben.entity_texture_features.config.ETFConfig;

public class EMFManager {
    private static final Object2ObjectOpenHashMap<String, String> map_MultiMobVariantMap = new Object2ObjectOpenHashMap<String, String>(){
        {
            this.put("shulker_b", "shulker_box");
        }
    };
    public final boolean physicsModInstalled;
    private static EMFManager self = null;
    private final Object2ObjectOpenHashMap<String, EMFJemData> cache_JemDataByFileName = new Object2ObjectOpenHashMap();
    private final Object2IntOpenHashMap<String> cache_AmountOfMobNameAlreadyDone = new Object2IntOpenHashMap();
    private final Object2ObjectOpenHashMap<String, EMFAnimationExecutor> cache_EntityNameToAnimationExecutable = new Object2ObjectOpenHashMap();
    private final Object2ObjectOpenHashMap<String, EMFModelPartMutable> cache_JemNameToCannonModelRoot = new Object2ObjectOpenHashMap();
    private final Object2ObjectOpenHashMap<String, ModelPart> cache_JemNameToVanillaModelRoot = new Object2ObjectOpenHashMap();
    private final Object2BooleanOpenHashMap<String> cache_JemNameDoesHaveVariants = new Object2BooleanOpenHashMap<String>(){
        {
            this.defaultReturnValue(false);
        }
    };
    private final Object2BooleanOpenHashMap<UUID> cache_UUIDDoUpdating = new Object2BooleanOpenHashMap<UUID>(){
        {
            this.defaultReturnValue(true);
        }
    };
    private final Object2IntOpenHashMap<UUIDAndMobTypeKey> cache_UUIDAndTypeToCurrentVariantInt = new Object2IntOpenHashMap<UUIDAndMobTypeKey>(){
        {
            this.defaultReturnValue(0);
        }
    };
    public final Object2ObjectOpenHashMap<String, ETFApi.ETFRandomTexturePropertyInstance> cache_mobJemNameToPropertyTester = new Object2ObjectOpenHashMap();
    public final boolean irisInstalled;
    private boolean traderLlamaHappened = false;
    public boolean isAnimationValidationPhase = false;

    private EMFManager() {
        this.physicsModInstalled = EMFVersionDifferenceManager.isThisModLoaded("physicsmod");
        this.irisInstalled = EMFVersionDifferenceManager.isThisModLoaded("iris") || EMFVersionDifferenceManager.isThisModLoaded("oculus");
    }

    public static EMFManager getInstance() {
        if (self == null) {
            self = new EMFManager();
        }
        return self;
    }

    public static void resetInstance() {
        EMFUtils.EMFModMessage("Clearing EMF data.");
        EMFOptiFinePartNameMappings.UNKNOWN_MODEL_MAP_CACHE.clear();
        self = new EMFManager();
    }

    public static ModelPart traverseRootForChildOrNull(ModelPart root, String nameOfModelToFind) {
        if (root.m_233562_(nameOfModelToFind)) {
            return root.m_171324_(nameOfModelToFind);
        }
        for (ModelPart part : ((ModelPartAccessor)root).getChildren().values()) {
            ModelPart found = EMFManager.traverseRootForChildOrNull(part, nameOfModelToFind);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public static String getTypeName(Entity entity) {
        Object forReturn = Registry.f_122826_.m_7981_((Object)entity.m_6095_()).toString().replace("minecraft:", "");
        if (((String)forReturn).contains(":")) {
            forReturn = "modded/" + ((String)forReturn).replaceFirst(":", "/");
        }
        if (entity instanceof Pufferfish) {
            Pufferfish puffer = (Pufferfish)entity;
            forReturn = "puffer_fish_" + (switch (puffer.m_29631_()) {
                case 0 -> "small";
                case 1 -> "medium";
                default -> "big";
            });
        } else if (entity instanceof TropicalFish) {
            TropicalFish fish = (TropicalFish)entity;
            forReturn = fish.m_30045_() == 0 ? "tropical_fish_a" : "tropical_fish_b";
        } else if (entity instanceof EnderDragon) {
            forReturn = "dragon";
        }
        return forReturn;
    }

    @Nullable
    public static EMFJemData getJemData(String jemFileName, String rawMobName) {
        EMFJemData emfJemData = EMFManager.getJemDataWithDirectory("emf/cem/" + jemFileName);
        if (emfJemData != null) {
            return emfJemData;
        }
        emfJemData = EMFManager.getJemDataWithDirectory("emf/cem/" + rawMobName + "/" + jemFileName);
        if (emfJemData != null) {
            return emfJemData;
        }
        emfJemData = EMFManager.getJemDataWithDirectory("optifine/cem/" + jemFileName);
        if (emfJemData != null) {
            return emfJemData;
        }
        emfJemData = EMFManager.getJemDataWithDirectory("optifine/cem/" + rawMobName + "/" + jemFileName);
        return emfJemData;
    }

    @Nullable
    private static EMFJemData getJemDataWithDirectory(String pathOfJem) {
        if (EMFManager.getInstance().cache_JemDataByFileName.containsKey((Object)pathOfJem)) {
            return (EMFJemData)EMFManager.getInstance().cache_JemDataByFileName.get((Object)pathOfJem);
        }
        try {
            Optional res = Minecraft.m_91087_().m_91098_().m_213713_(new ResourceLocation(pathOfJem));
            if (res.isEmpty()) {
                if (EMFConfig.getConfig().printModelCreationInfoToLog) {
                    EMFUtils.EMFModMessage(".jem read failed " + pathOfJem + " does not exist", false);
                }
                return null;
            }
            if (EMFConfig.getConfig().printModelCreationInfoToLog) {
                EMFUtils.EMFModMessage(".jem read success " + pathOfJem + " exists", false);
            }
            Resource jemResource = (Resource)res.get();
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            BufferedReader reader = new BufferedReader(new InputStreamReader(jemResource.m_215507_()));
            EMFJemData jem = (EMFJemData)gson.fromJson((Reader)reader, EMFJemData.class);
            reader.close();
            jem.sendFileName(pathOfJem);
            jem.prepare();
            EMFManager.getInstance().cache_JemDataByFileName.put((Object)pathOfJem, (Object)jem);
            return jem;
        }
        catch (FileNotFoundException | ResourceLocationException e) {
            if (EMFConfig.getConfig().printModelCreationInfoToLog) {
                EMFUtils.EMFModMessage(".jem failed to load " + (Exception)e, false);
            }
        }
        catch (Exception e) {
            EMFUtils.EMFModMessage(".jem failed to load " + e, false);
            e.printStackTrace();
        }
        return null;
    }

    public ModelPart injectIntoModelRootGetter(ModelLayerLocation layer, ModelPart root) {
        String jemName;
        EMFJemData jemData;
        boolean printing = EMFConfig.getConfig().printModelCreationInfoToLog;
        Object mobModelName = layer.m_171123_().m_135815_();
        if (!"main".equals(layer.m_171124_())) {
            mobModelName = (String)mobModelName + "_" + layer.m_171124_();
        }
        if (!"minecraft".equals(layer.m_171123_().m_135827_())) {
            mobModelName = "modded/" + layer.m_171123_().m_135827_() + "/" + (String)mobModelName;
        } else {
            if (((String)mobModelName).contains("pufferfish")) {
                mobModelName = ((String)mobModelName).replace("pufferfish", "puffer_fish");
            }
            switch (mobModelName) {
                case "tropical_fish_large": {
                    mobModelName = "tropical_fish_b";
                    break;
                }
                case "tropical_fish_small": {
                    mobModelName = "tropical_fish_a";
                    break;
                }
                case "tropical_fish_large_pattern": {
                    mobModelName = "tropical_fish_pattern_b";
                    break;
                }
                case "tropical_fish_small_pattern": {
                    mobModelName = "tropical_fish_pattern_a";
                    break;
                }
                case "trader_llama": {
                    this.traderLlamaHappened = true;
                    break;
                }
                case "llama": {
                    this.traderLlamaHappened = false;
                    break;
                }
                case "llama_decor": {
                    mobModelName = this.traderLlamaHappened ? "trader_llama_decor" : "llama_decor";
                    break;
                }
                case "ender_dragon": {
                    mobModelName = "dragon";
                    break;
                }
                case "dragon_skull": {
                    mobModelName = "head_dragon";
                    break;
                }
                case "player_head": {
                    mobModelName = "head_player";
                    break;
                }
                case "skeleton_skull": {
                    mobModelName = "head_skeleton";
                    break;
                }
                case "wither_skeleton_skull": {
                    mobModelName = "head_wither_skeleton";
                    break;
                }
                case "zombie_head": {
                    mobModelName = "head_zombie";
                    break;
                }
                case "creeper_head": {
                    mobModelName = "head_creeper";
                    break;
                }
                case "piglin_head": {
                    mobModelName = "head_piglin";
                    break;
                }
                case "creeper_armor": {
                    mobModelName = "creeper_charge";
                    break;
                }
                case "sheep_fur": {
                    mobModelName = "sheep_wool";
                    break;
                }
                default: {
                    if (this.cache_AmountOfMobNameAlreadyDone.containsKey(mobModelName)) {
                        int amount = this.cache_AmountOfMobNameAlreadyDone.getInt(mobModelName);
                        this.cache_AmountOfMobNameAlreadyDone.put(mobModelName, ++amount);
                        String modelVariantAlias = (String)mobModelName + "_" + (Serializable)(amount > 0 && amount < 27 ? String.valueOf((char)(amount + 97 - 1)) : Integer.valueOf(amount));
                        mobModelName = (String)map_MultiMobVariantMap.getOrDefault((Object)modelVariantAlias, (Object)modelVariantAlias);
                        break;
                    }
                    EMFManager.getInstance().cache_AmountOfMobNameAlreadyDone.put(mobModelName, 1);
                }
            }
        }
        if (printing) {
            System.out.println(" > EMF try to find a model for: " + (String)mobModelName);
        }
        if (EMFOptiFinePartNameMappings.getMapOf((String)mobModelName).isEmpty()) {
            EMFOptiFinePartNameMappings.createMapForModdedOrUnknownEntityModel(root, (String)mobModelName);
        }
        if (printing) {
            System.out.println(" >> EMF trying to find: optifine/cem/" + (String)mobModelName + ".jem");
        }
        if ((jemData = EMFManager.getJemData(jemName = (String)mobModelName + ".jem", (String)mobModelName)) != null) {
            EMFModelPartMutable part = this.getEMFRootModelFromJem(jemData, root);
            this.cache_JemNameToCannonModelRoot.put(mobModelName, (Object)part);
            part.setPartAsTopLevelRoot();
            this.cache_JemNameToVanillaModelRoot.put(mobModelName, (Object)root);
            if (Minecraft.m_91087_().m_91098_().m_213713_(new ResourceLocation("optifine/cem/" + (String)mobModelName + ".properties")).isPresent()) {
                this.cache_JemNameDoesHaveVariants.put(mobModelName, true);
            }
            return part;
        }
        if (printing) {
            System.out.println(" >> EMF mob does not have a .jem file");
        }
        if (printing) {
            System.out.println(" > Vanilla model used for: " + (String)mobModelName);
        }
        return root;
    }

    private EMFModelPartMutable getEMFRootModelFromJem(EMFJemData jemData, ModelPart vanillaRoot) {
        return this.getEMFRootModelFromJem(jemData, vanillaRoot, 0);
    }

    private EMFModelPartMutable getEMFRootModelFromJem(EMFJemData jemData, ModelPart vanillaRoot, int variantNumber) {
        HashMap<String, ModelPart> rootChildren = new HashMap<String, ModelPart>();
        boolean printing = EMFConfig.getConfig().printModelCreationInfoToLog;
        for (EMFPartData partData : jemData.models) {
            if (partData != null && partData.part != null) {
                ModelPart oldPart = EMFManager.traverseRootForChildOrNull(vanillaRoot, partData.part);
                EMFModelPartMutable newPart = new EMFModelPartMutable(partData, variantNumber);
                if (oldPart != null) {
                    newPart.applyDefaultModelRotates(oldPart.m_233566_());
                    this.iterateChildTransformCopy(newPart, oldPart);
                }
                if (printing) {
                    System.out.println(" >>> EMF part made: " + partData.toString(false));
                }
                rootChildren.put(partData.part, newPart);
                continue;
            }
            System.out.println("no part definition");
        }
        EMFModelPartMutable emfRootModelPart = new EMFModelPartMutable(rootChildren, variantNumber, jemData);
        if (printing) {
            System.out.println(" > EMF model returned");
        }
        this.setupAnimationsFromJemToModel(jemData, emfRootModelPart);
        if (vanillaRoot.m_233562_("root")) {
            if (!emfRootModelPart.m_233562_("root")) {
                ModelPart subRoot = vanillaRoot.m_171324_("root");
                if (subRoot.f_104200_ != 0.0f || subRoot.f_104201_ != 0.0f || subRoot.f_104202_ != 0.0f || subRoot.f_104203_ != 0.0f || subRoot.f_104204_ != 0.0f || subRoot.f_104205_ != 0.0f || subRoot.f_233553_ != 0.0f || subRoot.f_233554_ != 0.0f || subRoot.f_233555_ != 0.0f) {
                    emfRootModelPart.m_171322_(subRoot.m_171308_());
                    emfRootModelPart.m_233560_(subRoot.m_233566_());
                }
                emfRootModelPart = new EMFModelPartMutable(Map.of("root", emfRootModelPart), variantNumber, jemData);
            }
        } else if (emfRootModelPart.m_233562_("root")) {
            emfRootModelPart = (EMFModelPartMutable)emfRootModelPart.m_171324_("root");
        }
        if (EMFConfig.getConfig().attemptToCopyVanillaModelIntoMissingModelPart) {
            emfRootModelPart.mergeInVanillaWhereRequired(vanillaRoot);
        }
        return emfRootModelPart;
    }

    private void iterateChildTransformCopy(EMFModelPartMutable newPart, ModelPart oldPart) {
        for (String emfChildId : newPart.getChildrenEMF().keySet()) {
            if (!oldPart.m_233562_(emfChildId)) continue;
            EMFModelPartMutable newNewPart = (EMFModelPartMutable)newPart.getChildrenEMF().get(emfChildId);
            ModelPart oldOldPart = oldPart.m_171324_(emfChildId);
            newNewPart.applyDefaultModelRotates(oldOldPart.m_233566_());
            this.iterateChildTransformCopy(newNewPart, oldOldPart);
        }
    }

    private void setupAnimationsFromJemToModel(EMFJemData jemData, EMFModelPartMutable emfRootModelPart) {
        boolean printing = EMFConfig.getConfig().printModelCreationInfoToLog;
        Object2ObjectOpenHashMap allPartByName = new Object2ObjectOpenHashMap();
        allPartByName.put((Object)"root", (Object)emfRootModelPart);
        allPartByName.putAll(emfRootModelPart.getAllChildPartsAsMap());
        Object2ObjectLinkedOpenHashMap emfAnimations = new Object2ObjectLinkedOpenHashMap();
        EMFAnimationVariableSuppliers variableSuppliers = new EMFAnimationVariableSuppliers();
        if (printing) {
            System.out.println(" > finalAnimationsForModel =");
            jemData.finalAnimationsForModel.forEach((key, expression) -> System.out.println(" >> " + key + " = " + expression));
        }
        jemData.finalAnimationsForModel.forEach((animKey, animationExpression) -> {
            if (EMFConfig.getConfig().printModelCreationInfoToLog) {
                EMFUtils.EMFModMessage("parsing animation value: [" + animKey + "]");
            }
            String modelId = animKey.split("\\.")[0];
            String modelVariable = animKey.split("\\.")[1];
            EMFDefaultModelVariable thisVariable = EMFDefaultModelVariable.get(modelVariable);
            EMFModelPartMutable thisPart = (EMFModelPartMutable)((Object)((Object)allPartByName.get((Object)modelId)));
            EMFAnimation thisCalculator = thisPart != null ? new EMFAnimation(thisPart, thisVariable, (String)animKey, (String)animationExpression, jemData.fileName, variableSuppliers) : new EMFAnimation(null, null, (String)animKey, (String)animationExpression, jemData.fileName, variableSuppliers);
            emfAnimations.put(animKey, (Object)thisCalculator);
        });
        LinkedList<EMFAnimation> orderedAnimations = new LinkedList<EMFAnimation>();
        this.isAnimationValidationPhase = true;
        emfAnimations.forEach((key, anim) -> {
            if (anim != null) {
                anim.initExpression((Object2ObjectLinkedOpenHashMap<String, EMFAnimation>)emfAnimations, (Object2ObjectOpenHashMap<String, EMFModelPartMutable>)allPartByName);
                if (anim.isValid()) {
                    orderedAnimations.add((EMFAnimation)anim);
                } else {
                    EMFUtils.EMFModWarn("animations was invalid: " + anim.animKey + " = " + anim.expressionString);
                }
            }
        });
        this.isAnimationValidationPhase = false;
        EMFAnimationExecutor executor = new EMFAnimationExecutor(variableSuppliers, orderedAnimations);
        this.cache_EntityNameToAnimationExecutable.put((Object)jemData.mobName, (Object)executor);
    }

    public boolean isKnownJemName(String nameOfJem) {
        return this.cache_JemNameToCannonModelRoot.containsKey((Object)nameOfJem);
    }

    public void preRenderEMFActions(String modelName, Entity entity, MultiBufferSource provider, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        EMFModelPartMutable.currentlyHeldProvider = provider;
        EMFModelPartMutable.currentlyHeldEntity = entity;
        int suffix = this.cache_UUIDAndTypeToCurrentVariantInt.getInt((Object)new UUIDAndMobTypeKey(entity.m_20148_(), entity.m_6095_()));
        if (suffix > 1) {
            modelName = (String)modelName + suffix;
        }
        if (this.cache_EntityNameToAnimationExecutable.containsKey(modelName)) {
            ((EMFAnimationExecutor)this.cache_EntityNameToAnimationExecutable.get(modelName)).executeAnimations(entity, limbAngle, limbDistance, animationProgress, headYaw, headPitch);
        }
    }

    @Nullable
    public ResourceLocation getRootModelTextureOverride(String modelId) {
        EMFModelPartMutable modelRoot = (EMFModelPartMutable)((Object)this.cache_JemNameToCannonModelRoot.get((Object)modelId));
        if (modelRoot != null) {
            return modelRoot.textureOverride;
        }
        return null;
    }

    public void doVariantCheckFor(String mobName, Entity entity) {
        if (this.cache_JemNameDoesHaveVariants.getBoolean((Object)mobName) && this.cache_UUIDDoUpdating.getBoolean((Object)entity.m_20148_()) && ETFApi.getETFConfigObject().textureUpdateFrequency_V2 != ETFConfig.UpdateFrequency.Never) {
            UUIDAndMobTypeKey key = new UUIDAndMobTypeKey(entity.m_20148_(), entity.m_6095_());
            long randomizer = (long)ETFApi.getETFConfigObject().textureUpdateFrequency_V2.getDelay() * 20L;
            if (System.currentTimeMillis() % randomizer == (long)Math.abs(entity.m_20148_().hashCode()) % randomizer) {
                ETFApi.ETFRandomTexturePropertyInstance emfProperty;
                if (!this.cache_mobJemNameToPropertyTester.containsKey((Object)mobName)) {
                    ResourceLocation propertyID = new ResourceLocation("optifine/cem/" + mobName + ".properties");
                    if (Minecraft.m_91087_().m_91098_().m_213713_(propertyID).isPresent()) {
                        ETFApi.ETFRandomTexturePropertyInstance emfTester = ETFApi.readRandomPropertiesFileAndReturnTestingObject2((ResourceLocation)propertyID, (String)"models");
                        this.cache_mobJemNameToPropertyTester.put((Object)mobName, (Object)emfTester);
                    } else {
                        EMFUtils.EMFModWarn("no property" + propertyID);
                        this.cache_JemNameDoesHaveVariants.put((Object)mobName, false);
                        return;
                    }
                }
                if ((emfProperty = (ETFApi.ETFRandomTexturePropertyInstance)this.cache_mobJemNameToPropertyTester.get((Object)mobName)) != null) {
                    int suffix = emfProperty.getSuffixForEntity(entity, this.cache_UUIDDoUpdating.containsKey((Object)entity.m_20148_()), this.cache_UUIDDoUpdating);
                    EMFModelPartMutable cannonicalRoot = (EMFModelPartMutable)((Object)this.cache_JemNameToCannonModelRoot.get((Object)mobName));
                    if (suffix > 1) {
                        if (!cannonicalRoot.allKnownStateVariants.containsKey(suffix)) {
                            String jemName = mobName + suffix + ".jem";
                            System.out.println(" >> first time load of : " + jemName);
                            EMFJemData jemData = EMFManager.getJemData(jemName, mobName);
                            if (jemData != null) {
                                ModelPart vanillaRoot = (ModelPart)this.cache_JemNameToVanillaModelRoot.get((Object)mobName);
                                if (vanillaRoot != null) {
                                    EMFModelPartMutable variantRoot = this.getEMFRootModelFromJem(jemData, vanillaRoot, suffix);
                                    cannonicalRoot.mergePartVariant(suffix, variantRoot);
                                    this.setupAnimationsFromJemToModel(jemData, cannonicalRoot);
                                }
                            } else {
                                System.out.println("invalid jem: " + jemName);
                            }
                        }
                        cannonicalRoot.setVariantStateTo(suffix);
                        this.cache_UUIDAndTypeToCurrentVariantInt.put((Object)key, suffix);
                    } else {
                        cannonicalRoot.setVariantStateTo(0);
                        this.cache_UUIDAndTypeToCurrentVariantInt.put((Object)key, 0);
                    }
                }
            } else {
                EMFModelPartMutable cannonicalRoot = (EMFModelPartMutable)((Object)this.cache_JemNameToCannonModelRoot.get((Object)mobName));
                cannonicalRoot.setVariantStateTo(this.cache_UUIDAndTypeToCurrentVariantInt.getInt((Object)key));
            }
        }
    }

    public void tryRenderVanillaRoot(String modelId, PoseStack matrixStack, VertexConsumer vertexConsumer, int light, int overlay) {
        ModelPart vanillaRoot = (ModelPart)this.cache_JemNameToVanillaModelRoot.get((Object)modelId);
        if (vanillaRoot != null) {
            matrixStack.m_85836_();
            if (EMFConfig.getConfig().vanillaModelRenderMode == EMFConfig.VanillaModelRenderMode.Positon_offset) {
                matrixStack.m_85837_(1.0, 0.0, 0.0);
            }
            vanillaRoot.m_104306_(matrixStack, vertexConsumer, light, overlay, 1.0f, 0.5f, 0.5f, 0.5f);
            matrixStack.m_85849_();
        }
    }

    public void tryRenderVanillaRootNormally(String modelId, PoseStack matrixStack, VertexConsumer vertexConsumer, int light, int overlay) {
        ModelPart vanillaRoot = (ModelPart)this.cache_JemNameToVanillaModelRoot.get((Object)modelId);
        if (vanillaRoot != null) {
            vanillaRoot.m_104306_(matrixStack, vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public static class EMFAnimationExecutor {
        private final EMFAnimationVariableSuppliers variableSuppliers;
        private final LinkedList<EMFAnimation> orderedAnimations;

        EMFAnimationExecutor(EMFAnimationVariableSuppliers variableSuppliers, LinkedList<EMFAnimation> orderedAnimations) {
            this.variableSuppliers = variableSuppliers;
            this.orderedAnimations = orderedAnimations;
        }

        public void executeAnimations(Entity entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
            if (headYaw >= 180.0f || headYaw <= -180.0f) {
                boolean isNegative = headYaw < 0.0f;
                float newHeadYaw = Math.abs(headYaw) % 360.0f;
                if (newHeadYaw >= 180.0f) {
                    newHeadYaw = 180.0f - (newHeadYaw - 180.0f);
                    isNegative = !isNegative;
                }
                headYaw = isNegative ? -newHeadYaw : newHeadYaw;
            }
            this.variableSuppliers.entity = entity;
            this.variableSuppliers.limbAngle = limbAngle;
            this.variableSuppliers.limbDistance = limbDistance;
            this.variableSuppliers.headYaw = headYaw;
            this.variableSuppliers.headPitch = headPitch;
            this.variableSuppliers.tickDelta = Minecraft.m_91087_().m_91104_() ? ((MinecraftClientAccessor)Minecraft.m_91087_()).getPausedTickDelta() : Minecraft.m_91087_().m_91296_();
            this.variableSuppliers.animationProgress = this.alterAnimationProgress(animationProgress);
            for (EMFAnimation animation : this.orderedAnimations) {
                animation.calculateAndSet(this.variableSuppliers.entity);
            }
        }

        private float alterAnimationProgress(float animationProgress) {
            if (this.variableSuppliers.entity == null) {
                return animationProgress;
            }
            return (float)this.variableSuppliers.entity.f_19797_ + this.variableSuppliers.tickDelta;
        }
    }

    private record UUIDAndMobTypeKey(UUID uuid, EntityType<?> entityType) {
    }
}

