/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation.animation_math_parser;

import traben.entity_model_features.models.EMFModelPartMutable;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.EMFAnimationVariableSuppliers;
import traben.entity_model_features.models.animation.EMFDefaultModelVariable;
import traben.entity_model_features.models.animation.animation_math_parser.MathComponent;
import traben.entity_model_features.models.animation.animation_math_parser.MathConstant;
import traben.entity_model_features.models.animation.animation_math_parser.MathValue;
import traben.entity_model_features.utils.EMFUtils;

public class MathVariable
extends MathValue
implements MathComponent {
    private static final MathConstant TRUE_CONSTANT = new MathConstant(1.0f);
    private static final MathConstant FALSE_CONSTANT = new MathConstant(0.0f);
    private static final MathConstant PI_CONSTANT = new MathConstant((float)Math.PI);
    private static final MathConstant PI_NEGATIVE_CONSTANT = new MathConstant((float)Math.PI, true);
    final String variableName;
    public MathComponent optimizedAlternativeToThis = null;
    MathValue.ValueSupplier valueSupplier;
    private boolean invertBooleans = false;

    private MathVariable(String value, boolean isNegative, EMFAnimation calculationInstance) throws MathComponent.EMFMathException {
        super(isNegative, calculationInstance);
        this.variableName = value;
        if (value.startsWith("!")) {
            value = value.replaceFirst("!", "");
            this.invertBooleans = true;
        }
        EMFAnimationVariableSuppliers getter = calculationInstance.variableSuppliers;
        this.valueSupplier = switch (value) {
            case "limb_swing" -> getter::getLimbAngle;
            case "frame_time" -> getter::getFrameTime;
            case "limb_speed" -> getter::getLimbDistance;
            case "age" -> getter::getAge;
            case "head_pitch" -> getter::getHeadPitch;
            case "head_yaw" -> getter::getHeadYaw;
            case "swing_progress" -> getter::getSwingProgress;
            case "hurt_time" -> getter::getHurtTime;
            case "dimension" -> getter::getDimension;
            case "time" -> getter::getTime;
            case "player_pos_x" -> getter::getPlayerX;
            case "player_pos_y" -> getter::getPlayerY;
            case "player_pos_z" -> getter::getPlayerZ;
            case "pos_x" -> getter::getEntityX;
            case "pos_y" -> getter::getEntityY;
            case "pos_z" -> getter::getEntityZ;
            case "player_rot_x" -> getter::getPlayerRX;
            case "player_rot_y" -> getter::getPlayerRY;
            case "rot_x" -> getter::getEntityRX;
            case "rot_y" -> getter::getEntityRY;
            case "health" -> getter::getHealth;
            case "death_time" -> getter::getDeathTime;
            case "anger_time" -> getter::getAngerTime;
            case "max_health" -> getter::getMaxHealth;
            case "id" -> getter::getId;
            case "day_time" -> getter::getDayTime;
            case "day_count" -> getter::getDayCount;
            case "rule_index" -> getter::getRuleIndex;
            case "anger_time_start" -> getter::getAngerTimeStart;
            case "move_forward" -> getter::getMoveForward;
            case "move_strafing" -> getter::getMoveStrafe;
            case "is_climbing" -> this.getBooleanAsFloat(getter::isClimbing);
            case "is_child" -> this.getBooleanAsFloat(getter::isChild);
            case "is_in_water" -> this.getBooleanAsFloat(getter::isInWater);
            case "is_riding" -> this.getBooleanAsFloat(getter::isRiding);
            case "is_on_ground" -> this.getBooleanAsFloat(getter::isOnGround);
            case "is_burning" -> this.getBooleanAsFloat(getter::isBurning);
            case "is_alive" -> this.getBooleanAsFloat(getter::isAlive);
            case "is_glowing" -> this.getBooleanAsFloat(getter::isGlowing);
            case "is_aggressive" -> this.getBooleanAsFloat(getter::isAggressive);
            case "is_hurt" -> this.getBooleanAsFloat(getter::isHurt);
            case "is_in_hand" -> this.getBooleanAsFloat(getter::isInHand);
            case "is_in_item_frame" -> this.getBooleanAsFloat(getter::isInItemFrame);
            case "is_in_ground" -> this.getBooleanAsFloat(getter::isInGround);
            case "is_in_gui" -> this.getBooleanAsFloat(getter::isInGui);
            case "is_in_lava" -> this.getBooleanAsFloat(getter::isInLava);
            case "is_invisible" -> this.getBooleanAsFloat(getter::isInvisible);
            case "is_on_head" -> this.getBooleanAsFloat(getter::isOnHead);
            case "is_on_shoulder" -> this.getBooleanAsFloat(getter::isOnShoulder);
            case "is_ridden" -> this.getBooleanAsFloat(getter::isRidden);
            case "is_sitting" -> this.getBooleanAsFloat(getter::isSitting);
            case "is_sneaking" -> this.getBooleanAsFloat(getter::isSneaking);
            case "is_sprinting" -> this.getBooleanAsFloat(getter::isSprinting);
            case "is_tamed" -> this.getBooleanAsFloat(getter::isTamed);
            case "is_wet" -> this.getBooleanAsFloat(getter::isWet);
            default -> this.getVariable(value, getter);
        };
    }

    public static MathComponent getOptimizedVariable(String value, boolean isNegative, EMFAnimation calculationInstance) throws MathComponent.EMFMathException {
        MathVariable method = new MathVariable(value, isNegative, calculationInstance);
        if (method.optimizedAlternativeToThis == null) {
            return method;
        }
        return method.optimizedAlternativeToThis;
    }

    private MathValue.ValueSupplier getVariable(String variableKey, EMFAnimationVariableSuppliers getter) throws MathComponent.EMFMathException {
        switch (variableKey) {
            case "pi": {
                this.optimizedAlternativeToThis = this.isNegative ? PI_NEGATIVE_CONSTANT : PI_CONSTANT;
                return () -> (float)Math.PI;
            }
            case "true": {
                float bool = this.invertBooleans ? 0.0f : 1.0f;
                this.optimizedAlternativeToThis = this.invertBooleans ? FALSE_CONSTANT : TRUE_CONSTANT;
                return () -> bool;
            }
            case "false": {
                float bool = this.invertBooleans ? 1.0f : 0.0f;
                this.optimizedAlternativeToThis = this.invertBooleans ? TRUE_CONSTANT : FALSE_CONSTANT;
                return () -> bool;
            }
        }
        if (variableKey.matches("[a-zA-Z0-9_]+\\.([trs][xyz]$|visible$|visible_boxes$)")) {
            String[] split = variableKey.split("\\.");
            String partName = split[0];
            EMFDefaultModelVariable partVariable = EMFDefaultModelVariable.get(split[1]);
            EMFModelPartMutable part = (EMFModelPartMutable)((Object)this.calculationInstance.allPartByName.get((Object)partName));
            if (partVariable != null && part != null) {
                return () -> partVariable.getFromMutableModel(part);
            }
            EMFUtils.EMFModError("no part variable found for: [" + variableKey + "] in [" + this.calculationInstance.modelName + "] + " + this.calculationInstance.allPartByName.keySet());
            return () -> 0.0f;
        }
        if (variableKey.matches("(var|varb)\\.\\w+")) {
            EMFAnimation variableCalculator = (EMFAnimation)this.calculationInstance.emfAnimationVariables.get((Object)variableKey);
            if (variableCalculator != null) {
                return () -> variableCalculator.getLastResultOnly(getter.getEntity());
            }
            EMFUtils.EMFModError("no variable animation found for: [" + variableKey + "] in [" + this.calculationInstance.modelName + "] + " + this.calculationInstance.emfAnimationVariables.keySet());
            return () -> 0.0f;
        }
        String s = "ERROR: could not identify EMF animation variable [" + variableKey + "] for [" + this.calculationInstance.animKey + "] in [" + this.calculationInstance.modelName + "].";
        System.out.println(s);
        throw new MathComponent.EMFMathException(s);
    }

    private MathValue.ValueSupplier getBooleanAsFloat(BoolSupplierPrimitive boolGetter) {
        return () -> {
            boolean value = this.invertBooleans != boolGetter.get();
            return value ? 1.0f : 0.0f;
        };
    }

    @Override
    public MathValue.ValueSupplier getSupplier() {
        return () -> this.valueSupplier.get();
    }

    public String toString() {
        return this.variableName + "=" + this.get();
    }

    private static interface BoolSupplierPrimitive {
        public boolean get();
    }
}

