/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.mixin.accessor.CuboidAccessor;
import traben.entity_model_features.mixin.accessor.ModelPartAccessor;
import traben.entity_model_features.models.jem_objects.EMFBoxData;
import traben.entity_model_features.models.jem_objects.EMFJemData;
import traben.entity_model_features.models.jem_objects.EMFPartData;
import traben.entity_model_features.utils.EMFManager;
import traben.entity_model_features.utils.EMFUtils;
import traben.entity_texture_features.ETFApi;

@OnlyIn(value=Dist.CLIENT)
public class EMFModelPartMutable
extends ModelPart {
    private static final ModelPart.Cube EMPTY_CUBOID = new ModelPart.Cube(0, 0, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, false, 0.0f, 0.0f){

        public void m_171332_(PoseStack.Pose entry, VertexConsumer vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        }
    };
    public final List<EMFCuboid> emfCuboids = new ArrayList<EMFCuboid>();
    public final Map<String, EMFModelPartMutable> emfChildren = new HashMap<String, EMFModelPartMutable>();
    public final EMFPartData selfModelData;
    public int currentModelVariantState = 0;
    public boolean isValidToRenderInThisState = true;
    public final Int2ObjectArrayMap<EMFModelState> allKnownStateVariants = new Int2ObjectArrayMap();
    public ResourceLocation textureOverride;
    private BufferBuilder MODIFIED_RENDER_BUFFER = null;
    private boolean isTopLevelModelRoot = false;
    public static MultiBufferSource currentlyHeldProvider = null;
    public static Entity currentlyHeldEntity = null;

    public EMFModelPartMutable(Map<String, ModelPart> children, int variantNumber, EMFJemData jemData) {
        super(List.of(), children);
        this.selfModelData = null;
        this.textureOverride = jemData.customTexture;
        this.allKnownStateVariants.put(variantNumber, (Object)this.getCurrentState());
    }

    public EMFModelPartMutable(EMFPartData emfPartData, int variantNumber) {
        super(EMFModelPartMutable.getCuboidsFromData(emfPartData), EMFModelPartMutable.getChildrenFromData(emfPartData, variantNumber));
        this.selfModelData = emfPartData;
        this.textureOverride = emfPartData.customTexture;
        this.f_233553_ = this.selfModelData.scale;
        this.f_233554_ = this.selfModelData.scale;
        this.f_233555_ = this.selfModelData.scale;
        this.f_104200_ = this.selfModelData.translate[0];
        this.f_104201_ = this.selfModelData.translate[1];
        this.f_104202_ = this.selfModelData.translate[2];
        this.f_104203_ = this.selfModelData.rotate[0];
        this.f_104204_ = this.selfModelData.rotate[1];
        this.f_104205_ = this.selfModelData.rotate[2];
        this.m_233560_(this.m_171308_());
        this.allKnownStateVariants.put(variantNumber, (Object)this.getCurrentState());
    }

    private static List<ModelPart.Cube> getCuboidsFromData(EMFPartData emfPartData) {
        return EMFModelPartMutable.createCuboidsFromBoxDataV3(emfPartData);
    }

    private static Map<String, ModelPart> getChildrenFromData(EMFPartData emfPartData, int variantNumber) {
        HashMap<String, ModelPart> emfChildren = new HashMap<String, ModelPart>();
        for (EMFPartData sub : emfPartData.submodels) {
            Object idForMap;
            Object object = idForMap = sub.part == null ? sub.id : sub.part;
            while (emfChildren.containsKey(idForMap)) {
                idForMap = (String)idForMap + "-";
            }
            if (EMFConfig.getConfig().printModelCreationInfoToLog) {
                System.out.println(" > > > > EMF sub part made: " + sub.toString(false));
            }
            emfChildren.put((String)idForMap, new EMFModelPartMutable(sub, variantNumber));
        }
        return emfChildren;
    }

    private static List<ModelPart.Cube> createCuboidsFromBoxDataV3(EMFPartData emfPartData) {
        LinkedList<ModelPart.Cube> emfCuboids = new LinkedList<ModelPart.Cube>();
        if (emfPartData.boxes.length > 0) {
            try {
                for (EMFBoxData box : emfPartData.boxes) {
                    EMFCuboid cube = box.textureOffset.length == 2 ? new EMFCuboid(emfPartData, box.textureOffset[0], box.textureOffset[1], box.coordinates[0], box.coordinates[1], box.coordinates[2], box.coordinates[3], box.coordinates[4], box.coordinates[5], box.sizeAdd, box.sizeAdd, box.sizeAdd, emfPartData.textureSize[0], emfPartData.textureSize[1], emfPartData.mirrorTexture.contains("u"), emfPartData.mirrorTexture.contains("v")) : new EMFCuboid(emfPartData, box.uvDown, box.uvUp, box.uvNorth, box.uvSouth, box.uvWest, box.uvEast, box.coordinates[0], box.coordinates[1], box.coordinates[2], box.coordinates[3], box.coordinates[4], box.coordinates[5], box.sizeAdd, box.sizeAdd, box.sizeAdd, emfPartData.textureSize[0], emfPartData.textureSize[1], emfPartData.mirrorTexture.contains("u"), emfPartData.mirrorTexture.contains("v"));
                    emfCuboids.add(cube);
                }
            }
            catch (Exception e) {
                EMFUtils.EMFModMessage("cuboid construction broke: " + e, false);
            }
        }
        return emfCuboids;
    }

    public void m_104306_(PoseStack matrices, VertexConsumer vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        if (this.isValidToRenderInThisState) {
            if (!this.isTopLevelModelRoot && this.textureOverride != null && EMFConfig.getConfig().textureOverrideMode != EMFConfig.TextureOverrideMode.OFF && light != 0xF000F1 && currentlyHeldEntity != null) {
                ResourceLocation texture = light == 0xF000F2 ? ETFApi.getCurrentETFEmissiveTextureOfEntityOrNull((Entity)currentlyHeldEntity, (ResourceLocation)this.textureOverride) : ETFApi.getCurrentETFVariantTextureOfEntity((Entity)currentlyHeldEntity, (ResourceLocation)this.textureOverride);
                if (texture != null) {
                    if (EMFManager.getInstance().irisInstalled && EMFConfig.getConfig().textureOverrideMode == EMFConfig.TextureOverrideMode.USE_IRIS_QUIRK_AND_DEFER_TO_EMF_CODE_OTHERWISE) {
                        MultiBufferSource.BufferSource vertexConsumers = Minecraft.m_91087_().m_91269_().m_110104_();
                        VertexConsumer newVertex = vertexConsumers.m_6299_(RenderType.m_110473_((ResourceLocation)ETFApi.getCurrentETFVariantTextureOfEntity((Entity)currentlyHeldEntity, (ResourceLocation)this.textureOverride)));
                        if (newVertex != null) {
                            this.renderToSuper(matrices, newVertex, light, overlay, red, green, blue, alpha);
                        }
                    } else {
                        try {
                            RenderType layer = RenderType.m_110473_((ResourceLocation)texture);
                            if (this.MODIFIED_RENDER_BUFFER == null) {
                                this.MODIFIED_RENDER_BUFFER = new BufferBuilder(layer.m_110507_());
                            }
                            this.MODIFIED_RENDER_BUFFER.m_166779_(layer.m_173186_(), layer.m_110508_());
                            this.renderToSuper(matrices, (VertexConsumer)this.MODIFIED_RENDER_BUFFER, light, overlay, red, green, blue, alpha);
                            layer.m_110412_(this.MODIFIED_RENDER_BUFFER, 0, 0, 0);
                            this.MODIFIED_RENDER_BUFFER.m_85729_();
                        }
                        catch (Exception exception) {}
                    }
                }
            } else {
                this.renderToSuper(matrices, vertices, light, overlay, red, green, blue, alpha);
            }
        }
    }

    private void renderToSuper(PoseStack matrices, VertexConsumer vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        if (EMFConfig.getConfig().renderCustomModelsGreen) {
            float flash = (float)Math.abs(Math.sin((double)System.currentTimeMillis() / 1000.0));
            super.m_104306_(matrices, vertices, light, overlay, flash, green, flash, alpha);
        } else {
            super.m_104306_(matrices, vertices, light, overlay, red, green, blue, alpha);
        }
    }

    protected void m_104290_(PoseStack.Pose entry, VertexConsumer vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        for (ModelPart.Cube cuboid : ((ModelPartAccessor)((Object)this)).getCuboids()) {
            cuboid.m_171332_(entry, vertexConsumer, light, overlay, red, green, blue, alpha);
        }
    }

    public void applyDefaultModelRotates(PartPose defaults) {
        if (defaults != null) {
            this.m_171322_(defaults);
            this.m_233560_(defaults);
            if (this.allKnownStateVariants.containsKey(0) && this.allKnownStateVariants.size() == 1) {
                this.allKnownStateVariants.put(0, (Object)this.getCurrentState());
            }
        }
    }

    public void setPartAsTopLevelRoot() {
        this.isTopLevelModelRoot = true;
    }

    public Object2ReferenceOpenHashMap<String, EMFModelPartMutable> getAllChildPartsAsMap() {
        Object2ReferenceOpenHashMap list = new Object2ReferenceOpenHashMap();
        for (ModelPart part : ((ModelPartAccessor)((Object)this)).getChildren().values()) {
            String thisKey;
            if (!(part instanceof EMFModelPartMutable)) continue;
            EMFModelPartMutable part3 = (EMFModelPartMutable)part;
            String string = thisKey = part3.selfModelData == null ? String.valueOf(((Object)((Object)part3)).hashCode()) : part3.selfModelData.part;
            if (thisKey == null) {
                thisKey = part3.selfModelData.id;
            }
            list.put((Object)thisKey, (Object)part3);
            list.putAll(part3.getAllChildPartsAsMap());
        }
        return list;
    }

    public String toString() {
        return "emfPart3{id=" + this.selfModelData.id + ", part=" + this.selfModelData.part + "}";
    }

    public Map<String, ModelPart> getChildrenEMF() {
        return ((ModelPartAccessor)((Object)this)).getChildren();
    }

    public void mergePartVariant(int variantNumber, EMFModelPartMutable partToMergeIntoThisAsVariant) {
        EMFModelState incomingPartState = partToMergeIntoThisAsVariant.getCurrentState();
        this.allKnownStateVariants.put(variantNumber, (Object)incomingPartState);
        for (Map.Entry<String, ModelPart> childEntry : partToMergeIntoThisAsVariant.getChildrenEMF().entrySet()) {
            ModelPart modelPart = childEntry.getValue();
            if (modelPart instanceof EMFModelPartMutable) {
                EMFModelPartMutable p2 = (EMFModelPartMutable)modelPart;
                modelPart = this.getChildrenEMF().get(childEntry.getKey());
                if (modelPart instanceof EMFModelPartMutable) {
                    EMFModelPartMutable p3 = (EMFModelPartMutable)modelPart;
                    p3.mergePartVariant(variantNumber, p2);
                    continue;
                }
            }
            Map<String, ModelPart> children = this.getChildrenEMF();
            children.put(childEntry.getKey(), childEntry.getValue());
        }
    }

    public void mergeInVanillaWhereRequired(ModelPart partToMergeIntoThisAsVanilla) {
        if (this.selfModelData != null && this.selfModelData.thisNeedsToMergeWithVanilla) {
            EMFModelState incomingPartState = this.getStateOf(partToMergeIntoThisAsVanilla);
            this.setFromState(incomingPartState);
        }
        for (Map.Entry<String, ModelPart> childEntry : this.getChildrenEMF().entrySet()) {
            ModelPart modelPart;
            if (!partToMergeIntoThisAsVanilla.m_233562_(childEntry.getKey()) || !((modelPart = childEntry.getValue()) instanceof EMFModelPartMutable)) continue;
            EMFModelPartMutable p3 = (EMFModelPartMutable)modelPart;
            p3.mergeInVanillaWhereRequired(partToMergeIntoThisAsVanilla.m_171324_(childEntry.getKey()));
        }
    }

    public void setVariantStateTo(int newVariantState) {
        if (this.currentModelVariantState != newVariantState) {
            if (this.allKnownStateVariants.containsKey(newVariantState)) {
                this.currentModelVariantState = newVariantState;
                this.setFromState((EMFModelState)this.allKnownStateVariants.get(newVariantState));
                this.isValidToRenderInThisState = true;
            } else if (this.selfModelData != null && this.selfModelData.part == null) {
                this.currentModelVariantState = newVariantState;
                this.isValidToRenderInThisState = false;
            } else {
                EMFUtils.EMFModWarn("no state for top level part????");
                this.currentModelVariantState = newVariantState;
                this.isValidToRenderInThisState = false;
            }
            for (ModelPart part : this.getChildrenEMF().values()) {
                if (!(part instanceof EMFModelPartMutable)) continue;
                EMFModelPartMutable p3 = (EMFModelPartMutable)part;
                p3.setVariantStateTo(newVariantState);
            }
        }
    }

    private EMFModelState getCurrentState() {
        return new EMFModelState(this.m_233566_(), ((ModelPartAccessor)((Object)this)).getCuboids(), this.f_233553_, this.f_233554_, this.f_233555_, this.f_104207_, this.f_233556_);
    }

    private EMFModelState getStateOf(ModelPart modelPart) {
        return new EMFModelState(modelPart.m_233566_(), ((ModelPartAccessor)modelPart).getCuboids(), modelPart.f_233553_, modelPart.f_233554_, modelPart.f_233555_, modelPart.f_104207_, modelPart.f_233556_);
    }

    private void setFromState(EMFModelState newState) {
        this.m_233560_(newState.defaultTransform());
        this.m_171322_(this.m_233566_());
        ((ModelPartAccessor)((Object)this)).setCuboids(newState.cuboids());
        this.f_233553_ = newState.xScale();
        this.f_233554_ = newState.yScale();
        this.f_233555_ = newState.zScale();
        this.f_104207_ = newState.visible();
        this.f_233556_ = newState.hidden();
    }

    private record EMFModelState(PartPose defaultTransform, List<ModelPart.Cube> cuboids, float xScale, float yScale, float zScale, boolean visible, boolean hidden) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class EMFCuboid
    extends ModelPart.Cube {
        public final float minXEMF;
        public final float minYEMF;
        public final float minZEMF;
        public final float maxXEMF;
        public final float maxYEMF;
        public final float maxZEMF;
        private final ModelPart.Polygon[] sidesEMF;

        public EMFCuboid(EMFPartData selfModelData, float textureU, float textureV, float cubeX, float cubeY, float cubeZ, float sizeX, float sizeY, float sizeZ, float extraX, float extraY, float extraZ, float textureWidth, float textureHeight, boolean mirrorU, boolean mirrorV) {
            ArrayList<ModelPart.Polygon> sides;
            block25: {
                float r;
                float q;
                float o;
                float n;
                ModelPart.Vertex vertex8;
                ModelPart.Vertex vertex7;
                ModelPart.Vertex vertex6;
                ModelPart.Vertex vertex5;
                block24: {
                    float l;
                    ModelPart.Vertex vertex4;
                    ModelPart.Vertex vertex3;
                    ModelPart.Vertex vertex2;
                    ModelPart.Vertex vertex;
                    block23: {
                        float k;
                        block22: {
                            float j;
                            block21: {
                                float p;
                                float m;
                                block20: {
                                    super((int)textureU, (int)textureV, cubeX, cubeY, cubeZ, sizeX, sizeY, sizeZ, extraX, extraY, extraZ, false, textureWidth, textureHeight);
                                    CuboidAccessor accessor = (CuboidAccessor)((Object)this);
                                    accessor.setMinX(cubeX);
                                    this.minXEMF = cubeX;
                                    accessor.setMinY(cubeY);
                                    this.minYEMF = cubeY;
                                    accessor.setMinZ(cubeZ);
                                    this.minZEMF = cubeZ;
                                    accessor.setMaxX(cubeX + sizeX);
                                    this.maxXEMF = cubeX + sizeX;
                                    accessor.setMaxY(cubeY + sizeY);
                                    this.maxYEMF = cubeY + sizeY;
                                    accessor.setMaxZ(cubeZ + sizeZ);
                                    this.maxZEMF = cubeZ + sizeZ;
                                    sides = new ArrayList<ModelPart.Polygon>();
                                    float cubeX2 = cubeX + sizeX;
                                    float cubeY2 = cubeY + sizeY;
                                    float cubeZ2 = cubeZ + sizeZ;
                                    vertex = new ModelPart.Vertex(cubeX -= extraX, cubeY -= extraY, cubeZ -= extraZ, 0.0f, 0.0f);
                                    vertex2 = new ModelPart.Vertex(cubeX2 += extraX, cubeY, cubeZ, 0.0f, 8.0f);
                                    vertex3 = new ModelPart.Vertex(cubeX2, cubeY2 += extraY, cubeZ, 8.0f, 8.0f);
                                    vertex4 = new ModelPart.Vertex(cubeX, cubeY2, cubeZ, 8.0f, 0.0f);
                                    vertex5 = new ModelPart.Vertex(cubeX, cubeY, cubeZ2 += extraZ, 0.0f, 0.0f);
                                    vertex6 = new ModelPart.Vertex(cubeX2, cubeY, cubeZ2, 0.0f, 8.0f);
                                    vertex7 = new ModelPart.Vertex(cubeX2, cubeY2, cubeZ2, 8.0f, 8.0f);
                                    vertex8 = new ModelPart.Vertex(cubeX, cubeY2, cubeZ2, 8.0f, 0.0f);
                                    j = textureU;
                                    k = textureU + sizeZ;
                                    l = textureU + sizeZ + sizeX;
                                    m = textureU + sizeZ + sizeX + sizeX;
                                    n = textureU + sizeZ + sizeX + sizeZ;
                                    o = textureU + sizeZ + sizeX + sizeZ + sizeX;
                                    p = textureV;
                                    q = textureV + sizeZ;
                                    r = textureV + sizeZ + sizeY;
                                    try {
                                        ModelPart.Vertex[] vertexArray;
                                        if (mirrorV) {
                                            ModelPart.Vertex[] vertexArray2 = new ModelPart.Vertex[4];
                                            vertexArray2[0] = vertex3;
                                            vertexArray2[1] = vertex4;
                                            vertexArray2[2] = vertex8;
                                            vertexArray = vertexArray2;
                                            vertexArray2[3] = vertex7;
                                        } else {
                                            ModelPart.Vertex[] vertexArray3 = new ModelPart.Vertex[4];
                                            vertexArray3[0] = vertex6;
                                            vertexArray3[1] = vertex5;
                                            vertexArray3[2] = vertex;
                                            vertexArray = vertexArray3;
                                            vertexArray3[3] = vertex2;
                                        }
                                        sides.add(new ModelPart.Polygon(vertexArray, mirrorU ? l : k, mirrorV ? q : p, mirrorU ? k : l, mirrorV ? p : q, textureWidth, textureHeight, false, mirrorV ? Direction.UP : Direction.DOWN));
                                    }
                                    catch (Exception e) {
                                        if (!EMFConfig.getConfig().printModelCreationInfoToLog) break block20;
                                        EMFUtils.EMFModMessage("uv-dwn failed for " + selfModelData.id);
                                    }
                                }
                                try {
                                    ModelPart.Vertex[] vertexArray;
                                    if (mirrorV) {
                                        ModelPart.Vertex[] vertexArray4 = new ModelPart.Vertex[4];
                                        vertexArray4[0] = vertex6;
                                        vertexArray4[1] = vertex5;
                                        vertexArray4[2] = vertex;
                                        vertexArray = vertexArray4;
                                        vertexArray4[3] = vertex2;
                                    } else {
                                        ModelPart.Vertex[] vertexArray5 = new ModelPart.Vertex[4];
                                        vertexArray5[0] = vertex3;
                                        vertexArray5[1] = vertex4;
                                        vertexArray5[2] = vertex8;
                                        vertexArray = vertexArray5;
                                        vertexArray5[3] = vertex7;
                                    }
                                    sides.add(new ModelPart.Polygon(vertexArray, mirrorU ? m : l, mirrorV ? p : q, mirrorU ? l : m, mirrorV ? q : p, textureWidth, textureHeight, false, mirrorV ? Direction.DOWN : Direction.UP));
                                }
                                catch (Exception e) {
                                    if (!EMFConfig.getConfig().printModelCreationInfoToLog) break block21;
                                    EMFUtils.EMFModMessage("uv-up failed for " + selfModelData.id);
                                }
                            }
                            try {
                                ModelPart.Vertex[] vertexArray;
                                if (mirrorU) {
                                    ModelPart.Vertex[] vertexArray6 = new ModelPart.Vertex[4];
                                    vertexArray6[0] = vertex6;
                                    vertexArray6[1] = vertex2;
                                    vertexArray6[2] = vertex3;
                                    vertexArray = vertexArray6;
                                    vertexArray6[3] = vertex7;
                                } else {
                                    ModelPart.Vertex[] vertexArray7 = new ModelPart.Vertex[4];
                                    vertexArray7[0] = vertex;
                                    vertexArray7[1] = vertex5;
                                    vertexArray7[2] = vertex8;
                                    vertexArray = vertexArray7;
                                    vertexArray7[3] = vertex4;
                                }
                                sides.add(new ModelPart.Polygon(vertexArray, mirrorU ? k : j, mirrorV ? r : q, mirrorU ? j : k, mirrorV ? q : r, textureWidth, textureHeight, false, mirrorU ? Direction.EAST : Direction.WEST));
                            }
                            catch (Exception e) {
                                if (!EMFConfig.getConfig().printModelCreationInfoToLog) break block22;
                                EMFUtils.EMFModMessage("uv-west failed for " + selfModelData.id);
                            }
                        }
                        try {
                            sides.add(new ModelPart.Polygon(new ModelPart.Vertex[]{vertex2, vertex, vertex4, vertex3}, mirrorU ? l : k, mirrorV ? r : q, mirrorU ? k : l, mirrorV ? q : r, textureWidth, textureHeight, false, Direction.NORTH));
                        }
                        catch (Exception e) {
                            if (!EMFConfig.getConfig().printModelCreationInfoToLog) break block23;
                            EMFUtils.EMFModMessage("uv-nrth failed for " + selfModelData.id);
                        }
                    }
                    try {
                        ModelPart.Vertex[] vertexArray;
                        if (mirrorU) {
                            ModelPart.Vertex[] vertexArray8 = new ModelPart.Vertex[4];
                            vertexArray8[0] = vertex;
                            vertexArray8[1] = vertex5;
                            vertexArray8[2] = vertex8;
                            vertexArray = vertexArray8;
                            vertexArray8[3] = vertex4;
                        } else {
                            ModelPart.Vertex[] vertexArray9 = new ModelPart.Vertex[4];
                            vertexArray9[0] = vertex6;
                            vertexArray9[1] = vertex2;
                            vertexArray9[2] = vertex3;
                            vertexArray = vertexArray9;
                            vertexArray9[3] = vertex7;
                        }
                        sides.add(new ModelPart.Polygon(vertexArray, mirrorU ? n : l, mirrorV ? r : q, mirrorU ? l : n, mirrorV ? q : r, textureWidth, textureHeight, false, mirrorU ? Direction.WEST : Direction.EAST));
                    }
                    catch (Exception e) {
                        if (!EMFConfig.getConfig().printModelCreationInfoToLog) break block24;
                        EMFUtils.EMFModMessage("uv-east failed for " + selfModelData.id);
                    }
                }
                try {
                    sides.add(new ModelPart.Polygon(new ModelPart.Vertex[]{vertex5, vertex6, vertex7, vertex8}, mirrorU ? o : n, mirrorV ? r : q, mirrorU ? n : o, mirrorV ? q : r, textureWidth, textureHeight, false, Direction.SOUTH));
                }
                catch (Exception e) {
                    if (!EMFConfig.getConfig().printModelCreationInfoToLog) break block25;
                    EMFUtils.EMFModMessage("uv-sth failed for " + selfModelData.id);
                }
            }
            this.sidesEMF = sides.toArray(new ModelPart.Polygon[0]);
            ((CuboidAccessor)((Object)this)).setSides(this.sidesEMF);
        }

        public EMFCuboid(EMFPartData selfModelData, float[] uvDown, float[] uvUp, float[] uvNorth, float[] uvSouth, float[] uvWest, float[] uvEast, float cubeX, float cubeY, float cubeZ, float sizeX, float sizeY, float sizeZ, float extraX, float extraY, float extraZ, float textureWidth, float textureHeight, boolean mirrorU, boolean mirrorV) {
            ArrayList<ModelPart.Polygon> sides;
            block25: {
                ModelPart.Vertex vertex8;
                ModelPart.Vertex vertex7;
                ModelPart.Vertex vertex6;
                ModelPart.Vertex vertex5;
                block24: {
                    ModelPart.Vertex vertex4;
                    ModelPart.Vertex vertex3;
                    ModelPart.Vertex vertex2;
                    ModelPart.Vertex vertex;
                    block23: {
                        block22: {
                            block21: {
                                block20: {
                                    super(0, 0, cubeX, cubeY, cubeZ, sizeX, sizeY, sizeZ, extraX, extraY, extraZ, false, textureWidth, textureHeight);
                                    CuboidAccessor accessor = (CuboidAccessor)((Object)this);
                                    accessor.setMinX(cubeX);
                                    this.minXEMF = cubeX;
                                    accessor.setMinY(cubeY);
                                    this.minYEMF = cubeY;
                                    accessor.setMinZ(cubeZ);
                                    this.minZEMF = cubeZ;
                                    accessor.setMaxX(cubeX + sizeX);
                                    this.maxXEMF = cubeX + sizeX;
                                    accessor.setMaxY(cubeY + sizeY);
                                    this.maxYEMF = cubeY + sizeY;
                                    accessor.setMaxZ(cubeZ + sizeZ);
                                    this.maxZEMF = cubeZ + sizeZ;
                                    sides = new ArrayList<ModelPart.Polygon>();
                                    float cubeX2 = cubeX + sizeX;
                                    float cubeY2 = cubeY + sizeY;
                                    float cubeZ2 = cubeZ + sizeZ;
                                    vertex = new ModelPart.Vertex(cubeX -= extraX, cubeY -= extraY, cubeZ -= extraZ, 0.0f, 0.0f);
                                    vertex2 = new ModelPart.Vertex(cubeX2 += extraX, cubeY, cubeZ, 0.0f, 8.0f);
                                    vertex3 = new ModelPart.Vertex(cubeX2, cubeY2 += extraY, cubeZ, 8.0f, 8.0f);
                                    vertex4 = new ModelPart.Vertex(cubeX, cubeY2, cubeZ, 8.0f, 0.0f);
                                    vertex5 = new ModelPart.Vertex(cubeX, cubeY, cubeZ2 += extraZ, 0.0f, 0.0f);
                                    vertex6 = new ModelPart.Vertex(cubeX2, cubeY, cubeZ2, 0.0f, 8.0f);
                                    vertex7 = new ModelPart.Vertex(cubeX2, cubeY2, cubeZ2, 8.0f, 8.0f);
                                    vertex8 = new ModelPart.Vertex(cubeX, cubeY2, cubeZ2, 8.0f, 0.0f);
                                    try {
                                        ModelPart.Vertex[] vertexArray;
                                        if (mirrorV) {
                                            ModelPart.Vertex[] vertexArray2 = new ModelPart.Vertex[4];
                                            vertexArray2[0] = vertex8;
                                            vertexArray2[1] = vertex7;
                                            vertexArray2[2] = vertex3;
                                            vertexArray = vertexArray2;
                                            vertexArray2[3] = vertex4;
                                        } else {
                                            ModelPart.Vertex[] vertexArray3 = new ModelPart.Vertex[4];
                                            vertexArray3[0] = vertex;
                                            vertexArray3[1] = vertex2;
                                            vertexArray3[2] = vertex6;
                                            vertexArray = vertexArray3;
                                            vertexArray3[3] = vertex5;
                                        }
                                        sides.add(new ModelPart.Polygon(vertexArray, mirrorU ? uvUp[2] : uvUp[0], mirrorV ? uvUp[3] : uvUp[1], mirrorU ? uvUp[0] : uvUp[2], mirrorV ? uvUp[1] : uvUp[3], textureWidth, textureHeight, false, mirrorV ? Direction.UP : Direction.DOWN));
                                    }
                                    catch (Exception e) {
                                        if (!EMFConfig.getConfig().printModelCreationInfoToLog) break block20;
                                        EMFUtils.EMFModMessage("uv-up failed for " + selfModelData.id);
                                    }
                                }
                                try {
                                    ModelPart.Vertex[] vertexArray;
                                    if (mirrorV) {
                                        ModelPart.Vertex[] vertexArray4 = new ModelPart.Vertex[4];
                                        vertexArray4[0] = vertex;
                                        vertexArray4[1] = vertex2;
                                        vertexArray4[2] = vertex6;
                                        vertexArray = vertexArray4;
                                        vertexArray4[3] = vertex5;
                                    } else {
                                        ModelPart.Vertex[] vertexArray5 = new ModelPart.Vertex[4];
                                        vertexArray5[0] = vertex8;
                                        vertexArray5[1] = vertex7;
                                        vertexArray5[2] = vertex3;
                                        vertexArray = vertexArray5;
                                        vertexArray5[3] = vertex4;
                                    }
                                    sides.add(new ModelPart.Polygon(vertexArray, mirrorU ? uvDown[2] : uvDown[0], mirrorV ? uvDown[3] : uvDown[1], mirrorU ? uvDown[0] : uvDown[2], mirrorV ? uvDown[1] : uvDown[3], textureWidth, textureHeight, false, mirrorV ? Direction.DOWN : Direction.UP));
                                }
                                catch (Exception e) {
                                    if (!EMFConfig.getConfig().printModelCreationInfoToLog) break block21;
                                    EMFUtils.EMFModMessage("uv-down failed for " + selfModelData.id);
                                }
                            }
                            try {
                                ModelPart.Vertex[] vertexArray;
                                if (mirrorU) {
                                    ModelPart.Vertex[] vertexArray6 = new ModelPart.Vertex[4];
                                    vertexArray6[0] = vertex;
                                    vertexArray6[1] = vertex5;
                                    vertexArray6[2] = vertex8;
                                    vertexArray = vertexArray6;
                                    vertexArray6[3] = vertex4;
                                } else {
                                    ModelPart.Vertex[] vertexArray7 = new ModelPart.Vertex[4];
                                    vertexArray7[0] = vertex6;
                                    vertexArray7[1] = vertex2;
                                    vertexArray7[2] = vertex3;
                                    vertexArray = vertexArray7;
                                    vertexArray7[3] = vertex7;
                                }
                                sides.add(new ModelPart.Polygon(vertexArray, mirrorU ? uvWest[2] : uvWest[0], mirrorV ? uvWest[3] : uvWest[1], mirrorU ? uvWest[0] : uvWest[2], mirrorV ? uvWest[1] : uvWest[3], textureWidth, textureHeight, false, mirrorU ? Direction.WEST : Direction.EAST));
                            }
                            catch (Exception e) {
                                if (!EMFConfig.getConfig().printModelCreationInfoToLog) break block22;
                                EMFUtils.EMFModMessage("uv-west failed for " + selfModelData.id);
                            }
                        }
                        try {
                            sides.add(new ModelPart.Polygon(new ModelPart.Vertex[]{vertex2, vertex, vertex4, vertex3}, mirrorU ? uvNorth[2] : uvNorth[0], mirrorV ? uvNorth[3] : uvNorth[1], mirrorU ? uvNorth[0] : uvNorth[2], mirrorV ? uvNorth[1] : uvNorth[3], textureWidth, textureHeight, false, Direction.NORTH));
                        }
                        catch (Exception e) {
                            if (!EMFConfig.getConfig().printModelCreationInfoToLog) break block23;
                            EMFUtils.EMFModMessage("uv-north failed for " + selfModelData.id);
                        }
                    }
                    try {
                        ModelPart.Vertex[] vertexArray;
                        if (mirrorU) {
                            ModelPart.Vertex[] vertexArray8 = new ModelPart.Vertex[4];
                            vertexArray8[0] = vertex6;
                            vertexArray8[1] = vertex2;
                            vertexArray8[2] = vertex3;
                            vertexArray = vertexArray8;
                            vertexArray8[3] = vertex7;
                        } else {
                            ModelPart.Vertex[] vertexArray9 = new ModelPart.Vertex[4];
                            vertexArray9[0] = vertex;
                            vertexArray9[1] = vertex5;
                            vertexArray9[2] = vertex8;
                            vertexArray = vertexArray9;
                            vertexArray9[3] = vertex4;
                        }
                        sides.add(new ModelPart.Polygon(vertexArray, mirrorU ? uvEast[2] : uvEast[0], mirrorV ? uvEast[3] : uvEast[1], mirrorU ? uvEast[0] : uvEast[2], mirrorV ? uvEast[1] : uvEast[3], textureWidth, textureHeight, false, mirrorU ? Direction.EAST : Direction.WEST));
                    }
                    catch (Exception e) {
                        if (!EMFConfig.getConfig().printModelCreationInfoToLog) break block24;
                        EMFUtils.EMFModMessage("uv-east failed for " + selfModelData.id);
                    }
                }
                try {
                    sides.add(new ModelPart.Polygon(new ModelPart.Vertex[]{vertex5, vertex6, vertex7, vertex8}, mirrorU ? uvSouth[2] : uvSouth[0], mirrorV ? uvSouth[3] : uvSouth[1], mirrorU ? uvSouth[0] : uvSouth[2], mirrorV ? uvSouth[1] : uvSouth[3], textureWidth, textureHeight, false, Direction.SOUTH));
                }
                catch (Exception e) {
                    if (!EMFConfig.getConfig().printModelCreationInfoToLog) break block25;
                    EMFUtils.EMFModMessage("uv-south failed for " + selfModelData.id);
                }
            }
            this.sidesEMF = sides.toArray(new ModelPart.Polygon[0]);
            ((CuboidAccessor)((Object)this)).setSides(this.sidesEMF);
        }
    }
}

