/*
 * Decompiled with CFR 0.152.
 */
package com.dolthhaven.doltcompat;

import com.dolthhaven.doltcompat.common.registry.DoltCompatParticles;
import com.dolthhaven.doltcompat.core.DoltCompatConfig;
import com.dolthhaven.doltcompat.core.compat.DoltCompatCompat;
import com.dolthhaven.doltcompat.core.compat.DoltCompatVillaging;
import com.dolthhaven.doltcompat.core.data.tags.DoltCompatAdvancementMods;
import com.dolthhaven.doltcompat.core.data.tags.DoltSecretBlockTags;
import com.mojang.logging.LogUtils;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="dolt_compat")
public class DoltCompat {
    public static final String MOD_ID = "dolt_compat";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("dolt_compat");

    public DoltCompat() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext context = ModLoadingContext.get();
        bus.addListener(this::commonSetup);
        bus.addListener(this::dataSetup);
        DoltCompatParticles.PARTICLE_TYPES.register(bus);
        REGISTRY_HELPER.register(bus);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)DoltCompatConfig.Common.COMMON_SPEC);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            DoltCompatCompat.registerCompat();
            DoltCompatVillaging.registerAllVillaging();
        });
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper EFH = event.getExistingFileHelper();
        boolean includeServer = event.includeServer();
        DoltSecretBlockTags taggies = new DoltSecretBlockTags(generator, EFH);
        generator.m_236039_(includeServer, (DataProvider)taggies);
        generator.m_236039_(includeServer, (DataProvider)new DoltCompatAdvancementMods(generator));
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @Mod.EventBusSubscriber(modid="dolt_compat", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }
    }
}

