/*
 * Decompiled with CFR 0.152.
 */
package com.mangomilk.design_decor.blocks.containers.green;

import com.mangomilk.design_decor.blocks.containers.green.GreenContainerBlockEntity;
import com.mangomilk.design_decor.registry.CDDBlockEntities;
import com.mangomilk.design_decor.registry.CDDBlocks;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.item.ItemHelper;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.ForgeSoundType;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class GreenContainerBlock
extends Block
implements IWrenchable,
IBE<GreenContainerBlockEntity> {
    public static final Property<Direction.Axis> HORIZONTAL_AXIS = BlockStateProperties.f_61364_;
    public static final BooleanProperty LARGE = BooleanProperty.m_61465_((String)"large");
    public static final SoundType SILENCED_METAL = new ForgeSoundType(0.1f, 1.5f, () -> SoundEvents.f_12198_, () -> SoundEvents.f_12199_, () -> SoundEvents.f_12200_, () -> SoundEvents.f_12201_, () -> SoundEvents.f_12202_);

    public GreenContainerBlock(BlockBehaviour.Properties p_i48440_1_) {
        super(p_i48440_1_);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)LARGE, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{HORIZONTAL_AXIS, LARGE});
        super.m_7926_(pBuilder);
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState placedOn;
        Direction.Axis preferredAxis;
        if (!(pContext.m_43723_() != null && pContext.m_43723_().m_20161_() || (preferredAxis = GreenContainerBlock.getContainerBlockAxis(placedOn = pContext.m_43725_().m_8055_(pContext.m_8083_().m_121945_(pContext.m_43719_().m_122424_())))) == null)) {
            return (BlockState)this.m_49966_().m_61124_(HORIZONTAL_AXIS, (Comparable)preferredAxis);
        }
        return (BlockState)this.m_49966_().m_61124_(HORIZONTAL_AXIS, (Comparable)pContext.m_8125_().m_122434_());
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (pOldState.m_60734_() == pState.m_60734_()) {
            return;
        }
        if (pIsMoving) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)pLevel, pPos, GreenContainerBlockEntity::updateConnectivity);
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        if (context.m_43719_().m_122434_().m_122478_()) {
            BlockEntity be = context.m_43725_().m_7702_(context.m_8083_());
            if (be instanceof GreenContainerBlockEntity) {
                GreenContainerBlockEntity container = (GreenContainerBlockEntity)be;
                ConnectivityHandler.splitMulti((BlockEntity)container);
                container.removeController(true);
            }
            state = (BlockState)state.m_61124_((Property)LARGE, (Comparable)Boolean.valueOf(false));
        }
        InteractionResult onWrenched = super.onWrenched(state, context);
        return onWrenched;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean pIsMoving) {
        if (state.m_155947_() && (state.m_60734_() != newState.m_60734_() || !newState.m_155947_())) {
            BlockEntity be = world.m_7702_(pos);
            if (!(be instanceof GreenContainerBlockEntity)) {
                return;
            }
            GreenContainerBlockEntity containerBE = (GreenContainerBlockEntity)be;
            ItemHelper.dropContents((Level)world, (BlockPos)pos, (IItemHandler)containerBE.inventory);
            world.m_46747_(pos);
            ConnectivityHandler.splitMulti((BlockEntity)containerBE);
        }
    }

    public static boolean isContainer(BlockState state) {
        return CDDBlocks.GREEN_CONTAINER.has(state);
    }

    @Nullable
    public static Direction.Axis getContainerBlockAxis(BlockState state) {
        if (!GreenContainerBlock.isContainer(state)) {
            return null;
        }
        return (Direction.Axis)state.m_61143_(HORIZONTAL_AXIS);
    }

    public static boolean isLarge(BlockState state) {
        if (!GreenContainerBlock.isContainer(state)) {
            return false;
        }
        return (Boolean)state.m_61143_((Property)LARGE);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_(HORIZONTAL_AXIS);
        return (BlockState)state.m_61124_(HORIZONTAL_AXIS, (Comparable)rot.m_55954_(Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE)).m_122434_());
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state;
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, Entity entity) {
        SoundType soundType = super.getSoundType(state, world, pos, entity);
        if (entity != null && entity.getPersistentData().m_128441_("SilenceVaultSound")) {
            return SILENCED_METAL;
        }
        return soundType;
    }

    public boolean m_7278_(BlockState p_149740_1_) {
        return true;
    }

    public int m_6782_(BlockState pState, Level pLevel, BlockPos pPos) {
        return this.getBlockEntityOptional((BlockGetter)pLevel, pPos).map(vte -> vte.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)).map(lo -> lo.map(ItemHelper::calcRedstoneFromInventory).orElse(0)).orElse(0);
    }

    public BlockEntityType<? extends GreenContainerBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CDDBlockEntities.GREEN_CONTAINER.get();
    }

    public Class<GreenContainerBlockEntity> getBlockEntityClass() {
        return GreenContainerBlockEntity.class;
    }
}

