/*
 * Decompiled with CFR 0.152.
 */
package com.mangomilk.design_decor.blocks.catwalks;

import com.mangomilk.design_decor.registry.CDDShapes;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.placement.IPlacementHelper;
import com.simibubi.create.foundation.placement.PlacementHelpers;
import com.simibubi.create.foundation.placement.PlacementOffset;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CatwalkBlock
extends Block
implements IWrenchable,
SimpleWaterloggedBlock {
    public static final BooleanProperty DOWN = BooleanProperty.m_61465_((String)"turned_on");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());

    public CatwalkBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_54562_, BlockPos p_54563_, CollisionContext p_54564_) {
        if (((Boolean)state.m_61143_((Property)DOWN)).booleanValue()) {
            return CDDShapes.CATWALK_DOWN;
        }
        return CDDShapes.CATWALK;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_55125_) {
        p_55125_.m_61104_(new Property[]{DOWN, WATERLOGGED});
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        InteractionResult onWrenched = super.onWrenched(state, context);
        if (!onWrenched.m_19077_()) {
            return onWrenched;
        }
        boolean isOn = (Boolean)state.m_61143_((Property)DOWN);
        context.m_43725_().m_7731_(context.m_8083_(), (BlockState)state.m_61124_((Property)DOWN, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)DOWN) == false)), 2);
        this.playRotateSound(context.m_43725_(), context.m_8083_());
        return onWrenched;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        if (!player.m_6144_() && player.m_36326_()) {
            ItemStack heldItem = player.m_21120_(hand);
            IPlacementHelper placementHelper = PlacementHelpers.get((int)placementHelperId);
            if (placementHelper.matchesItem(heldItem)) {
                placementHelper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)heldItem.m_41720_(), player, hand, ray);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6227_(state, world, pos, player, hand, ray);
    }

    public FluidState m_5888_(BlockState p_51475_) {
        return (Boolean)p_51475_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_51475_);
    }

    public BlockState m_7417_(BlockState p_51461_, Direction p_51462_, BlockState p_51463_, LevelAccessor p_51464_, BlockPos p_51465_, BlockPos p_51466_) {
        if (((Boolean)p_51461_.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            p_51464_.m_186469_(p_51465_, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)p_51464_));
        }
        return super.m_7417_(p_51461_, p_51462_, p_51463_, p_51464_, p_51465_, p_51466_);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext p_58126_) {
        FluidState fluidstate = p_58126_.m_43725_().m_6425_(p_58126_.m_8083_());
        boolean flag = fluidstate.m_76152_() == Fluids.f_76193_;
        BlockState blockstate = this.m_49966_();
        Level levelreader = p_58126_.m_43725_();
        BlockPos blockpos = p_58126_.m_8083_();
        int n = 0;
        Direction[] adirection = p_58126_.m_6232_();
        Direction[] directionArray = adirection;
        int n2 = directionArray.length;
        if (n < n2) {
            Direction direction = directionArray[n];
            Direction direction1 = direction.m_122424_();
            blockstate = (BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
            return blockstate;
        }
        return (BlockState)Objects.requireNonNull(super.m_5573_(p_58126_)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    implements IPlacementHelper {
        private PlacementHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return i -> i.m_41720_() instanceof BlockItem && ((BlockItem)i.m_41720_()).m_40614_() instanceof CatwalkBlock;
        }

        public Predicate<BlockState> getStatePredicate() {
            return s -> s.m_60734_() instanceof CatwalkBlock;
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            List directions = IPlacementHelper.orderedByDistanceExceptAxis((BlockPos)pos, (Vec3)ray.m_82450_(), (Direction.Axis)Direction.UP.m_122434_(), dir -> world.m_8055_(pos.m_121945_(dir)).m_60767_().m_76336_());
            boolean down = (Boolean)state.m_61143_((Property)DOWN);
            if (directions.isEmpty()) {
                return PlacementOffset.fail();
            }
            return PlacementOffset.success((Vec3i)pos.m_121945_((Direction)directions.get(0)), s -> (BlockState)s.m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(down)));
        }
    }
}

