/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.utility;

import com.copycatsplus.copycats.content.copycat.slice.CopycatSliceBlock;
import com.mojang.math.OctahedralGroup;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockUtils {
    public static BlockState tryCopyProperties(BlockState from, BlockState to) {
        for (Property property : from.m_61147_()) {
            to = BlockUtils.tryCopyProperty(from, to, property);
        }
        return to;
    }

    public static <T extends Comparable<T>> BlockState tryCopyProperty(BlockState from, BlockState to, Property<T> property) {
        if (from.m_61138_(property) && to.m_61138_(property)) {
            return (BlockState)to.m_61124_(property, from.m_61143_(property));
        }
        return to;
    }

    public static Direction transformFacing(StructureTransform transform, Direction facing) {
        if (transform.mirror != null && transform.mirror != Mirror.NONE) {
            facing = transform.mirrorFacing(facing);
        }
        if (transform.rotationAxis != null) {
            facing = transform.rotateFacing(facing);
        }
        return facing;
    }

    public static BlockState transformStepLikeHorizontal(BlockState state, StructureTransform transform, BlockState verticalState) {
        if (transform.mirror != null && transform.mirror != Mirror.NONE) {
            state = transform.mirror.m_54842_() == OctahedralGroup.INVERT_Y ? (BlockState)state.m_61122_(CopycatSliceBlock.HALF) : (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)transform.mirror.m_54848_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
        }
        if (transform.rotationAxis != null) {
            if (transform.rotationAxis == Direction.Axis.Y) {
                state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)transform.rotateFacing((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
            } else {
                Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
                Half half = (Half)state.m_61143_(CopycatSliceBlock.HALF);
                if (transform.rotationAxis == facing.m_122434_()) {
                    if (transform.rotation == Rotation.CLOCKWISE_180) {
                        state = (BlockState)state.m_61122_(CopycatSliceBlock.HALF);
                    } else if (transform.rotation != Rotation.NONE) {
                        Direction offset = transform.rotateFacing(half == Half.TOP ? Direction.UP : Direction.DOWN);
                        boolean isClockwise = offset == facing.m_122427_();
                        state = (BlockState)BlockUtils.tryCopyProperties(state, verticalState).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)(isClockwise ? facing.m_122427_() : facing));
                    }
                } else {
                    state = BlockUtils.setApparentDirection(state, transform.rotateFacing(BlockUtils.getApparentDirection(state)));
                }
            }
        }
        return state;
    }

    public static BlockState transformStepLikeVertical(BlockState state, StructureTransform transform, BlockState horizontalState) {
        if (transform.mirror != null && transform.mirror != Mirror.NONE) {
            Direction.Axis mirrorAxis = null;
            for (Direction.Axis axis : Iterate.axes) {
                if (!transform.mirror.m_54842_().m_56526_(axis)) continue;
                mirrorAxis = axis;
                break;
            }
            if (mirrorAxis != null && !mirrorAxis.m_122478_()) {
                Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
                state = facing.m_122434_() != mirrorAxis ? (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facing.m_122427_()) : (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facing.m_122428_());
            }
        }
        if (transform.rotationAxis != null) {
            if (transform.rotationAxis == Direction.Axis.Y) {
                state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)transform.rotateFacing((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
            } else {
                Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
                if (facing.m_122434_() == transform.rotationAxis) {
                    if (transform.rotation == Rotation.CLOCKWISE_180) {
                        state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facing.m_122427_());
                    } else if (transform.rotation != Rotation.NONE) {
                        state = (BlockState)((BlockState)BlockUtils.tryCopyProperties(state, horizontalState).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facing)).m_61124_(CopycatSliceBlock.HALF, (Comparable)(transform.rotation == Rotation.CLOCKWISE_90 == (facing.m_122421_() == Direction.AxisDirection.POSITIVE) ? Half.BOTTOM : Half.TOP));
                    }
                } else if (transform.rotation == Rotation.CLOCKWISE_180) {
                    state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facing.m_122428_());
                } else if (transform.rotation != Rotation.NONE) {
                    state = (BlockState)((BlockState)BlockUtils.tryCopyProperties(state, horizontalState).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facing.m_122428_())).m_61124_(CopycatSliceBlock.HALF, (Comparable)(transform.rotation == Rotation.CLOCKWISE_90 == (facing.m_122421_() == Direction.AxisDirection.POSITIVE) == (facing.m_122434_() == Direction.Axis.X) ? Half.BOTTOM : Half.TOP));
                }
            }
        }
        return state;
    }

    public static Direction getApparentDirection(BlockState state) {
        boolean aligned;
        boolean positive;
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        Half half = (Half)state.m_61143_(CopycatSliceBlock.HALF);
        boolean bl = positive = facing.m_122421_() == Direction.AxisDirection.POSITIVE;
        if (facing.m_122434_() == Direction.Axis.X) {
            boolean aligned2;
            boolean bl2 = aligned2 = positive == (half == Half.TOP);
            return aligned2 ? facing : (positive ? Direction.DOWN : Direction.UP);
        }
        boolean bl3 = aligned = positive == (half == Half.BOTTOM);
        return aligned ? facing : (positive ? Direction.UP : Direction.DOWN);
    }

    public static BlockState setApparentDirection(BlockState state, Direction direction) {
        Direction.Axis axis = ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122434_();
        if (axis == Direction.Axis.X) {
            return switch (direction) {
                case Direction.UP -> (BlockState)((BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.WEST)).m_61124_(CopycatSliceBlock.HALF, (Comparable)Half.TOP);
                case Direction.DOWN -> (BlockState)((BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.EAST)).m_61124_(CopycatSliceBlock.HALF, (Comparable)Half.BOTTOM);
                case Direction.EAST -> (BlockState)((BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.EAST)).m_61124_(CopycatSliceBlock.HALF, (Comparable)Half.TOP);
                case Direction.WEST -> (BlockState)((BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.WEST)).m_61124_(CopycatSliceBlock.HALF, (Comparable)Half.BOTTOM);
                default -> throw new IllegalStateException("Unexpected value: " + direction);
            };
        }
        return switch (direction) {
            case Direction.UP -> (BlockState)((BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.SOUTH)).m_61124_(CopycatSliceBlock.HALF, (Comparable)Half.TOP);
            case Direction.DOWN -> (BlockState)((BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH)).m_61124_(CopycatSliceBlock.HALF, (Comparable)Half.BOTTOM);
            case Direction.NORTH -> (BlockState)((BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH)).m_61124_(CopycatSliceBlock.HALF, (Comparable)Half.TOP);
            case Direction.SOUTH -> (BlockState)((BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.SOUTH)).m_61124_(CopycatSliceBlock.HALF, (Comparable)Half.BOTTOM);
            default -> throw new IllegalStateException("Unexpected value: " + direction);
        };
    }
}

